/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.properties.SimpleContentPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.properties.XSDComboBoxPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.wst.xsd.ui.internal.util.XSDSchemaHelper;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.impl.XSDFactoryImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleRestrictPropertySource
extends BasePropertySource
implements IPropertySource {
    private String BASE_TYPE_ID = XSDEditorPlugin.getXSDString("_UI_LABEL_BASE_TYPE");
    private String[] whiteSpaceComboChoices = new String[]{"", "preserve", "replace", "collapse"};
    protected boolean isAnonymous;
    protected XSDSimpleTypeDefinition xsdSimpleType;

    public SimpleRestrictPropertySource() {
    }

    public SimpleRestrictPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public SimpleRestrictPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> list = new ArrayList<Object>();
        SimpleContentPropertyDescriptor typeDescriptor = new SimpleContentPropertyDescriptor("base", "base", (Element)this.element.getParentNode(), this.xsdSchema);
        list.add((Object)typeDescriptor);
        Iterator facets = this.xsdSimpleType.getValidFacets().iterator();
        while (facets.hasNext()) {
            String aValidFacet = (String)facets.next();
            if (aValidFacet.equals("pattern") || aValidFacet.equals("enumeration")) continue;
            if (aValidFacet.equals("whiteSpace")) {
                XSDComboBoxPropertyDescriptor whitespaceDescriptor = new XSDComboBoxPropertyDescriptor(aValidFacet, aValidFacet, this.whiteSpaceComboChoices);
                list.add((Object)whitespaceDescriptor);
                continue;
            }
            list.add(new TextPropertyDescriptor((Object)aValidFacet, aValidFacet));
        }
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            if (((String)id).equals("base")) {
                String baseType = this.element.getAttribute("base");
                if (baseType == null) {
                    baseType = "";
                }
                return baseType;
            }
            String aFacet = (String)id;
            Iterator facets = this.xsdSimpleType.getFacets().iterator();
            while (facets.hasNext()) {
                XSDFacet aValidFacet = (XSDFacet)facets.next();
                if (!aValidFacet.getFacetName().equals(aFacet)) continue;
                result = aValidFacet.getLexicalValue();
                if (result == null) {
                    result = "";
                }
                return result;
            }
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value != null && value instanceof String) {
            String newValue = (String)value;
            this.getDomHelper().getBaseType(this.element);
            if (((String)id).equals("base")) {
                this.element.getOwnerDocument();
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_TYPE_CHANGE"), this.element);
                Element parent = (Element)this.element.getParentNode();
                XSDDOMHelper.inputEquals(parent, "simpleType", false);
                this.getDomHelper().setSimpleContentType(this.element, newValue);
                this.endRecording(this.element);
            } else {
                Element simpleTypeElement = this.xsdSimpleType.getElement();
                XSDDOMHelper xsdDOMHelper = new XSDDOMHelper();
                Element derivedByElement = xsdDOMHelper.getDerivedByElement(simpleTypeElement);
                this.beginRecording(XSDEditorPlugin.getXSDString("_UI_FACET_CHANGE"), simpleTypeElement);
                String prefix = simpleTypeElement.getPrefix();
                prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
                String aFacet = (String)id;
                XSDFactoryImpl factory = new XSDFactoryImpl();
                Element childNodeElement = null;
                DOMAttribute valueAttr = null;
                XSDTotalDigitsFacet facet = null;
                if (aFacet.equals("totalDigits")) {
                    facet = this.xsdSimpleType.getTotalDigitsFacet();
                } else if (aFacet.equals("fractionDigits")) {
                    facet = this.xsdSimpleType.getFractionDigitsFacet();
                } else if (aFacet.equals("whiteSpace")) {
                    facet = this.xsdSimpleType.getWhiteSpaceFacet();
                } else if (aFacet.equals("maxExclusive")) {
                    facet = this.xsdSimpleType.getMaxExclusiveFacet();
                } else if (aFacet.equals("maxInclusive")) {
                    facet = this.xsdSimpleType.getMaxInclusiveFacet();
                } else if (aFacet.equals("minExclusive")) {
                    facet = this.xsdSimpleType.getMinExclusiveFacet();
                } else if (aFacet.equals("minInclusive")) {
                    facet = this.xsdSimpleType.getMinInclusiveFacet();
                } else if (aFacet.equals("length")) {
                    facet = this.xsdSimpleType.getLengthFacet();
                } else if (aFacet.equals("maxLength")) {
                    facet = this.xsdSimpleType.getMaxLengthFacet();
                } else if (aFacet.equals("minLength")) {
                    facet = this.xsdSimpleType.getMinLengthFacet();
                }
                if (facet != null) {
                    facet.setLexicalValue(newValue);
                } else {
                    facet = factory.createXSDTotalDigitsFacet();
                    childNodeElement = derivedByElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + aFacet);
                    valueAttr = new DOMAttribute("value", "");
                    childNodeElement.setAttribute(valueAttr.getName(), valueAttr.getValue());
                    valueAttr.setValue(newValue);
                    childNodeElement.setAttribute(valueAttr.getName(), valueAttr.getValue());
                    this.hasElementChildren(derivedByElement);
                    this.element.appendChild(childNodeElement);
                }
                XSDSchemaHelper.updateElement((XSDConcreteComponent)this.xsdSimpleType);
                if (facet != null) {
                    XSDSchemaHelper.updateElement((XSDConcreteComponent)facet);
                }
            }
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (SimpleRestrictPropertySource.this.viewer != null) {
                    SimpleRestrictPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }

    public void setInput(Element element) {
        this.element = element;
        if (this.xsdSchema == null) {
            return;
        }
        element.getLocalName();
        this.isAnonymous = this.checkForAnonymousType(element);
        if (XSDDOMHelper.inputEquals(element, "restriction", false)) {
            element.getAttribute("base");
            Element parent = (Element)element.getParentNode();
            if (XSDDOMHelper.inputEquals(parent, "simpleContent", false)) {
                Element grandparent = (Element)parent.getParentNode();
                XSDConcreteComponent component = null;
                if (grandparent != null) {
                    component = this.xsdSchema.getCorrespondingComponent((Node)grandparent);
                }
                if (component instanceof XSDComplexTypeDefinition) {
                    XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)component;
                    complexType.getBaseTypeDefinition();
                }
            } else if (XSDDOMHelper.inputEquals(parent, "simpleType", false)) {
                XSDConcreteComponent component = null;
                if (parent != null) {
                    component = this.xsdSchema.getCorrespondingComponent((Node)parent);
                }
                if (component instanceof XSDSimpleTypeDefinition) {
                    XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)component;
                    simpleType.getBaseTypeDefinition();
                }
            }
            XSDConcreteComponent xsdConcreteComponent = null;
            if (element.getParentNode() != null) {
                xsdConcreteComponent = this.xsdSchema.getCorrespondingComponent(element.getParentNode());
            }
            if (xsdConcreteComponent instanceof XSDSimpleTypeDefinition) {
                this.xsdSimpleType = (XSDSimpleTypeDefinition)xsdConcreteComponent;
            }
        }
    }

    boolean checkForAnonymousType(Element element) {
        boolean isAnonymous = false;
        Node aNode = this.getDomHelper().getChildNode(element, "simpleType");
        if (aNode != null) {
            return true;
        }
        return isAnonymous;
    }
}

