/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.provider;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.provider.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.provider.XSDAbstractAdapter;
import org.eclipse.wst.xsd.ui.internal.provider.XSDSchemaAdapter;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDSchemaAdapter
extends XSDAbstractAdapter {
    protected XSDPackage xsdPackage = XSDPackage.eINSTANCE;
    List children;

    public XSDSchemaAdapter(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Image getImage(Object element) {
        return XSDEditorPlugin.getXSDImage("icons/XSDFile.gif");
    }

    public String getText(Object element) {
        XSDSchema xsdSchema = (XSDSchema)element;
        String result = xsdSchema.getSchemaLocation();
        if (result == null) {
            return "";
        }
        return URI.createURI((String)result).lastSegment();
    }

    public Object[] getChildren(Object parentElement) {
        XSDSchema xsdSchema = (XSDSchema)parentElement;
        this.children = new ArrayList();
        List directivesList = this.getDirectives(xsdSchema);
        List elementsList = this.getGlobalElements(xsdSchema);
        List attributeGroupList = this.getAttributeGroupList(xsdSchema);
        List attributesList = this.getAttributeList(xsdSchema);
        List groups = this.getGroups(xsdSchema);
        List notations = this.getNotations(xsdSchema);
        List types = this.getComplexTypes(xsdSchema);
        types.addAll(this.getSimpleTypes(xsdSchema));
        this.children.add(new CategoryAdapter(XSDEditorPlugin.getXSDString("_UI_GRAPH_DIRECTIVES"), XSDEditorPlugin.getPlugin().getIconImage("obj16/directivesheader"), directivesList, xsdSchema, 6));
        this.children.add(new CategoryAdapter(XSDEditorPlugin.getXSDString("_UI_GRAPH_ELEMENTS"), XSDEditorPlugin.getPlugin().getIconImage("obj16/elementsheader"), elementsList, xsdSchema, 2));
        this.children.add(new CategoryAdapter(XSDEditorPlugin.getXSDString("_UI_GRAPH_ATTRIBUTES"), XSDEditorPlugin.getPlugin().getIconImage("obj16/attributesheader"), attributesList, xsdSchema, 1));
        this.children.add(new CategoryAdapter(XSDEditorPlugin.getXSDString("_UI_GRAPH_ATTRIBUTE_GROUPS"), XSDEditorPlugin.getPlugin().getIconImage("obj16/attributegroupsheader"), attributeGroupList, xsdSchema, 8));
        this.children.add(new CategoryAdapter(XSDEditorPlugin.getXSDString("_UI_GRAPH_TYPES"), XSDEditorPlugin.getPlugin().getIconImage("obj16/typesheader"), types, xsdSchema, 3));
        this.children.add(new CategoryAdapter(XSDEditorPlugin.getXSDString("_UI_GRAPH_GROUPS"), XSDEditorPlugin.getPlugin().getIconImage("obj16/groupsheader"), groups, xsdSchema, 5));
        this.children.add(new CategoryAdapter(XSDEditorPlugin.getXSDString("_UI_GRAPH_NOTATIONS"), XSDEditorPlugin.getPlugin().getIconImage("obj16/notationsheader"), notations, xsdSchema, 7));
        return this.children.toArray();
    }

    public boolean hasChildren(Object object) {
        return true;
    }

    public Object getParent(Object object) {
        return null;
    }

    public void notifyChanged(Notification msg) {
        class CategoryNotification
        extends NotificationImpl {
            protected Object category;
            final /* synthetic */ XSDSchemaAdapter this$0;
            private final /* synthetic */ Notification val$msg;

            public CategoryNotification(XSDSchemaAdapter xSDSchemaAdapter, Object category, Notification notification) {
                super(notification.getEventType(), notification.getOldValue(), notification.getNewValue(), notification.getPosition());
                this.this$0 = xSDSchemaAdapter;
                this.val$msg = notification;
                this.category = category;
            }

            public Object getNotifier() {
                return this.category;
            }

            public Object getFeature() {
                return this.val$msg.getFeature();
            }
        }
        if (this.children == null) {
            this.getChildren(this.target);
        }
        if (msg.getFeature() == this.xsdPackage.getXSDSchema_Contents()) {
            CategoryAdapter adapter = (CategoryAdapter)this.children.get(0);
            XSDSchema xsdSchema = adapter.getXSDSchema();
            adapter.setChildren(this.getDirectives(xsdSchema));
            this.fireNotifyChanged((Notification)new CategoryNotification(this, adapter, msg));
            return;
        }
        if (msg.getFeature() == this.xsdPackage.getXSDSchema_ElementDeclarations()) {
            CategoryAdapter adapter = (CategoryAdapter)this.children.get(1);
            XSDSchema xsdSchema = adapter.getXSDSchema();
            adapter.setChildren(this.getGlobalElements(xsdSchema));
            this.fireNotifyChanged((Notification)new CategoryNotification(this, adapter, msg));
            return;
        }
        if (msg.getFeature() == this.xsdPackage.getXSDSchema_AttributeDeclarations()) {
            CategoryAdapter adapter = (CategoryAdapter)this.children.get(2);
            XSDSchema xsdSchema = adapter.getXSDSchema();
            adapter.setChildren(this.getAttributeList(xsdSchema));
            this.fireNotifyChanged((Notification)new CategoryNotification(this, adapter, msg));
            return;
        }
        if (msg.getFeature() == this.xsdPackage.getXSDSchema_AttributeGroupDefinitions()) {
            CategoryAdapter adapter = (CategoryAdapter)this.children.get(3);
            XSDSchema xsdSchema = adapter.getXSDSchema();
            adapter.setChildren(this.getAttributeGroupList(xsdSchema));
            this.fireNotifyChanged((Notification)new CategoryNotification(this, adapter, msg));
            return;
        }
        if (msg.getFeature() == this.xsdPackage.getXSDSchema_TypeDefinitions()) {
            CategoryAdapter adapter = (CategoryAdapter)this.children.get(4);
            XSDSchema xsdSchema = adapter.getXSDSchema();
            List types = this.getComplexTypes(xsdSchema);
            types.addAll(this.getSimpleTypes(xsdSchema));
            adapter.setChildren(types);
            this.fireNotifyChanged((Notification)new CategoryNotification(this, adapter, msg));
            return;
        }
        if (msg.getFeature() == this.xsdPackage.getXSDSchema_ModelGroupDefinitions()) {
            CategoryAdapter adapter = (CategoryAdapter)this.children.get(5);
            XSDSchema xsdSchema = adapter.getXSDSchema();
            adapter.setChildren(this.getGroups(xsdSchema));
            this.fireNotifyChanged((Notification)new CategoryNotification(this, adapter, msg));
            return;
        }
        if (msg.getFeature() == this.xsdPackage.getXSDSchema_NotationDeclarations()) {
            CategoryAdapter adapter = (CategoryAdapter)this.children.get(6);
            XSDSchema xsdSchema = adapter.getXSDSchema();
            adapter.setChildren(this.getNotations(xsdSchema));
            this.fireNotifyChanged((Notification)new CategoryNotification(this, adapter, msg));
            return;
        }
        if (msg.getFeature() == this.xsdPackage.getXSDSchema_Annotations()) {
            return;
        }
        if (msg.getFeature() == this.xsdPackage.getXSDSchema_SchemaLocation()) {
            this.fireNotifyChanged(msg);
            return;
        }
        super.notifyChanged(msg);
    }

    protected List getDirectives(XSDSchema schema) {
        ArrayList list = new ArrayList();
        Iterator i = schema.getContents().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof XSDSchemaDirective)) continue;
            list.add(o);
        }
        return list;
    }

    protected List getAttributeGroupList(XSDSchema xsdSchema) {
        ArrayList<XSDAttributeGroupDefinition> attributeGroupList = new ArrayList<XSDAttributeGroupDefinition>();
        Iterator i = xsdSchema.getAttributeGroupDefinitions().iterator();
        while (i.hasNext()) {
            XSDAttributeGroupDefinition attrGroup = (XSDAttributeGroupDefinition)i.next();
            if (attrGroup.getRootContainer() != xsdSchema) continue;
            attributeGroupList.add(attrGroup);
        }
        return attributeGroupList;
    }

    protected List getAttributeList(XSDSchema xsdSchema) {
        ArrayList<XSDAttributeDeclaration> attributesList = new ArrayList<XSDAttributeDeclaration>();
        Iterator iter = xsdSchema.getAttributeDeclarations().iterator();
        while (iter.hasNext()) {
            XSDAttributeDeclaration attr;
            Object o = iter.next();
            if (!(o instanceof XSDAttributeDeclaration) || (attr = (XSDAttributeDeclaration)o) == null) continue;
            if (attr.getTargetNamespace() != null) {
                if (attr.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema-instance") || attr.getRootContainer() != xsdSchema) continue;
                attributesList.add(attr);
                continue;
            }
            if (attr.getRootContainer() != xsdSchema) continue;
            attributesList.add(attr);
        }
        return attributesList;
    }

    protected List getGlobalElements(XSDSchema schema) {
        EList elements = schema.getElementDeclarations();
        ArrayList<XSDElementDeclaration> list = new ArrayList<XSDElementDeclaration>();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            XSDElementDeclaration elem = (XSDElementDeclaration)i.next();
            if (elem.getRootContainer() != schema) continue;
            list.add(elem);
        }
        return list;
    }

    protected List getComplexTypes(XSDSchema schema) {
        EList allTypes = schema.getTypeDefinitions();
        ArrayList<XSDComplexTypeDefinition> list = new ArrayList<XSDComplexTypeDefinition>();
        Iterator i = allTypes.iterator();
        while (i.hasNext()) {
            XSDComplexTypeDefinition ct;
            XSDTypeDefinition td = (XSDTypeDefinition)i.next();
            if (!(td instanceof XSDComplexTypeDefinition) || (ct = (XSDComplexTypeDefinition)td).getRootContainer() != schema) continue;
            list.add(ct);
        }
        return list;
    }

    protected List getSimpleTypes(XSDSchema schema) {
        EList allTypes = schema.getTypeDefinitions();
        ArrayList<XSDSimpleTypeDefinition> list = new ArrayList<XSDSimpleTypeDefinition>();
        Iterator i = allTypes.iterator();
        while (i.hasNext()) {
            XSDSimpleTypeDefinition st;
            XSDTypeDefinition td = (XSDTypeDefinition)i.next();
            if (!(td instanceof XSDSimpleTypeDefinition) || (st = (XSDSimpleTypeDefinition)td).getRootContainer() != schema) continue;
            list.add(st);
        }
        return list;
    }

    protected List getGroups(XSDSchema schema) {
        EList groups = schema.getModelGroupDefinitions();
        ArrayList<XSDModelGroupDefinition> list = new ArrayList<XSDModelGroupDefinition>();
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            XSDModelGroupDefinition group = (XSDModelGroupDefinition)i.next();
            if (group.getRootContainer() != schema) continue;
            list.add(group);
        }
        return list;
    }

    protected List getNotations(XSDSchema schema) {
        EList notations = schema.getNotationDeclarations();
        ArrayList<XSDNotationDeclaration> list = new ArrayList<XSDNotationDeclaration>();
        Iterator i = notations.iterator();
        while (i.hasNext()) {
            XSDNotationDeclaration notation = (XSDNotationDeclaration)i.next();
            if (notation.getRootContainer() != schema) continue;
            list.add(notation);
        }
        return list;
    }
}

