/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.navigator.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.CommonWorkingSetProviderDescriptor;
import org.eclipse.jst.common.navigator.internal.ui.workingsets.ICommonWorkingSetProvider;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

public class CommonWorkingSetProviderRegistry {
    private static final CommonWorkingSetProviderRegistry INSTANCE = new CommonWorkingSetProviderRegistry();
    private static boolean isInitialized = false;
    private static final String[] NO_DESCRIPTORS = new String[0];
    private Map commonWorkingSetProviderInstances = new HashMap();

    public void init() {
        new CommonWorkingSetProviderRegistryReader().readRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonWorkingSetProviderRegistry getInstance() {
        if (isInitialized) {
            return INSTANCE;
        }
        CommonWorkingSetProviderRegistry commonWorkingSetProviderRegistry = INSTANCE;
        synchronized (commonWorkingSetProviderRegistry) {
            if (!isInitialized) {
                INSTANCE.init();
                isInitialized = true;
            }
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommonWorkingSetDescriptorInstance(CommonWorkingSetProviderDescriptor aDesc) {
        if (aDesc == null) {
            return;
        }
        Map map = this.commonWorkingSetProviderInstances;
        synchronized (map) {
            boolean bValue = this.commonWorkingSetProviderInstances.containsKey(aDesc);
            if (!bValue) {
                ICommonWorkingSetProvider workingSetProvider = aDesc.createWorkingSetProvider();
                this.commonWorkingSetProviderInstances.put(aDesc, workingSetProvider);
            }
        }
    }

    public IWorkingSet[] getAllWorkingSets() {
        ArrayList<IWorkingSet> workingSetList = new ArrayList<IWorkingSet>();
        ICommonWorkingSetProvider[] workingSetProviders = this.getCommonWorkingSetProviders();
        ICommonWorkingSetProvider workingSetProvider = null;
        int x = 0;
        while (x < workingSetProviders.length) {
            workingSetProvider = workingSetProviders[x];
            IWorkingSet[] workingSet = workingSetProvider.getWorkingSets();
            int y = 0;
            while (y < workingSet.length) {
                workingSetList.add(workingSet[y]);
                ++y;
            }
            ++x;
        }
        IWorkingSet[] workingSets = new IWorkingSet[workingSetList.size()];
        return workingSetList.toArray(workingSets);
    }

    public ICommonWorkingSetProvider[] getCommonWorkingSetProviders() {
        ICommonWorkingSetProvider[] descriptors = new ICommonWorkingSetProvider[this.commonWorkingSetProviderInstances.size()];
        return this.commonWorkingSetProviderInstances.values().toArray(descriptors);
    }

    class CommonWorkingSetProviderRegistryReader
    extends RegistryReader {
        private static final String COMMON_WORKING_SET = "workingSetProviders";

        CommonWorkingSetProviderRegistryReader() {
            super("org.eclipse.jst.common.navigator.java", COMMON_WORKING_SET);
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if (COMMON_WORKING_SET.equals(anElement.getName())) {
                try {
                    CommonWorkingSetProviderRegistry.this.addCommonWorkingSetDescriptorInstance(new CommonWorkingSetProviderDescriptor(anElement));
                    return true;
                }
                catch (WorkbenchException e) {
                    WorkbenchNavigatorPlugin.log((String)"Unable to create common working set descriptor.", (IStatus)e.getStatus());
                }
            }
            return false;
        }
    }
}

