/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jst.common.componentcore.util.ComponentUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EARArchiveOpsResourceHandler;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public abstract class ComponentLoadStrategyImpl
extends LoadStrategyImpl {
    protected IVirtualComponent vComponent;
    protected boolean exportSource;
    protected ArrayList filesList;
    protected Set visitedURIs;
    private int javaOutputFolderSegmentCount;
    private IFolder[] outputFolders;
    private Map uriResourceMap;

    public ComponentLoadStrategyImpl(IVirtualComponent vComponent) {
        this.vComponent = vComponent;
        this.filesList = new ArrayList();
    }

    public boolean contains(String uri) {
        IVirtualFolder rootFolder = this.vComponent.getRootFolder();
        return rootFolder.getFile((IPath)new Path(uri)).exists();
    }

    protected void initializeResourceSet() {
        this.resourceSet = WorkbenchResourceHelper.getResourceSet((IProject)this.vComponent.getProject());
    }

    protected boolean primContains(String uri) {
        return false;
    }

    public List getFiles() {
        this.filesList.clear();
        try {
            IVirtualFolder rootFolder = this.vComponent.getRootFolder();
            IVirtualResource[] members = rootFolder.members();
            this.filesList = this.getFiles(members);
            IPackageFragmentRoot[] roots = ComponentUtilities.getSourceContainers((IVirtualComponent)this.vComponent);
            this.outputFolders = new IFolder[roots.length];
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < roots.length) {
                IPath outputPath = roots[i].getRawClasspathEntry().getOutputLocation();
                if (outputPath != null) {
                    this.outputFolders[i] = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath);
                    IPath sourcePath = roots[i].getPath();
                    boolean sourceIsProject = sourcePath.segmentCount() <= 1;
                    IProject source = sourceIsProject ? this.getComponent().getProject() : workspaceRoot.getFolder(sourcePath);
                    IVirtualResource[] virtualSources = ComponentCore.createResources((IResource)source);
                    IProject actualResource = sourceIsProject ? source : virtualSources[0].getUnderlyingResource();
                    int sourceOffset = actualResource.getProjectRelativePath().segmentCount() - sourcePath.segmentCount();
                    int runtimeOffset = outputPath.segmentCount() - virtualSources[0].getRuntimePath().segmentCount();
                    this.javaOutputFolderSegmentCount = sourceOffset + runtimeOffset;
                    this.getFiles(new IResource[]{this.outputFolders[i]});
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this.filesList;
    }

    protected ArrayList getFiles(IResource[] resources) throws CoreException {
        int i = 0;
        while (i < resources.length) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File cFile = null;
            if (resources[i].getType() == 1) {
                String uri;
                IPath runtimePath = resources[i].getProjectRelativePath().removeFirstSegments(this.javaOutputFolderSegmentCount);
                String string = uri = runtimePath == null ? null : runtimePath.toString();
                if (uri != null && this.shouldInclude(uri) && !this.getVisitedURIs().contains(uri)) {
                    cFile = this.createFile(uri);
                    cFile.setLastModified(this.getLastModified(resources[i]));
                    this.getVisitedURIs().add(uri);
                    this.getURIResourceMap().put(uri, resources[i]);
                    this.filesList.add(cFile);
                }
            } else if (this.shouldInclude((IContainer)resources[i])) {
                IResource[] nestedResources = ((IContainer)resources[i]).members();
                this.getFiles(nestedResources);
            }
            ++i;
        }
        return this.filesList;
    }

    protected ArrayList getFiles(IVirtualResource[] virtualResources) throws CoreException {
        int i = 0;
        while (i < virtualResources.length) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File cFile = null;
            if (virtualResources[i].getType() == 16) {
                String uri;
                IPath runtimePath = virtualResources[i].getRuntimePath();
                String string = uri = runtimePath == null ? null : runtimePath.toString();
                if (uri != null && this.shouldInclude(uri) && !this.getVisitedURIs().contains(uri)) {
                    if (uri.charAt(0) == '/') {
                        uri = uri.substring(1);
                    }
                    cFile = this.createFile(uri);
                    cFile.setLastModified(this.getLastModified(virtualResources[i].getUnderlyingResource()));
                    this.getVisitedURIs().add(uri);
                    this.filesList.add(cFile);
                }
            } else if (this.shouldInclude((IVirtualContainer)virtualResources[i])) {
                IVirtualResource[] nestedVirtualResources = ((IVirtualContainer)virtualResources[i]).members();
                this.getFiles(nestedVirtualResources);
            }
            ++i;
        }
        return this.filesList;
    }

    protected long getLastModified(IResource aResource) {
        return aResource.getLocation().toFile().lastModified();
    }

    private Map getURIResourceMap() {
        if (this.uriResourceMap == null) {
            this.uriResourceMap = new HashMap();
        }
        return this.uriResourceMap;
    }

    public Set getVisitedURIs() {
        if (this.visitedURIs == null) {
            this.visitedURIs = new HashSet();
        }
        return this.visitedURIs;
    }

    public void setExportSource(boolean newExportSource) {
        this.exportSource = newExportSource;
    }

    public boolean isExportSource() {
        return this.exportSource;
    }

    protected boolean shouldInclude(IContainer container) {
        return true;
    }

    protected boolean shouldInclude(IVirtualContainer vContainer) {
        return true;
    }

    protected boolean shouldInclude(String uri) {
        return this.isExportSource() || !this.isSource(uri);
    }

    protected boolean isSource(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.endsWith(".java") || uri.endsWith(".sqlj");
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        IVirtualFolder rootFolder = this.vComponent.getRootFolder();
        IVirtualResource vResource = rootFolder.findMember(uri);
        String filePath = null;
        if (vResource != null && vResource.exists()) {
            filePath = vResource.getUnderlyingResource().getLocation().toOSString();
        } else {
            IResource resource = (IResource)this.getURIResourceMap().get(uri);
            if (resource == null) {
                String eString = EARArchiveOpsResourceHandler.getString("ARCHIVE_OPERATION_FileNotFound");
                throw new FileNotFoundException(eString);
            }
            filePath = resource.getLocation().toOSString();
        }
        File file = new File(filePath);
        FileInputStream inputStream = new FileInputStream(file);
        return inputStream;
    }

    public Resource getMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        try {
            URI compUri = ModuleURIUtil.fullyQualifyURI((ComponentHandle)this.vComponent.getComponentHandle());
            IPath requestPath = new Path(compUri.path()).append((IPath)new Path(uri));
            URI resourceURI = URI.createURI((String)("module:" + requestPath.toString()));
            return this.getResourceSet().getResource(resourceURI, true);
        }
        catch (WrappedException wrapEx) {
            if (ExtendedEcoreUtil.getFileNotFoundDetector().isFileNotFound(wrapEx)) {
                FileNotFoundException fileNotFoundEx = ExtendedEcoreUtil.getInnerFileNotFoundException((WrappedException)wrapEx);
                throw fileNotFoundEx;
            }
            this.throwResourceLoadException(uri, (Exception)((Object)wrapEx));
            return null;
        }
    }

    public boolean isClassLoaderNeeded() {
        return false;
    }

    public IVirtualComponent getComponent() {
        return this.vComponent;
    }
}

