/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.ResourceBundle;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.ValidationController;
import org.eclipse.wst.wsdl.validation.internal.ValidatorRegistry;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.resolver.IExtensibleURIResolver;
import org.eclipse.wst.wsdl.validation.internal.resolver.URIResolver;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorDelegate;

public class WSDLValidator {
    private static String VALIDATOR_RESOURCE_BUNDLE = "validatewsdl";
    private static String VALIDATOR_HTTP_RESOURCE_BUNDLE = "validatewsdlhttp";
    private static String VALIDATOR_SOAP_RESOURCE_BUNDLE = "validatewsdlsoap";
    private static String VALIDATOR_MIME_RESOURCE_BUNDLE = "validatewsdlmime";
    private ValidationController validationController;
    private URIResolver uriResolver;
    private Hashtable attributes = new Hashtable();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public WSDLValidator() {
        ResourceBundle rb = ResourceBundle.getBundle(VALIDATOR_RESOURCE_BUNDLE);
        this.uriResolver = new URIResolver();
        this.validationController = new ValidationController(rb, this.uriResolver);
        ValidatorRegistry registry = ValidatorRegistry.getInstance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WSDLValidatorDelegate delegate = new WSDLValidatorDelegate(clazz.getName(), VALIDATOR_RESOURCE_BUNDLE, this.getClass().getClassLoader());
        registry.registerValidator("http://schemas.xmlsoap.org/wsdl/", delegate, ValidatorRegistry.WSDL_VALIDATOR);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11BasicValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WSDL11ValidatorDelegate delegate1 = new WSDL11ValidatorDelegate(clazz2.getName(), VALIDATOR_RESOURCE_BUNDLE, this.getClass().getClassLoader());
        this.registerWSDL11Validator("http://schemas.xmlsoap.org/wsdl/", delegate1);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.wst.wsdl.validation.internal.wsdl11.http.HTTPValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        delegate1 = new WSDL11ValidatorDelegate(clazz3.getName(), VALIDATOR_HTTP_RESOURCE_BUNDLE, this.getClass().getClassLoader());
        this.registerWSDL11Validator("http://schemas.xmlsoap.org/wsdl/http/", delegate1);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.wst.wsdl.validation.internal.wsdl11.soap.SOAPValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        delegate1 = new WSDL11ValidatorDelegate(clazz4.getName(), VALIDATOR_SOAP_RESOURCE_BUNDLE, this.getClass().getClassLoader());
        this.registerWSDL11Validator("http://schemas.xmlsoap.org/wsdl/soap/", delegate1);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.wst.wsdl.validation.internal.wsdl11.mime.MIMEValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        delegate1 = new WSDL11ValidatorDelegate(clazz5.getName(), VALIDATOR_MIME_RESOURCE_BUNDLE, this.getClass().getClassLoader());
        this.registerWSDL11Validator("http://schemas.xmlsoap.org/wsdl/mime/", delegate1);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.InlineSchemaValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        delegate1 = new WSDL11ValidatorDelegate(clazz6.getName(), VALIDATOR_RESOURCE_BUNDLE, this.getClass().getClassLoader());
        this.registerWSDL11Validator("http://www.w3.org/1999/XMLSchema", delegate1);
        this.registerWSDL11Validator("http://www.w3.org/2000/10/XMLSchema", delegate1);
        this.registerWSDL11Validator("http://www.w3.org/2001/XMLSchema", delegate1);
    }

    public IValidationReport validate(String uri) {
        return this.validate(uri, null);
    }

    public IValidationReport validate(String uri, InputStream inputStream) {
        if (uri == null) {
            return null;
        }
        this.validationController.setAttributes(this.attributes);
        return this.validationController.validate(uri, inputStream);
    }

    public void addURIResolver(IExtensibleURIResolver uriResolver) {
        this.uriResolver.addURIResolver(uriResolver);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void registerWSDLExtensionValidator(String namespace, WSDLValidatorDelegate delegate) {
        ValidatorRegistry.getInstance().registerValidator(namespace, delegate, ValidatorRegistry.EXT_VALIDATOR);
    }

    public void registerWSDL11Validator(String namespace, WSDL11ValidatorDelegate delegate) {
        org.eclipse.wst.wsdl.validation.internal.wsdl11.ValidatorRegistry.getInstance().registerValidator(namespace, delegate);
    }
}

