/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.provisional;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.format.FormatProcessorCSS;
import org.eclipse.wst.css.ui.internal.autoedit.StructuredAutoEditStrategyCSS;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistProcessor;
import org.eclipse.wst.css.ui.internal.style.LineStyleProviderForCSS;
import org.eclipse.wst.css.ui.internal.taginfo.CSSBestMatchHoverProcessor;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.sse.ui.internal.provisional.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.provisional.style.IHighlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.ProblemAnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;

public class StructuredTextViewerConfigurationCSS
extends StructuredTextViewerConfiguration {
    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
        IAutoEditStrategy[] superStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
        int i = 0;
        while (i < superStrategies.length) {
            allStrategies.add(superStrategies[i]);
            ++i;
        }
        if (contentType == "org.eclipse.wst.css.STYLE") {
            allStrategies.add(new StructuredAutoEditStrategyCSS());
        }
        return allStrategies.toArray(new IAutoEditStrategy[0]);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.configuredContentTypes == null) {
            this.configuredContentTypes = new String[]{"org.eclipse.wst.css.STYLE", "org.eclipse.wst.sse.ST_DEFAULT", "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE"};
        }
        return this.configuredContentTypes;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IContentAssistant contentAssistant = super.getContentAssistant(sourceViewer);
        if (contentAssistant != null && contentAssistant instanceof ContentAssistant) {
            CSSContentAssistProcessor cssProcessor = new CSSContentAssistProcessor();
            this.setContentAssistProcessor((ContentAssistant)contentAssistant, cssProcessor, "org.eclipse.wst.css.STYLE");
            this.setContentAssistProcessor((ContentAssistant)contentAssistant, cssProcessor, "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE");
        }
        return contentAssistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "org.eclipse.wst.css.STYLE");
        formatter.setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new FormatProcessorCSS()));
        return formatter;
    }

    public IHighlighter getHighlighter(ISourceViewer sourceViewer) {
        IHighlighter highlighter = super.getHighlighter(sourceViewer);
        if (highlighter != null) {
            highlighter.addProvider("org.eclipse.wst.css.STYLE", (LineStyleProvider)new LineStyleProviderForCSS());
        }
        return highlighter;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        TextHoverManager.TextHoverDescriptor[] hoverDescs = this.getTextHovers();
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && EditorUtility.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                String hoverType = hoverDescs[i].getId();
                if ("combinationHover".equalsIgnoreCase(hoverType)) {
                    return new CSSBestMatchHoverProcessor();
                }
                if ("problemHover".equalsIgnoreCase(hoverType)) {
                    return new ProblemAnnotationHoverProcessor();
                }
                if ("annotationHover".equalsIgnoreCase(hoverType)) {
                    return new AnnotationHoverProcessor();
                }
            }
            ++i;
        }
        return super.getTextHover(sourceViewer, contentType, stateMask);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        int indentationWidth = preferences.getInt("indentationSize");
        String indentCharPref = preferences.getString("indentationChar");
        boolean useSpaces = "space".equals(indentCharPref);
        int i = 0;
        while (i <= indentationWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            boolean appendTab = false;
            if (useSpaces) {
                j = 0;
                while (j + i < indentationWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    appendTab = true;
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != indentationWidth) {
                    appendTab = true;
                }
            }
            if (appendTab) {
                prefix.append('\t');
                vector.add(prefix.toString());
                prefix.deleteCharAt(prefix.length() - 1);
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }
}

