/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.views.contentoutline;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSMediaRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPageRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.ui.internal.image.CSSImageHelper;
import org.eclipse.wst.css.ui.internal.image.CSSImageType;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.stylesheets.MediaList;

class JFaceNodeLabelProviderCSS
implements ILabelProvider {
    protected INodeAdapterFactory fAdapterFactory;

    public JFaceNodeLabelProviderCSS(INodeAdapterFactory adapterFactory) {
        this.fAdapterFactory = adapterFactory;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    protected IJFaceNodeAdapter getAdapter(Object adaptable) {
        return (IJFaceNodeAdapter)this.fAdapterFactory.adapt((INodeNotifier)adaptable);
    }

    public Image getImage(Object element) {
        if (element instanceof ICSSNode) {
            CSSImageHelper helper = CSSImageHelper.getInstance();
            return helper.getImage(CSSImageType.getImageType((ICSSNode)element));
        }
        return null;
    }

    public String getLabelText(Viewer viewer, Object element) {
        return "";
    }

    public String getText(Object element) {
        String result = "";
        if (element instanceof ICSSNode) {
            switch (((ICSSNode)element).getNodeType()) {
                case 1: {
                    result = ((ICSSStyleRule)element).getSelectors().getString();
                    break;
                }
                case 5: {
                    result = "@font-face";
                    break;
                }
                case 3: {
                    result = ((CSSImportRule)element).getHref();
                    String mediaText = this.getMediaText((CSSImportRule)element);
                    if (mediaText == null || mediaText.length() <= 0) break;
                    result = String.valueOf(result) + " (" + mediaText + ")";
                    break;
                }
                case 6: {
                    result = ((ICSSPageRule)element).getSelectors().getString();
                    break;
                }
                case 8: {
                    result = "properties";
                    break;
                }
                case 9: {
                    result = ((ICSSStyleDeclItem)element).getPropertyName();
                    break;
                }
                case 11: {
                    result = ((ICSSPrimitiveValue)element).getStringValue();
                    break;
                }
                case 4: {
                    result = "@media";
                    String mediaText = this.getMediaText((CSSRule)((ICSSMediaRule)element));
                    if (mediaText == null || mediaText.length() <= 0) break;
                    result = String.valueOf(result) + " (" + mediaText + ")";
                    break;
                }
                case 2: {
                    result = "@charset";
                    break;
                }
                case 12: {
                    result = ((MediaList)element).getMediaText();
                    break;
                }
            }
        }
        return result;
    }

    private String getMediaText(CSSRule rule) {
        String result = "";
        ICSSNode child = rule != null ? ((ICSSNode)rule).getFirstChild() : null;
        while (child != null) {
            if (child.getNodeType() == 12) {
                result = ((MediaList)child).getMediaText();
                break;
            }
            child = child.getNextSibling();
        }
        return result;
    }

    public boolean isAffected(Object dummy) {
        return true;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

