/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.provisional;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistProcessor;
import org.eclipse.wst.css.ui.internal.style.LineStyleProviderForEmbeddedCSS;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.html.ui.internal.autoedit.AutoEditStrategyForTabs;
import org.eclipse.wst.html.ui.internal.contentassist.HTMLContentAssistProcessor;
import org.eclipse.wst.html.ui.internal.contentassist.NoRegionContentAssistProcessorForHTML;
import org.eclipse.wst.html.ui.internal.hyperlink.URIHyperlinkDetector;
import org.eclipse.wst.html.ui.internal.style.LineStyleProviderForHTML;
import org.eclipse.wst.html.ui.internal.taginfo.HTMLBestMatchHoverProcessor;
import org.eclipse.wst.html.ui.internal.taginfo.HTMLInformationProvider;
import org.eclipse.wst.html.ui.internal.taginfo.HTMLTagInfoHoverProcessor;
import org.eclipse.wst.javascript.ui.internal.common.contentassist.JavaScriptContentAssistProcessor;
import org.eclipse.wst.javascript.ui.internal.common.style.LineStyleProviderForJavaScript;
import org.eclipse.wst.javascript.ui.internal.common.taginfo.JavaScriptBestMatchHoverProcessor;
import org.eclipse.wst.javascript.ui.internal.common.taginfo.JavaScriptInformationProvider;
import org.eclipse.wst.javascript.ui.internal.common.taginfo.JavaScriptTagInfoHoverProcessor;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.sse.ui.internal.provisional.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.provisional.style.IHighlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.ProblemAnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;
import org.eclipse.wst.xml.ui.internal.autoedit.StructuredAutoEditStrategyXML;
import org.eclipse.wst.xml.ui.internal.correction.CorrectionProcessorXML;
import org.eclipse.wst.xml.ui.internal.doubleclick.XMLDoubleClickStrategy;

public class StructuredTextViewerConfigurationHTML
extends StructuredTextViewerConfiguration {
    InformationPresenter fInformationPresenter = null;

    public StructuredTextViewerConfigurationHTML() {
    }

    public StructuredTextViewerConfigurationHTML(IPreferenceStore store) {
        super(store);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        ArrayList<Object> allStrategies = new ArrayList<Object>(0);
        IAutoEditStrategy[] superStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
        int i = 0;
        while (i < superStrategies.length) {
            allStrategies.add(superStrategies[i]);
            ++i;
        }
        if (contentType == "org.eclipse.wst.html.HTML_DEFAULT" || contentType == "org.eclipse.wst.html.HTML_DECLARATION") {
            allStrategies.add(new StructuredAutoEditStrategyXML());
        }
        allStrategies.add(new AutoEditStrategyForTabs());
        return allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.configuredContentTypes == null) {
            String[] xmlTypes = StructuredTextPartitionerForXML.getConfiguredContentTypes();
            String[] htmlTypes = StructuredTextPartitionerForHTML.getConfiguredContentTypes();
            this.configuredContentTypes = new String[2 + xmlTypes.length + htmlTypes.length];
            this.configuredContentTypes[0] = "org.eclipse.wst.sse.ST_DEFAULT";
            this.configuredContentTypes[1] = "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
            int index = 0;
            System.arraycopy(xmlTypes, 0, this.configuredContentTypes, index += 2, xmlTypes.length);
            System.arraycopy(htmlTypes, 0, this.configuredContentTypes, index += xmlTypes.length, htmlTypes.length);
        }
        return this.configuredContentTypes;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IContentAssistant ca = super.getContentAssistant(sourceViewer);
        if (ca != null && ca instanceof ContentAssistant) {
            ContentAssistant contentAssistant = (ContentAssistant)ca;
            HTMLContentAssistProcessor htmlContentAssistProcessor = new HTMLContentAssistProcessor();
            JavaScriptContentAssistProcessor jsContentAssistProcessor = new JavaScriptContentAssistProcessor();
            CSSContentAssistProcessor cssContentAssistProcessor = new CSSContentAssistProcessor();
            NoRegionContentAssistProcessorForHTML noRegionProcessorForHTML = new NoRegionContentAssistProcessorForHTML();
            this.setContentAssistProcessor(contentAssistant, (IContentAssistProcessor)htmlContentAssistProcessor, "org.eclipse.wst.html.HTML_DEFAULT");
            this.setContentAssistProcessor(contentAssistant, (IContentAssistProcessor)htmlContentAssistProcessor, "org.eclipse.wst.html.HTML_COMMENT");
            this.setContentAssistProcessor(contentAssistant, (IContentAssistProcessor)jsContentAssistProcessor, "org.eclipse.wst.html.SCRIPT");
            this.setContentAssistProcessor(contentAssistant, (IContentAssistProcessor)cssContentAssistProcessor, "org.eclipse.wst.css.STYLE");
            this.setContentAssistProcessor(contentAssistant, (IContentAssistProcessor)noRegionProcessorForHTML, "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE");
        }
        return ca;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "org.eclipse.wst.html.HTML_DEFAULT");
        formatter.setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new HTMLFormatProcessorImpl()));
        return formatter;
    }

    public IContentAssistant getCorrectionAssistant(ISourceViewer sourceViewer) {
        IContentAssistant ca = super.getCorrectionAssistant(sourceViewer);
        if (ca != null && ca instanceof ContentAssistant) {
            ContentAssistant correctionAssistant = (ContentAssistant)ca;
            ITextEditor editor = this.getTextEditor();
            if (editor != null) {
                CorrectionProcessorXML correctionProcessor = new CorrectionProcessorXML(editor);
                correctionAssistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.html.HTML_DEFAULT");
                correctionAssistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.xml.XML_CDATA");
                correctionAssistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.xml.XML_COMMENT");
                correctionAssistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.xml.XML_DECL");
                correctionAssistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.xml.XML_PI");
                correctionAssistant.setContentAssistProcessor((IContentAssistProcessor)correctionProcessor, "org.eclipse.wst.xml.dtd.internal_subset");
            }
        }
        return ca;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (contentType.compareTo("org.eclipse.wst.html.HTML_DEFAULT") == 0) {
            return new XMLDoubleClickStrategy();
        }
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public IHighlighter getHighlighter(ISourceViewer sourceViewer) {
        IHighlighter highlighter = super.getHighlighter(sourceViewer);
        if (highlighter != null) {
            LineStyleProviderForHTML htmlLineStyleProvider = new LineStyleProviderForHTML();
            highlighter.addProvider("org.eclipse.wst.html.HTML_DEFAULT", (LineStyleProvider)htmlLineStyleProvider);
            highlighter.addProvider("org.eclipse.wst.html.HTML_COMMENT", (LineStyleProvider)htmlLineStyleProvider);
            highlighter.addProvider("org.eclipse.wst.html.HTML_DECLARATION", (LineStyleProvider)htmlLineStyleProvider);
            LineStyleProviderForJavaScript jsLineStyleProvider = new LineStyleProviderForJavaScript();
            highlighter.addProvider("org.eclipse.wst.html.SCRIPT", (LineStyleProvider)jsLineStyleProvider);
            LineStyleProviderForEmbeddedCSS cssLineStyleProvider = new LineStyleProviderForEmbeddedCSS();
            highlighter.addProvider("org.eclipse.wst.css.STYLE", (LineStyleProvider)cssLineStyleProvider);
        }
        return highlighter;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null || !this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        ArrayList<IHyperlinkDetector> allDetectors = new ArrayList<IHyperlinkDetector>(0);
        allDetectors.add(new URIHyperlinkDetector());
        IHyperlinkDetector[] superDetectors = super.getHyperlinkDetectors(sourceViewer);
        int m = 0;
        while (m < superDetectors.length) {
            IHyperlinkDetector detector = superDetectors[m];
            if (!allDetectors.contains(detector)) {
                allDetectors.add(detector);
            }
            ++m;
        }
        return allDetectors.toArray(new IHyperlinkDetector[0]);
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        if (this.fInformationPresenter == null) {
            this.fInformationPresenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
            HTMLInformationProvider htmlInformationProvider = new HTMLInformationProvider();
            this.fInformationPresenter.setInformationProvider((IInformationProvider)htmlInformationProvider, "org.eclipse.wst.html.HTML_DEFAULT");
            JavaScriptInformationProvider javascriptInformationProvider = new JavaScriptInformationProvider();
            this.fInformationPresenter.setInformationProvider((IInformationProvider)javascriptInformationProvider, "org.eclipse.wst.html.SCRIPT");
            this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
            this.fInformationPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        return this.fInformationPresenter;
    }

    /*
     * Exception decompiling
     */
    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 224->227)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        Object hover = null;
        TextHoverManager.TextHoverDescriptor[] hoverDescs = this.getTextHovers();
        int i = 0;
        while (i < hoverDescs.length && hover == null) {
            if (hoverDescs[i].isEnabled() && EditorUtility.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                String hoverType = hoverDescs[i].getId();
                if ("combinationHover".equalsIgnoreCase(hoverType)) {
                    if (contentType == "org.eclipse.wst.html.SCRIPT") {
                        hover = new JavaScriptBestMatchHoverProcessor();
                    } else if (contentType == "org.eclipse.wst.html.HTML_DEFAULT") {
                        hover = new HTMLBestMatchHoverProcessor();
                    }
                } else if ("problemHover".equalsIgnoreCase(hoverType)) {
                    hover = new ProblemAnnotationHoverProcessor();
                } else if ("annotationHover".equalsIgnoreCase(hoverType)) {
                    hover = new AnnotationHoverProcessor();
                } else if ("documentationHover".equalsIgnoreCase(hoverType)) {
                    if (contentType == "org.eclipse.wst.html.SCRIPT") {
                        hover = new JavaScriptTagInfoHoverProcessor();
                    } else if (contentType == "org.eclipse.wst.html.HTML_DEFAULT") {
                        hover = new HTMLTagInfoHoverProcessor();
                    }
                }
            }
            ++i;
        }
        if (hover == null) {
            hover = super.getTextHover(sourceViewer, contentType, stateMask);
        }
        return hover;
    }

    public void unConfigure(ISourceViewer viewer) {
        super.unConfigure(viewer);
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.uninstall();
        }
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        Preferences preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
        int indentationWidth = preferences.getInt("indentationSize");
        String indentCharPref = preferences.getString("indentationChar");
        boolean useSpaces = "space".equals(indentCharPref);
        int i = 0;
        while (i <= indentationWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            boolean appendTab = false;
            if (useSpaces) {
                j = 0;
                while (j + i < indentationWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    appendTab = true;
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != indentationWidth) {
                    appendTab = true;
                }
            }
            if (appendTab) {
                prefix.append('\t');
                vector.add(prefix.toString());
                prefix.deleteCharAt(prefix.length() - 1);
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }
}

