/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class EventManager
implements IResourceChangeListener {
    private static EventManager _inst = null;
    private boolean _shutdown = false;
    private IResourceDeltaVisitor _postAutoBuildVisitor = null;
    private boolean _isActive = false;

    private EventManager() {
    }

    public static EventManager getManager() {
        if (_inst == null) {
            _inst = new EventManager();
        }
        return _inst;
    }

    public void opening(IProject project) {
        if (project == null || !ValidationPlugin.isActivated()) {
            return;
        }
        ConfigurationManager.getManager().opening(project);
    }

    public void closing(IProject project) {
        block9: {
            if (project == null || !ValidationPlugin.isActivated()) {
                return;
            }
            try {
                boolean isMigrated = ConfigurationManager.getManager().isMigrated(project);
                if (!isMigrated) break block9;
                ValidatorMetaData[] vmds = ConfigurationManager.getManager().getProjectConfiguration(project).getValidators();
                int i = 0;
                while (i < vmds.length) {
                    block10: {
                        ValidatorMetaData vmd = vmds[i];
                        if (vmd.isActive()) {
                            LogEntry entry;
                            Logger logger;
                            IWorkbenchContext helper = null;
                            try {
                                helper = vmd.getHelper(project);
                                helper.closing();
                            }
                            catch (InstantiationException exc) {
                                ValidationRegistryReader.getReader().disableValidator(vmd);
                                logger = ValidationPlugin.getPlugin().getMsgLogger();
                                if (logger.isLoggingLevel(Level.SEVERE)) {
                                    entry = ValidationPlugin.getLogEntry();
                                    entry.setSourceID("EventManager::closing(IProject)");
                                    entry.setTargetException((Throwable)exc);
                                    logger.write(Level.SEVERE, (Object)entry);
                                }
                            }
                            catch (Throwable exc) {
                                logger = ValidationPlugin.getPlugin().getMsgLogger();
                                if (!logger.isLoggingLevel(Level.SEVERE)) break block10;
                                entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("EventManager::closing(IProject)");
                                entry.setTargetException(exc);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                        }
                    }
                    ++i;
                }
                ConfigurationManager.getManager().closing(project);
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block9;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("EventManager::closing(" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block9;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    public void deleting(IProject project) {
        block9: {
            if (project == null) {
                return;
            }
            try {
                boolean isMigrated = ConfigurationManager.getManager().isMigrated(project);
                if (!isMigrated) break block9;
                ValidatorMetaData[] vmds = ConfigurationManager.getManager().getProjectConfiguration(project).getValidators();
                int i = 0;
                while (i < vmds.length) {
                    block10: {
                        ValidatorMetaData vmd = vmds[i];
                        if (vmd.isActive()) {
                            LogEntry entry;
                            Logger logger;
                            IWorkbenchContext helper = null;
                            try {
                                helper = vmd.getHelper(project);
                                helper.deleting();
                            }
                            catch (InstantiationException exc) {
                                ValidationRegistryReader.getReader().disableValidator(vmd);
                                logger = ValidationPlugin.getPlugin().getMsgLogger();
                                if (logger.isLoggingLevel(Level.SEVERE)) {
                                    entry = ValidationPlugin.getLogEntry();
                                    entry.setSourceID("EventManager::deleting(IProject)");
                                    entry.setTargetException((Throwable)exc);
                                    logger.write(Level.SEVERE, (Object)entry);
                                }
                            }
                            catch (Throwable exc) {
                                logger = ValidationPlugin.getPlugin().getMsgLogger();
                                if (!logger.isLoggingLevel(Level.SEVERE)) break block10;
                                entry = ValidationPlugin.getLogEntry();
                                entry.setSourceID("EventManager::deleting(IProject)");
                                entry.setTargetException(exc);
                                logger.write(Level.SEVERE, (Object)entry);
                            }
                        }
                    }
                    ++i;
                }
                ConfigurationManager.getManager().deleting(project);
            }
            catch (InvocationTargetException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block9;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("EventManager::deleting(" + project.getName() + ")");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
                if (exc.getTargetException() == null) break block9;
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    private void postAutoChange(IResourceDelta delta) {
        if (this._postAutoBuildVisitor == null) {
            this._postAutoBuildVisitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta subdelta) throws CoreException {
                    if (subdelta == null) {
                        return true;
                    }
                    IResource resource = subdelta.getResource();
                    if (resource instanceof IProject) {
                        IProject project = (IProject)resource;
                        if ((subdelta.getFlags() & 0x80000) == 524288) {
                            block6: {
                                try {
                                    ConfigurationManager.getManager().resetProjectNature(project);
                                }
                                catch (InvocationTargetException exc) {
                                    Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                                    if (!logger.isLoggingLevel(Level.SEVERE)) break block6;
                                    LogEntry entry = ValidationPlugin.getLogEntry();
                                    entry.setSourceIdentifier("EventManager::postAutoChange");
                                    entry.setTargetException((Throwable)exc);
                                    logger.write(Level.SEVERE, (Object)entry);
                                    if (exc.getTargetException() == null) break block6;
                                    entry.setTargetException((Throwable)exc);
                                    logger.write(Level.SEVERE, (Object)entry);
                                }
                            }
                            return false;
                        }
                        if ((subdelta.getFlags() & 0x4000) == 16384 && project.isOpen()) {
                            EventManager.this.opening(project);
                        }
                    }
                    return true;
                }
            };
        }
        try {
            delta.accept(this._postAutoBuildVisitor, true);
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this._shutdown && !this.isActive()) {
            return;
        }
        if (event.getSource() instanceof IWorkspace) {
            if (event.getType() == 4 && event.getResource() instanceof IProject) {
                this.deleting((IProject)event.getResource());
            } else if (event.getType() == 2 && event.getResource() instanceof IProject) {
                this.closing((IProject)event.getResource());
            } else if (event.getType() == 16) {
                this.postAutoChange(event.getDelta());
            }
        }
    }

    public void shutdown() {
        try {
            this._shutdown = true;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            IProject[] projects = workspaceRoot.getProjects();
            ProjectConfiguration prjp = null;
            IProject project = null;
            int i = 0;
            while (i < projects.length) {
                block10: {
                    project = projects[i];
                    if (project.isOpen()) {
                        try {
                            boolean isMigrated = ConfigurationManager.getManager().isMigrated(project);
                            if (!isMigrated) break block10;
                            prjp = ConfigurationManager.getManager().getProjectConfiguration(project);
                            prjp.store();
                            ValidatorMetaData[] vmdList = prjp.getEnabledValidators();
                            if (vmdList == null) break block10;
                            int j = 0;
                            while (j < vmdList.length) {
                                IWorkbenchContext helper;
                                ValidatorMetaData vmd = vmdList[j];
                                if (vmd.isActive() && (helper = vmd.getHelper(project)) != null) {
                                    try {
                                        helper.shutdown();
                                    }
                                    catch (Throwable throwable) {}
                                }
                                ++j;
                            }
                        }
                        catch (InvocationTargetException exc) {
                            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                            if (!logger.isLoggingLevel(Level.SEVERE)) break block10;
                            LogEntry entry = ValidationPlugin.getLogEntry();
                            entry.setSourceIdentifier("EventManager::shutdown(" + project.getName() + ")");
                            entry.setTargetException((Throwable)exc);
                            logger.write(Level.SEVERE, (Object)entry);
                            if (exc.getTargetException() == null) break block10;
                            entry.setTargetException((Throwable)exc);
                            logger.write(Level.SEVERE, (Object)entry);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {}
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setActive(boolean b) {
        this._isActive = b;
    }

    public static boolean isHeadless() {
        boolean ret = UIContextDetermination.getCurrentContext() == 102;
        return ret;
    }
}

