/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.ConfigurationConstants;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class GlobalConfiguration
extends ValidationConfiguration {
    static final boolean PREF_PROJECTS_CAN_OVERRIDE_DEFAULT = true;
    private boolean _canProjectsOverride = GlobalConfiguration.getCanProjectsOverrideDefault();

    public GlobalConfiguration(IWorkspaceRoot root) throws InvocationTargetException {
        super((IResource)root, GlobalConfiguration.convertToArray(ValidationRegistryReader.getReader().getAllValidators()));
    }

    public GlobalConfiguration(GlobalConfiguration original) throws InvocationTargetException {
        original.copyTo(this);
    }

    public boolean canProjectsOverride() {
        return this._canProjectsOverride;
    }

    public void setCanProjectsOverride(boolean can) {
        this._canProjectsOverride = can;
    }

    public void resetToDefault() {
        this.setAutoValidate(GlobalConfiguration.getAutoValidateDefault());
        this.setEnabledValidators(GlobalConfiguration.getEnabledValidatorsDefault());
        this.setMaximumNumberOfMessages(GlobalConfiguration.getMaximumNumberOfMessagesDefault());
        this.setBuildValidate(GlobalConfiguration.getBuildValidateDefault());
        this.setCanProjectsOverride(GlobalConfiguration.getCanProjectsOverrideDefault());
    }

    protected IMarker[] getMarker() {
        try {
            IWorkspaceRoot root = GlobalConfiguration.getRoot();
            IMarker[] markers = root.findMarkers("org.eclipse.wst.validation.preferencemarker", false, 1);
            if (markers.length == 1) {
                return markers;
            }
            return null;
        }
        catch (CoreException exc) {
            Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("GlobalConfiguration.getMarker()");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
            return null;
        }
    }

    protected void load(IMarker[] marker) {
        block3: {
            try {
                IWorkspaceRoot root = GlobalConfiguration.getRoot();
                if (marker == null) {
                    this.resetToDefault();
                    return;
                }
                IMarker rootMarker = marker[0];
                ValidatorMetaData[] enabledValidators = null;
                String enabledValidatorsString = (String)this.getValue(rootMarker, "enabledValidatorList");
                enabledValidators = enabledValidatorsString == null ? ConfigurationConstants.DEFAULT_ENABLED_VALIDATORS : GlobalConfiguration.getStringAsEnabledElementsArray(enabledValidatorsString);
                this.setEnabledValidators(enabledValidators);
                this.setAutoValidate(this.getValue(rootMarker, "autoValidate", true));
                this.setBuildValidate(this.getValue(rootMarker, "runWhenBuild", true));
                this.setMaximumNumberOfMessages(this.getValue(rootMarker, "maxNumMessages", 50));
                this.setCanProjectsOverride(this.getValue(rootMarker, "projectsCanOverride", true));
                root.getWorkspace().deleteMarkers(marker);
            }
            catch (CoreException exc) {
                Logger logger = ValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block3;
                LogEntry entry = ValidationPlugin.getLogEntry();
                entry.setSourceIdentifier("GlobalConfiguration.loadV50");
                entry.setTargetException((Throwable)exc);
                logger.write(Level.SEVERE, (Object)entry);
            }
        }
    }

    protected void copyTo(GlobalConfiguration gp) throws InvocationTargetException {
        super.copyTo(gp);
        gp.setCanProjectsOverride(this.canProjectsOverride());
    }

    public static boolean getCanProjectsOverrideDefault() {
        return true;
    }

    public void deserialize(String storedConfiguration) throws InvocationTargetException {
        super.deserialize(storedConfiguration);
        if (storedConfiguration != null && storedConfiguration.length() > 0) {
            int canOverrideIndex = storedConfiguration.indexOf("projectsCanOverride");
            int autoIndex = storedConfiguration.indexOf("autoValidate");
            String canOverride = storedConfiguration.substring(canOverrideIndex + "projectsCanOverride".length(), autoIndex);
            this.setCanProjectsOverride(Boolean.valueOf(canOverride));
        }
    }

    public String serialize() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("projectsCanOverride");
        buffer.append(String.valueOf(this.canProjectsOverride()));
        buffer.append(super.serialize());
        return buffer.toString();
    }
}

