/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class OldJ2EESettingsForMigration {
    protected IFile fSettingsFile;
    protected IProject fProject;
    protected Document fDomDocument;
    protected J2EENature nature = null;
    public static String CURRENT_VERSION = "600";
    public static String VERSION_V4 = "400";
    public static final String ELEMENT_WORKSPACE_VERSION = "version";
    public static String J2EE_SETTINGS_FILE_NAME = ".j2ee";
    static final String ELEMENT_J2EESETTINGS = "j2eesettings";
    static final String ELEMENT_J2EE_MODULE_VERSION = "moduleversion";

    public OldJ2EESettingsForMigration(IProject project, J2EENature nature) {
        this.fProject = project;
        this.nature = nature;
        if (this.getDOMDocument() == null) {
            try {
                this.createNewDocument();
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
    }

    public OldJ2EESettingsForMigration(IProject project, J2EENature nature, IFile webSettings) {
        this.fProject = project;
        this.nature = nature;
    }

    protected void createNewDocument() throws CoreException, IOException {
        StringWriter writer = new StringWriter();
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write("\n");
        writer.write("<j2eesettings version=\"");
        writer.write(this.getCurrentVersion());
        writer.write("\">");
        writer.write("\n");
        writer.write("</j2eesettings>");
        writer.write("\n");
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(writer.toString().getBytes("UTF8"));
        IFile settingsFile = this.getSettingsFile();
        if (settingsFile.exists()) {
            settingsFile.setContents((InputStream)sourceStream, true, true, null);
        } else {
            settingsFile.create((InputStream)sourceStream, true, null);
        }
        this.read();
    }

    public OldJ2EESettingsForMigration(IProject project) {
        this.fProject = project;
        if (this.getDOMDocument() == null) {
            try {
                this.createNewDocument();
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
    }

    protected Document getDOMDocument() {
        if (this.fDomDocument == null) {
            try {
                this.read();
            }
            catch (IOException iOException) {}
        }
        return this.fDomDocument;
    }

    protected Document getDOMDocument(IFile webSettings) {
        if (this.fDomDocument == null) {
            try {
                this.read(webSettings);
            }
            catch (IOException iOException) {}
        }
        return this.fDomDocument;
    }

    public String getCurrentVersion() {
        return CURRENT_VERSION;
    }

    protected IFile getSettingsFile() {
        if (this.fSettingsFile == null) {
            this.fSettingsFile = this.fProject.getFile(J2EE_SETTINGS_FILE_NAME);
        }
        return this.fSettingsFile;
    }

    /*
     * Exception decompiling
     */
    protected void read() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 106->112)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void read(IFile settings) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 100->106)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void write() throws CoreException {
        if (this.fDomDocument == null) {
            return;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(this.fDomDocument.getDocumentElement()), new StreamResult(outStream));
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(outStream.toByteArray());
        IFile settingsFile = this.getSettingsFile();
        if (settingsFile.exists()) {
            settingsFile.setContents((InputStream)sourceStream, true, true, null);
        } else {
            settingsFile.create((InputStream)sourceStream, true, null);
        }
    }

    public String getVersion() {
        Document doc = this.getDOMDocument();
        if (doc == null) {
            return null;
        }
        Element root = doc.getDocumentElement();
        if (root == null) {
            return null;
        }
        if (!root.getNodeName().equalsIgnoreCase(this.getRootNodeName())) {
            return null;
        }
        return root.getAttribute(ELEMENT_WORKSPACE_VERSION);
    }

    public void setVersion(String version) {
        Document doc = this.getDOMDocument();
        if (doc == null) {
            return;
        }
        Element root = doc.getDocumentElement();
        if (root == null) {
            return;
        }
        if (!root.getNodeName().equalsIgnoreCase(this.getRootNodeName())) {
            return;
        }
        root.setAttribute(ELEMENT_WORKSPACE_VERSION, version);
    }

    protected void setValue(Element root, String nodeName, String value) {
        Node node = this.findOrCreateChildNode(root, nodeName);
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() == 0) {
            Text newText = this.getDOMDocument().createTextNode(value);
            node.appendChild(newText);
            root.appendChild(node);
        } else {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node curNode = childNodes.item(i);
                if (curNode.getNodeType() == 3) {
                    curNode.setNodeValue(value);
                }
                ++i;
            }
        }
    }

    protected Node findOrCreateChildNode(Element root, String nodeName) {
        Element node = this.findChildNode(root, nodeName);
        if (node == null) {
            node = this.getDOMDocument().createElement(nodeName);
            root.appendChild(node);
        }
        return node;
    }

    protected Element findChildNode(Element parent, String nodeName) {
        NodeList list = parent.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element curElement;
            Node curNode = list.item(i);
            if (curNode.getNodeType() == 1 && (curElement = (Element)curNode).getNodeName().equalsIgnoreCase(nodeName)) {
                return curElement;
            }
            ++i;
        }
        return null;
    }

    protected Document getOrCreateDocument() {
        Document doc = this.getDOMDocument();
        if (doc == null) {
            try {
                this.createNewDocument();
                doc = this.getDOMDocument();
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
        return doc;
    }

    protected Element getRootElement() {
        Document doc = this.getDOMDocument();
        if (doc == null) {
            return null;
        }
        Element root = doc.getDocumentElement();
        if (root == null) {
            return null;
        }
        if (!root.getNodeName().equalsIgnoreCase(this.getRootNodeName())) {
            return null;
        }
        return root;
    }

    protected String getValue(String settingName) {
        Element root = this.getRootElement();
        if (root == null) {
            return null;
        }
        return this.getNodeValue(root, settingName);
    }

    protected String getNodeValue(Element parent, String nodeName) {
        Element node;
        if (parent != null && (node = this.findChildNode(parent, nodeName)) != null) {
            return this.getChildText(node);
        }
        return null;
    }

    protected String getChildText(Element node) {
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Node curNode = list.item(i);
            if (curNode.getNodeType() == 3) {
                return curNode.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    protected void setValue(String nodeName, String value) {
        Document doc = this.getOrCreateDocument();
        this.setValue(doc.getDocumentElement(), nodeName, value);
    }

    public int getModuleVersion() {
        int version = 0;
        String moduleVer = this.getValue(ELEMENT_J2EE_MODULE_VERSION);
        if (moduleVer != null) {
            version = Integer.valueOf(moduleVer);
        }
        return version;
    }

    public void setModuleVersion(int moduleVersion) {
        Integer holder = new Integer(moduleVersion);
        this.setValue(ELEMENT_J2EE_MODULE_VERSION, holder.toString());
    }

    public String getRootNodeName() {
        return ELEMENT_J2EESETTINGS;
    }
}

