/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.taglib.registry;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.internal.web.locator.WebLibModuleTaglibLocator;
import org.eclipse.jst.j2ee.internal.web.locator.WebProjectServerTargetTaglibLocator;
import org.eclipse.jst.j2ee.internal.web.locator.WebProjectTaglibLocator;
import org.eclipse.jst.j2ee.internal.web.locator.WebXMLTaglibLocator;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibInfo;
import org.eclipse.jst.j2ee.internal.web.taglib.ITaglibLocator;
import org.eclipse.jst.j2ee.internal.web.taglib.registry.AbstractTaglibRegistry;

public class WebTaglibRegistry
extends AbstractTaglibRegistry {
    private ITaglibLocator libModuleLocator;
    private ITaglibLocator serverTargetLocator;
    private ITaglibLocator webProjectTaglibLocator;

    public WebTaglibRegistry(IProject project) {
        super(project);
    }

    protected void initialize() {
        this.libModuleLocator = new WebLibModuleTaglibLocator(this.project);
        this.serverTargetLocator = new WebProjectServerTargetTaglibLocator(this.project);
        this.webProjectTaglibLocator = new WebProjectTaglibLocator(this.project);
        this.locators = new ITaglibLocator[]{this.webProjectTaglibLocator, new WebXMLTaglibLocator(this.project)};
    }

    protected boolean isWebXMLFile(IPath filePath) {
        IPath webAppDDPath = this.getWebDeploymentDescriptorPath();
        return webAppDDPath.removeFirstSegments(1).equals((Object)filePath);
    }

    protected boolean requiresFullUpdate(IResourceDelta delta) {
        return false;
    }

    protected IResource getRefreshRoot() {
        return this.project;
    }

    protected boolean shouldProcessDirectory(IResource resource) {
        IContainer tagsFolder = this.getTagsFolder();
        return tagsFolder != null && tagsFolder.getProjectRelativePath().equals((Object)resource.getProjectRelativePath());
    }

    private IContainer getTagsFolder() {
        IResource tagsFolder;
        IContainer webinf = (IContainer)this.getRefreshRoot();
        if (webinf != null && (tagsFolder = webinf.findMember("tags")) != null && tagsFolder instanceof IContainer) {
            return (IContainer)tagsFolder;
        }
        return null;
    }

    protected boolean canVisitResource(IResource resource) {
        if (resource != null && resource.getType() != 8 && this.project != resource.getProject()) {
            return false;
        }
        IResource webinf = this.getRefreshRoot();
        if (webinf != null && resource != null && webinf.getProjectRelativePath().isPrefixOf(resource.getProjectRelativePath())) {
            return true;
        }
        return webinf != null && resource != null && resource.getProjectRelativePath().isPrefixOf(webinf.getProjectRelativePath());
    }

    protected void processDirectory(IResource resource) {
        Vector existingTaglibs = this.getExistingTaglibs(resource.getProjectRelativePath());
        ITaglibInfo[] newTaglibs = this.webProjectTaglibLocator.search(resource);
        int i = 0;
        while (i < newTaglibs.length) {
            ITaglibInfo newTaglib = newTaglibs[i];
            int existingIndex = existingTaglibs.indexOf(newTaglib);
            if (existingIndex >= 0) {
                if (!newTaglib.isWebXMLEntry()) {
                    this.fireTaglibChanged(newTaglib);
                }
                existingTaglibs.remove(existingIndex);
            } else {
                this.addTaglib(newTaglib);
                this.fireTaglibAdded(newTaglib);
            }
            ++i;
        }
        Iterator iter = existingTaglibs.iterator();
        while (iter.hasNext()) {
            ITaglibInfo remainingTaglib = (ITaglibInfo)iter.next();
            this.taglibs.remove(remainingTaglib);
            this.fireTaglibRemoved(remainingTaglib);
        }
    }

    protected Vector primGetTaglibs() {
        Vector<ITaglibInfo> results = new Vector<ITaglibInfo>();
        results.addAll(super.primGetTaglibs());
        results.addAll(Arrays.asList(this.libModuleLocator.search((IResource)this.project)));
        results.addAll(Arrays.asList(this.serverTargetLocator.search((IResource)this.project)));
        return results;
    }

    protected IPath getWebDeploymentDescriptorPath() {
        return null;
    }
}

