/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.command;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.PlatformUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.ws.internal.datamodel.Model;

public class DefaultsForClientJavaWSDLCommand
extends SimpleCommand {
    private JavaWSDLParameter javaWSDLParam_;
    private IProject proxyProject_;
    private String WSDLServiceURL_;
    private String WSDLServicePathname_;
    private MessageUtils msgUtils_;
    private MessageUtils coreMsgUtils_;
    private String moduleName_;
    private String LABEL = "TASK_LABEL_CLIENT_JAVA_WSDL_DEFAULTS";
    private String DESCRIPTION = "TASK_DESC_CLIENT_JAVA_WSDL_DEFAULTS";

    public DefaultsForClientJavaWSDLCommand(String moduleName) {
        String pluginId = "org.eclipse.jst.ws.axis.consumption.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.coreMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.core.consumption", (Object)this);
        this.setName(this.msgUtils_.getMessage(this.LABEL));
        this.setDescription(this.msgUtils_.getMessage(this.DESCRIPTION));
        this.moduleName_ = moduleName;
    }

    public DefaultsForClientJavaWSDLCommand(JavaWSDLParameter javaWSDLParam, Model model) {
        String pluginId = "org.eclipse.jst.ws.axis.consumption.ui";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.coreMsgUtils_ = new MessageUtils("org.eclipse.jst.ws.axis.consumption.core.consumption", (Object)this);
        this.setName(this.msgUtils_.getMessage(this.LABEL));
        this.setDescription(this.msgUtils_.getMessage(this.DESCRIPTION));
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public Status execute(Environment environment) {
        if (this.javaWSDLParam_ == null) {
            SimpleStatus status = new SimpleStatus("DefaultsForClientJavaWSDLCommand", this.coreMsgUtils_.getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"), 4);
            environment.getStatusHandler().reportError((Status)status);
            return status;
        }
        this.javaWSDLParam_.setMetaInfOnly(false);
        this.javaWSDLParam_.setServerSide((byte)0);
        IPath webModuleServerRoot = ResourceUtils.getJavaSourceLocation((IProject)this.proxyProject_, (String)this.moduleName_);
        String output = ResourceUtils.findResource((IPath)webModuleServerRoot).getLocation().toString();
        this.javaWSDLParam_.setJavaOutput(output);
        IFolder webModuleContainer = ResourceUtils.getWebComponentServerRoot((IProject)this.proxyProject_, (String)this.moduleName_);
        if (webModuleContainer != null) {
            IPath webModulePath = webModuleContainer.getFullPath();
            IResource res = ResourceUtils.findResource((IPath)webModulePath);
            if (res != null) {
                output = res.getLocation().toString();
            }
            this.javaWSDLParam_.setOutput(output);
        }
        if (this.WSDLServicePathname_ == null) {
            if (this.WSDLServiceURL_ == null) {
                SimpleStatus status = new SimpleStatus("DefaultsForClientJavaWSDLCommand", this.msgUtils_.getMessage("MSG_ERROR_WSDL_LOCATION_NOT_SET"), 4);
                environment.getStatusHandler().reportError((Status)status);
                return status;
            }
        } else {
            this.WSDLServiceURL_ = PlatformUtils.getFileFromPlatform(this.WSDLServicePathname_);
        }
        this.javaWSDLParam_.setInputWsdlLocation(this.WSDLServiceURL_);
        return new SimpleStatus("");
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public void setProxyProject(IProject proxyProject) {
        this.proxyProject_ = proxyProject;
    }

    public void setWSDLServiceURL(String serviceURL) {
        this.WSDLServiceURL_ = serviceURL;
    }

    public void setWSDLServicePathname(String servicePathname) {
        this.WSDLServicePathname_ = servicePathname;
    }
}

