/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.CommonRelationship;
import org.eclipse.jst.j2ee.ejb.CommonRelationshipRole;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.internal.ejb.EjbPackage;
import org.eclipse.jst.j2ee.internal.ejb.impl.EjbFactoryImpl;

public abstract class CommonRelationshipAttributeMaintenanceAdapter
extends AdapterImpl {
    protected static EjbPackage EJB_PACK = EjbFactoryImpl.getPackage();

    public void notifyChanged(Notification msg) {
        switch (msg.getEventType()) {
            case 3: {
                this.addedNotification(msg);
                break;
            }
            case 4: {
                this.removedNotification(msg);
            }
        }
    }

    protected void addedNotification(Notification msg) {
        if ((EStructuralFeature)msg.getFeature() == EJB_PACK.getContainerManagedEntity_KeyAttributes()) {
            this.addedKeyAttribute((ContainerManagedEntity)msg.getNotifier(), (CMPAttribute)msg.getNewValue());
        } else if (this.isRelationshipsSF((EObject)((EStructuralFeature)msg.getFeature()))) {
            this.added();
        } else if (this.isRelationshipRolesSF((EObject)((EStructuralFeature)msg.getFeature()))) {
            this.addedRole((CommonRelationshipRole)msg.getNewValue());
        }
    }

    protected void removedNotification(Notification msg) {
        if ((EStructuralFeature)msg.getFeature() == EJB_PACK.getContainerManagedEntity_KeyAttributes()) {
            this.removedKeyAttribute((ContainerManagedEntity)msg.getNotifier(), (CMPAttribute)msg.getOldValue());
        } else if (this.isRelationshipsSF((EObject)((EStructuralFeature)msg.getFeature()))) {
            this.removed();
        } else if (this.isRelationshipRolesSF((EObject)((EStructuralFeature)msg.getFeature()))) {
            this.removedRole((CommonRelationshipRole)msg.getOldValue());
        }
    }

    protected abstract boolean isRelationshipRolesSF(EObject var1);

    protected abstract boolean isRelationshipsSF(EObject var1);

    private void removedKeyAttribute(ContainerManagedEntity aCMPEntity, CMPAttribute cmpAttribute) {
        this.addedKeyAttribute(aCMPEntity, cmpAttribute);
    }

    protected void addedKeyAttribute(ContainerManagedEntity aCMPEntity, CMPAttribute newAttribute) {
        CommonRelationshipRole inverse;
        CommonRelationshipRole role = this.getRole(aCMPEntity);
        if (role != null && !role.isForward() && (inverse = role.getOppositeAsCommonRole()) != null) {
            inverse.reconcileAttributes();
        }
    }

    protected CommonRelationshipRole getRole(ContainerManagedEntity aCMPEntity) {
        CommonRelationship relation = this.getRelationship();
        if (relation == null) {
            return null;
        }
        EList roles = relation.getCommonRoles();
        if (roles.isEmpty()) {
            return null;
        }
        CommonRelationshipRole role = null;
        int i = 0;
        while (i < roles.size()) {
            role = (CommonRelationshipRole)roles.get(i);
            if (role.getSourceEntity() == aCMPEntity) {
                return role;
            }
            ++i;
        }
        return role;
    }

    protected CommonRelationship getRelationship() {
        return (CommonRelationship)this.getTarget();
    }

    protected void reconcileRoleAttributes() {
        EList roles = this.getRelationship().getCommonRoles();
        if (roles.isEmpty()) {
            return;
        }
        CommonRelationshipRole role = null;
        int i = 0;
        while (i < roles.size()) {
            role = (CommonRelationshipRole)roles.get(i);
            role.reconcileAttributes();
            ++i;
        }
    }

    protected void added() {
        this.reconcileRoleAttributes();
    }

    protected void removed() {
        if (this.getRelationship().getCommonRoles().size() > 1) {
            this.getRelationship().getCommonRoles().remove(0);
        }
    }

    protected void addAdaptors(CommonRelationshipRole aRole) {
        this.removeAdaptors(aRole);
        aRole.eAdapters().add((Object)this);
        ContainerManagedEntity cmp = aRole.getSourceEntity();
        if (cmp != null) {
            cmp.eAdapters().add((Object)this);
        }
    }

    protected void removeAdaptors(CommonRelationshipRole aRole) {
        aRole.eAdapters().remove((Object)this);
        ContainerManagedEntity cmp = aRole.getSourceEntity();
        if (cmp != null) {
            cmp.eAdapters().remove((Object)this);
        }
    }

    protected void addedRole(CommonRelationshipRole aRole) {
        this.addAdaptors(aRole);
        if (this.getRelationship().eContainer() != null && this.rolesFullyReflected()) {
            this.reconcileRoleAttributes();
        }
    }

    protected boolean rolesFullyReflected() {
        EList roles = this.getRelationship().getCommonRoles();
        if (roles.isEmpty()) {
            return false;
        }
        CommonRelationshipRole role = null;
        int i = 0;
        while (i < roles.size()) {
            role = (CommonRelationshipRole)roles.get(i);
            if (role.getSourceEntity() == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void removedRole(CommonRelationshipRole aRole) {
        this.removeAdaptors(aRole);
        if (this.getRelationship().eContainer() != null) {
            aRole.reconcileAttributes();
            this.reconcileRoleAttributes();
        }
    }

    public void setTarget(Notifier notifier) {
        if (notifier == null || notifier instanceof CommonRelationship) {
            super.setTarget(notifier);
        }
    }
}

