/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.migration;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.ejb.AcknowledgeMode;
import org.eclipse.jst.j2ee.ejb.ActivationConfig;
import org.eclipse.jst.j2ee.ejb.ActivationConfigProperty;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.DestinationType;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.MessageDrivenDestination;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.QueryMethod;
import org.eclipse.jst.j2ee.ejb.SubscriptionDurabilityKind;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.jst.j2ee.internal.common.CommonPackage;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.common.impl.CompatibilityDescriptionGroupImpl;
import org.eclipse.jst.j2ee.internal.ejb.EjbPackage;
import org.eclipse.jst.j2ee.internal.ejb.impl.EjbFactoryImpl;
import org.eclipse.jst.j2ee.internal.migration.Connector14SpecificationMigrator;
import org.eclipse.jst.j2ee.internal.migration.J2EEMigrationMultiStatus;
import org.eclipse.jst.j2ee.internal.migration.J2EEMigrationStatus;
import org.eclipse.jst.j2ee.internal.migration.J2EESpecificationMigrationConstants;
import org.eclipse.jst.j2ee.internal.migration.SpecificationMigrator;
import org.eclipse.jst.j2ee.internal.migration.War14SpecificationMigrator;
import org.eclipse.jst.j2ee.jca.ConnectorResource;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;

public class J2EESpecificationMigrator
extends SpecificationMigrator
implements J2EEConstants,
J2EESpecificationMigrationConstants {
    private static final EClass COMPATIBILITY_DESCRIPTION_GROUP_ECLASS = CommonPackage.eINSTANCE.getCompatibilityDescriptionGroup();

    public J2EESpecificationMigrator(String aVersion, boolean complex) {
        super(aVersion, complex);
    }

    public J2EESpecificationMigrator(XMLResource anXmlResource, String aVersion, boolean complex) {
        super(anXmlResource, aVersion, complex);
    }

    protected QueryMethod convertMethodElementToQueryMethod(MethodElement me) {
        QueryMethod queryMethod = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createQueryMethod();
        queryMethod.setParms(me.getParms());
        queryMethod.setName(me.getName());
        return queryMethod;
    }

    protected void ensureBeanVersionsSet(EJBJar jar) {
        if (jar != null) {
            EList beans = jar.getEnterpriseBeans();
            int size = beans.size();
            int i = 0;
            while (i < size) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                if (bean.isContainerManagedEntity() && ((ContainerManagedEntity)bean).isVersion1_X()) {
                    ((ContainerManagedEntity)bean).setVersion("1.x");
                }
                ++i;
            }
        }
    }

    protected String format(String aPattern, String arg1) {
        return MessageFormat.format(aPattern, arg1);
    }

    protected String format(String aPattern, String arg1, String arg2) {
        return MessageFormat.format(aPattern, arg1, arg2);
    }

    protected J2EEMigrationStatus getMigrateToLowerLevelStatus(EJBJar ejbJar) {
        J2EEMigrationStatus status = null;
        if (ejbJar != null) {
            EList beans = ejbJar.getEnterpriseBeans();
            int size = beans.size();
            int i = 0;
            while (i < size) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                J2EEMigrationStatus beanStatus = this.getMigrateToLowerLevelStatus(bean);
                status = status == null ? beanStatus : status.append(beanStatus);
                ++i;
            }
        }
        return status;
    }

    protected J2EEMigrationStatus getMigrateToLowerLevelStatus(EnterpriseBean bean) {
        if (bean.isMessageDriven() && this.isVersion1_2()) {
            return new J2EEMigrationStatus(2, bean);
        }
        if (bean.isContainerManagedEntity() && ((ContainerManagedEntity)bean).isVersion2_X() && this.isVersion1_2()) {
            return new J2EEMigrationStatus(2, bean);
        }
        return null;
    }

    protected J2EEMigrationStatus migrate(ContainerManagedEntity aCMP) {
        boolean is1_x = aCMP.getVersion().equals("1.x");
        if (this.isVersion1_2() && !is1_x) {
            return new J2EEMigrationStatus(2, aCMP);
        }
        if ((this.isVersion1_4() || this.isVersion1_3()) && is1_x) {
            return this.migrate1_xCMPFor2_0Target(aCMP);
        }
        return new J2EEMigrationStatus(1, aCMP);
    }

    protected void migrateDescriptionsTo14(XMLResource resource) {
        ((EJBResource)resource).getEJBJar().getDescription();
    }

    protected J2EEMigrationStatus migrateTo13(EnterpriseBean anEJB) {
        if (anEJB != null && this.getVersion() != null) {
            if (anEJB.isContainerManagedEntity()) {
                return this.migrate((ContainerManagedEntity)anEJB);
            }
            return this.migrateBeanInterfaces(anEJB);
        }
        return new J2EEMigrationStatus(1, anEJB);
    }

    protected J2EEMigrationStatus migrate1_xCMPFor2_0Target(ContainerManagedEntity aCMP) {
        aCMP.setVersion("2.x");
        if (!this.isComplex()) {
            aCMP.setVersion("1.x");
        } else {
            aCMP.setAbstractSchemaName(aCMP.getName());
        }
        return new J2EEMigrationStatus(0, aCMP);
    }

    protected J2EEMigrationStatus migrateBeanInterfaces(EnterpriseBean anEJB) {
        if (this.isVersion1_2() && anEJB.getVersionID() >= 20 && anEJB.hasLocalClient()) {
            anEJB.setLocalInterface(null);
            anEJB.setLocalHomeInterface(null);
            return new J2EEMigrationStatus(3, anEJB, this.format(REMOVED_LOCAL_CLIENT_MSG, anEJB.getName()));
        }
        return new J2EEMigrationStatus(1, anEJB);
    }

    private J2EEMigrationMultiStatus migrateBeans13(EJBJar jar) {
        J2EEMigrationMultiStatus status = new J2EEMigrationMultiStatus();
        if (jar != null) {
            EList beans = jar.getEnterpriseBeans();
            int size = beans.size();
            int i = 0;
            while (i < size) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                status.merge(this.migrateTo13(bean));
                ++i;
            }
        }
        return status;
    }

    private J2EEMigrationMultiStatus migrateBeans14(EJBJar jar, HashMap beanMap) {
        J2EEMigrationMultiStatus status = new J2EEMigrationMultiStatus();
        if (jar != null) {
            EList beans = jar.getEnterpriseBeans();
            int size = beans.size();
            int i = 0;
            while (i < size) {
                EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                status.merge(this.migrateTo14Bean(bean, beanMap));
                ++i;
            }
        }
        return status;
    }

    private J2EEMigrationStatus migrateMessageDrivenTo14(MessageDriven anEJB) {
        String messageSelector;
        MessageDrivenDestination destination;
        ActivationConfig config = EjbFactoryImpl.getActiveFactory().createActivationConfig();
        ActivationConfigProperty property = null;
        AcknowledgeMode ackMode = anEJB.getAcknowledgeMode();
        String ackModeName = ackMode.getName();
        if (ackModeName != null && ackModeName.length() > 0) {
            property = EjbFactoryImpl.getActiveFactory().createActivationConfigProperty();
            property.setName("acknowledgeMode");
            property.setValue(ackModeName);
            config.getConfigProperties().add((Object)property);
            anEJB.setAcknowledgeMode(null);
        }
        if ((destination = anEJB.getDestination()) != null) {
            this.create14Destination(anEJB, destination, config);
        }
        if ((messageSelector = anEJB.getMessageSelector()) != null && messageSelector.length() > 0) {
            property = EjbFactoryImpl.getActiveFactory().createActivationConfigProperty();
            property.setName("messageSelector");
            property.setValue(messageSelector);
            config.getConfigProperties().add((Object)property);
            anEJB.setMessageSelector(null);
        }
        anEJB.setActivationConfig(config);
        return new J2EEMigrationStatus(0, anEJB);
    }

    private void create14Destination(MessageDriven bean, MessageDrivenDestination destination, ActivationConfig config) {
        JavaHelpers helper;
        DestinationType type = destination.getType();
        String typeString = null;
        if (type != null) {
            switch (type.getValue()) {
                case 0: {
                    typeString = "javax.jms.Queue";
                    break;
                }
                case 1: {
                    typeString = "javax.jms.Topic";
                }
            }
        }
        if ((helper = JavaRefFactory.eINSTANCE.reflectType(typeString, bean.eContainer())) != null) {
            bean.setMessageDestination(helper.getWrapper());
        }
        ActivationConfigProperty property = EjbFactoryImpl.getActiveFactory().createActivationConfigProperty();
        property.setName("destinationType");
        property.setValue(typeString);
        config.getConfigProperties().add((Object)property);
        SubscriptionDurabilityKind durability = destination.getSubscriptionDurability();
        String durabilityName = durability.getName();
        if (durabilityName != null && durabilityName.length() > 0) {
            property = EjbFactoryImpl.getActiveFactory().createActivationConfigProperty();
            property.setName("subscriptionDurability");
            property.setValue(durabilityName);
            config.getConfigProperties().add((Object)property);
            bean.getDestination().setSubscriptionDurability(null);
        }
    }

    protected J2EEMigrationStatus migrateTo13(ApplicationClientResource appClientResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEMigrationStatus(1, appClientResource);
        }
        boolean isVersion1_3 = this.isVersion1_3();
        String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN" : "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN";
        String sysId = isVersion1_3 ? "http://java.sun.com/dtd/application-client_1_3.dtd" : "http://java.sun.com/j2ee/dtds/application-client_1_2.dtd";
        appClientResource.setDoctypeValues(pubId, sysId);
        return new J2EEMigrationStatus(0, appClientResource);
    }

    protected J2EEMigrationStatus migrateTo13(ApplicationResource appResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEMigrationStatus(1, appResource);
        }
        boolean isVersion1_3 = this.isVersion1_3();
        String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN" : "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
        String sysId = isVersion1_3 ? "http://java.sun.com/dtd/application_1_3.dtd" : "http://java.sun.com/j2ee/dtds/application_1_2.dtd";
        appResource.setDoctypeValues(pubId, sysId);
        return new J2EEMigrationStatus(0, appResource);
    }

    protected J2EEMigrationStatus migrateTo13(EJBResource ejbResource) {
        J2EEMigrationStatus status = null;
        boolean b = this.basicNeedsToMigrate();
        boolean isVersion1_3 = this.isVersion1_3();
        EJBJar jar = ejbResource.getEJBJar();
        if (b) {
            if (!isVersion1_3 && (status = this.getMigrateToLowerLevelStatus(jar)) != null) {
                return status;
            }
            this.ensureBeanVersionsSet(jar);
            String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN" : "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
            String sysId = isVersion1_3 ? "http://java.sun.com/dtd/ejb-jar_2_0.dtd" : "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd";
            ejbResource.setDoctypeValues(pubId, sysId);
        } else {
            status = new J2EEMigrationStatus(1, ejbResource);
        }
        boolean notNeeded = status != null;
        status = this.mergeStatuses(status, this.migrateBeans13(jar));
        if (!notNeeded) {
            status = this.mergeStatuses(status, new J2EEMigrationStatus(0, ejbResource));
        }
        return status;
    }

    protected J2EEMigrationStatus migrateTo13(WebAppResource webResource) {
        if (!this.basicNeedsToMigrate()) {
            return new J2EEMigrationStatus(1, webResource);
        }
        boolean isVersion1_3 = this.isVersion1_3();
        String pubId = isVersion1_3 ? "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN" : "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
        String sysId = isVersion1_3 ? "http://java.sun.com/dtd/web-app_2_3.dtd" : "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd";
        webResource.setDoctypeValues(pubId, sysId);
        return new J2EEMigrationStatus(0, webResource);
    }

    protected J2EEMigrationStatus migrateTo14(ApplicationClientResource appClientResource) {
        if (!this.basicNeedsMigrationTo14()) {
            return new J2EEMigrationStatus(1, appClientResource);
        }
        appClientResource.setModuleVersionID(14);
        this.migrateCompatibilityDescriptionGroup(appClientResource);
        EObject rootObject = appClientResource.getRootObject();
        appClientResource.removePreservingIds(rootObject);
        appClientResource.getContents().remove((Object)rootObject);
        appClientResource.getContents().add((Object)rootObject);
        return new J2EEMigrationStatus(0, appClientResource);
    }

    protected J2EEMigrationStatus migrateTo14(ApplicationResource appResource) {
        if (!this.basicNeedsMigrationTo14()) {
            return new J2EEMigrationStatus(1, appResource);
        }
        appResource.setJ2EEVersionID(14);
        this.migrateCompatibilityDescriptionGroup(appResource);
        EObject rootObject = appResource.getRootObject();
        appResource.removePreservingIds(rootObject);
        appResource.getContents().add((Object)rootObject);
        return new J2EEMigrationStatus(0, appResource);
    }

    protected J2EEMigrationStatus migrateTo14(ConnectorResource connectorResource) {
        if (!this.basicNeedsMigrationTo14()) {
            return new J2EEMigrationStatus(1, connectorResource);
        }
        connectorResource.setModuleVersionID(15);
        EObject rootObject = connectorResource.getRootObject();
        connectorResource.getContents().remove((Object)rootObject);
        connectorResource.getContents().add((Object)rootObject);
        Connector14SpecificationMigrator migrator = new Connector14SpecificationMigrator();
        J2EEMigrationStatus status = migrator.migrateConnectorTo14(connectorResource.getConnector());
        status = this.mergeStatuses(status, new J2EEMigrationStatus(0, connectorResource));
        return status;
    }

    protected J2EEMigrationStatus migrateTo14(EJBResource ejbResource) {
        J2EEMigrationStatus status = null;
        boolean b = this.basicNeedsMigrationTo14();
        boolean isVersion1_4 = this.isVersion1_4();
        EJBJar jar = ejbResource.getEJBJar();
        HashMap beanCache = new HashMap();
        if (jar.getVersionID() == 11) {
            this.createBeanCache(jar, beanCache);
        }
        if (b) {
            if (!isVersion1_4 && (status = this.getMigrateToLowerLevelStatus(jar)) != null) {
                return status;
            }
            ejbResource.setModuleVersionID(21);
            this.migrateCompatibilityDescriptionGroup(ejbResource);
            EObject rootObject = ejbResource.getRootObject();
            ejbResource.removePreservingIds(rootObject);
            ejbResource.getContents().add((Object)rootObject);
        } else {
            status = new J2EEMigrationStatus(1, ejbResource);
        }
        boolean notNeeded = status != null;
        status = this.mergeStatuses(status, this.migrateBeans14(jar, beanCache));
        if (!notNeeded) {
            status = this.mergeStatuses(status, new J2EEMigrationStatus(0, ejbResource));
        }
        return status;
    }

    protected void migrateCompatibilityDescriptionGroup(XMLResource resource) {
        TreeIterator contents = resource.getAllContents();
        EObject object = null;
        while (contents.hasNext()) {
            object = (EObject)contents.next();
            this.migrateCompatibilityDescriptionGroup(object);
        }
    }

    protected void migrateCompatibilityDescriptionGroup(EObject eObj) {
        if (COMPATIBILITY_DESCRIPTION_GROUP_ECLASS.isInstance((Object)eObj)) {
            CompatibilityDescriptionGroupImpl cg = (CompatibilityDescriptionGroupImpl)eObj;
            if (cg.getDisplayNameGen() != null) {
                cg.setDisplayName(cg.getDisplayNameGen());
            }
            if (cg.getDescriptionGen() != null) {
                cg.setDescription(cg.getDescriptionGen());
            }
            if (cg.getLargeIconGen() != null) {
                cg.setLargeIcon(cg.getLargeIconGen());
            }
            if (cg.getSmallIconGen() != null) {
                cg.setSmallIcon(cg.getSmallIconGen());
            }
        }
    }

    private void createBeanCache(EJBJar jar, HashMap beanCache) {
        EList beans = jar.getEnterpriseBeans();
        int i = 0;
        while (i < beans.size()) {
            EnterpriseBean bean = (EnterpriseBean)beans.get(i);
            if (bean.isContainerManagedEntity() && ((ContainerManagedEntity)bean).isVersion1_X()) {
                beanCache.put(bean, "1.x");
            }
            ++i;
        }
    }

    protected J2EEMigrationStatus migrateTo14(WebAppResource webResource) {
        J2EEMigrationStatus status = null;
        try {
            if (!this.basicNeedsMigrationTo14()) {
                return new J2EEMigrationStatus(1, webResource);
            }
            webResource.setModuleVersionID(24);
            this.migrateCompatibilityDescriptionGroup(webResource);
            EObject rootObject = webResource.getRootObject();
            webResource.removePreservingIds(rootObject);
            webResource.getContents().add((Object)rootObject);
            webResource.saveIfNecessary();
            War14SpecificationMigrator migrator = new War14SpecificationMigrator();
            status = migrator.migrateWebAppTo14(webResource.getWebApp());
            status = this.mergeStatuses(status, new J2EEMigrationStatus(0, webResource));
            return status;
        }
        catch (Exception e) {
            Logger.getLogger().logError((Throwable)e);
            return status;
        }
    }

    private J2EEMigrationStatus migrateTo14Bean(EnterpriseBean anEJB, HashMap beanMap) {
        if (!anEJB.isMessageDriven()) {
            if (anEJB != null && this.getVersion() != null) {
                if (anEJB.isContainerManagedEntity()) {
                    return this.migrate((ContainerManagedEntity)anEJB, beanMap);
                }
                return this.migrateBeanInterfaces(anEJB);
            }
            return new J2EEMigrationStatus(1, anEJB);
        }
        if (anEJB.isMessageDriven()) {
            return this.migrateMessageDrivenTo14((MessageDriven)anEJB);
        }
        return new J2EEMigrationStatus(1, anEJB);
    }

    protected J2EEMigrationStatus migrate(ContainerManagedEntity aCMP, HashMap beanMap) {
        boolean is1_x;
        String versionString = (String)beanMap.get(aCMP);
        boolean bl = is1_x = versionString != null && versionString.equals("1.x");
        if (this.isVersion1_2() && !is1_x) {
            return new J2EEMigrationStatus(2, aCMP);
        }
        if ((this.isVersion1_4() || this.isVersion1_3()) && is1_x) {
            return this.migrate1_xCMPFor2_0Target(aCMP);
        }
        return new J2EEMigrationStatus(1, aCMP);
    }
}

