/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.migration;

import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.migration.J2EEMigrationStatus;
import org.eclipse.jst.j2ee.internal.migration.J2EESpecificationMigrationConstants;
import org.eclipse.jst.j2ee.jca.ConnectorResource;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;

public class SpecificationMigrator
implements J2EEConstants,
J2EESpecificationMigrationConstants {
    private boolean isComplex;
    private String version;
    private XMLResource xmlResource;

    public SpecificationMigrator(String aVersion, boolean complex) {
        this.version = aVersion;
        this.isComplex = complex;
    }

    public SpecificationMigrator(XMLResource anXmlResource, String aVersion, boolean complex) {
        this.xmlResource = anXmlResource;
        this.version = aVersion;
        this.isComplex = complex;
    }

    public J2EEMigrationStatus migrateTo13() {
        if (this.xmlResource != null && this.version != null) {
            switch (this.xmlResource.getType()) {
                case 1: {
                    return this.migrateTo13((ApplicationClientResource)this.xmlResource);
                }
                case 2: {
                    return this.migrateTo13((ApplicationResource)this.xmlResource);
                }
                case 3: {
                    return this.migrateTo13((EJBResource)this.xmlResource);
                }
                case 4: {
                    return this.migrateTo13((WebAppResource)this.xmlResource);
                }
            }
        }
        return new J2EEMigrationStatus(1, this.xmlResource);
    }

    protected J2EEMigrationStatus migrateTo13(WebAppResource resource) {
        return null;
    }

    protected J2EEMigrationStatus migrateTo13(EJBResource resource) {
        return null;
    }

    protected J2EEMigrationStatus migrateTo13(ApplicationResource resource) {
        return null;
    }

    protected J2EEMigrationStatus migrateTo13(ApplicationClientResource resource) {
        return null;
    }

    public J2EEMigrationStatus migrateTo14() {
        if (this.xmlResource != null && this.version != null) {
            switch (this.xmlResource.getType()) {
                case 1: {
                    return this.migrateTo14((ApplicationClientResource)this.xmlResource);
                }
                case 2: {
                    return this.migrateTo14((ApplicationResource)this.xmlResource);
                }
                case 3: {
                    return this.migrateTo14((EJBResource)this.xmlResource);
                }
                case 4: {
                    return this.migrateTo14((WebAppResource)this.xmlResource);
                }
                case 5: {
                    return this.migrateTo14((ConnectorResource)this.xmlResource);
                }
            }
        }
        return new J2EEMigrationStatus(1, this.xmlResource);
    }

    protected J2EEMigrationStatus migrateTo14(ApplicationClientResource resource) {
        return null;
    }

    protected J2EEMigrationStatus migrateTo14(ApplicationResource resource) {
        return null;
    }

    protected J2EEMigrationStatus migrateTo14(EJBResource resource) {
        return null;
    }

    protected J2EEMigrationStatus migrateTo14(WebAppResource resource) {
        return null;
    }

    protected J2EEMigrationStatus migrateTo14(ConnectorResource resource) {
        return null;
    }

    protected boolean basicNeedsMigrationTo14() {
        boolean isResource1_4 = this.xmlResource.getVersionID() == 14;
        boolean isTarget1_4 = this.isVersion1_4();
        return isResource1_4 && !isTarget1_4 || !isResource1_4 && isTarget1_4;
    }

    protected boolean basicNeedsToMigrate() {
        boolean isResource1_3 = this.xmlResource.getVersionID() == 13;
        boolean isTarget1_3 = this.isVersion1_3();
        return isResource1_3 && !isTarget1_3 || !isResource1_3 && isTarget1_3;
    }

    protected J2EEMigrationStatus mergeStatuses(J2EEMigrationStatus status1, J2EEMigrationStatus status2) {
        if (status1 != null) {
            return status1.append(status2);
        }
        return status2;
    }

    protected boolean isVersion1_2() {
        return this.version == "J2EE_1.2";
    }

    protected boolean isVersion1_3() {
        return this.version == "J2EE_1.3";
    }

    protected boolean isVersion1_4() {
        return this.version == "J2EE_1.4";
    }

    protected boolean isComplex() {
        return this.isComplex;
    }

    public String getVersion() {
        return this.version;
    }

    public XMLResource getXmlResource() {
        return this.xmlResource;
    }
}

