/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.webservice.helper.WebServicesManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.ws.internal.parser.wsil.WebServiceEntity;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class WSDLServiceHelperImpl
implements WSDLServiceHelper {
    public String getPortName(Object port) {
        Port aPort = (Port)port;
        return aPort.getName();
    }

    public Map getServicePorts(Object aService) {
        Service service = (Service)aService;
        return service.getPorts();
    }

    public String getServiceNamespaceURI(Object aService) {
        Service service = (Service)aService;
        return service.getQName().getNamespaceURI();
    }

    public Object getServiceDefinitionLocation(EObject aService) {
        Service service = (Service)aService;
        return service.getEnclosingDefinition().getLocation();
    }

    public String getPortBindingNamespaceURI(Object aPort) {
        Port port = (Port)aPort;
        return port.getBinding().getQName().getNamespaceURI();
    }

    public String getServiceLocalPart(Object aService) {
        Service service = (Service)aService;
        return service.getQName().getLocalPart();
    }

    public Object getServiceQName(Object aService) {
        Service service = (Service)aService;
        return service.getQName();
    }

    public Map getDefinitionServices(Object aDefinition) {
        Definition definition = (Definition)aDefinition;
        return definition.getServices();
    }

    public Object getWSDLDefinition(String wsdlURL) {
        try {
            WSDLResourceImpl res = (WSDLResourceImpl)WorkbenchResourceHelperBase.getResource((URI)URI.createURI((String)wsdlURL), (boolean)true);
            if (res == null) {
                return null;
            }
            return res.getDefinition();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getWSDLDefinition(Resource wsdlResource) {
        return ((WSDLResourceImpl)wsdlResource).getDefinition();
    }

    public List getWsdlServicesFromWsilFile(IFile wsil) {
        ArrayList result = new ArrayList();
        WebServiceEntity entity = this.parseWsilFile(wsil);
        if (entity != null && entity.getType() == 1) {
            List wsdlList = entity.getChildren();
            Iterator it = wsdlList.iterator();
            while (it.hasNext()) {
                Definition def;
                Object item = it.next();
                if (item == null || !(item instanceof WebServiceEntity) || ((WebServiceEntity)item).getModel() == null || !(((WebServiceEntity)item).getModel() instanceof Definition) || (def = (Definition)((WebServiceEntity)item).getModel()) == null || def.getServices().isEmpty()) continue;
                result.addAll(def.getServices().values());
            }
        }
        return result;
    }

    public WebServiceEntity parseWsilFile(IFile wsil) {
        WebServicesParser parser = null;
        String url = null;
        if (wsil == null || !wsil.getFileExtension().equals("wsil")) {
            return null;
        }
        try {
            url = wsil.getLocation().toFile().toURL().toString();
            parser = new WebServicesParser(url);
            parser.parse(3);
        }
        catch (Exception exception) {}
        if (parser == null) {
            return null;
        }
        return parser.getWebServiceEntityByURI(url);
    }

    public boolean isService(Object aService) {
        return aService instanceof Service;
    }

    public boolean isWSDLResource(Object aResource) {
        return aResource instanceof WSDLResourceImpl;
    }

    public boolean isDefinition(Object aDefinition) {
        return aDefinition instanceof Definition;
    }

    public List get13ServiceRefs(EObject j2eeObject) {
        if (j2eeObject instanceof ApplicationClient) {
            return WebServicesManager.getInstance().get13ServiceRefs((ApplicationClient)j2eeObject);
        }
        if (j2eeObject instanceof EnterpriseBean) {
            return WebServicesManager.getInstance().get13ServiceRefs((EnterpriseBean)j2eeObject);
        }
        if (j2eeObject instanceof WebApp) {
            return WebServicesManager.getInstance().get13ServiceRefs((WebApp)j2eeObject);
        }
        return Collections.EMPTY_LIST;
    }
}

