/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import java.sql.Connection;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.NewConnectionWizard;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.RDBWizardPage;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.util.DatabaseProviderHelper;

public class ConnectionUtils {
    private static boolean isFinalConnection;
    private static Shell theShell;

    public static boolean openConnectionWithProgress(ConnectionInfo connectionInfo, boolean showSuccessfulMessage, IWizardContainer container) {
        theShell = container.getShell();
        ConnectionInfo connection = connectionInfo;
        try {
            try {
                container.run(true, true, ConnectionUtils.getTestRunnable(connection, 2, showSuccessfulMessage));
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)RDBWizardPage.getBundle().getString("CUI_WIZARD_ERRTITLE_UI_"), (String)NewConnectionWizard.getMessages(e));
            return false;
        }
        return isFinalConnection;
    }

    private static IRunnableWithProgress getTestRunnable(final ConnectionInfo connection, int conType, final boolean showStatus) {
        IRunnableWithProgress progMonitor = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("", 3);
                if (showStatus) {
                    monitor.setTaskName(RDBWizardPage.getBundle().getString("TEST_CONNECTION_PROGRESS_BAR_MESSAGE_UI_"));
                }
                monitor.worked(1);
                try {
                    if (connection.getSharedConnection() == null) {
                        Connection cnx = connection.connect();
                        if (cnx == null) {
                            throw new Exception(RDBWizardPage.getBundle().getString("CUI_TESTCONNECTION_ERROR_UI_"));
                        }
                        connection.setSharedConnection(cnx);
                        new DatabaseProviderHelper().setDatabase(cnx, connection, connection.getDatabaseName());
                        connection.saveConnectionInfo();
                    }
                    isFinalConnection = true;
                    if (showStatus) {
                        String title = RDBWizardPage.getBundle().getString("CUI_TESTCONNECTION_TITLE_UI_");
                        String message = RDBWizardPage.getBundle().getString("CUI_TESTCONNECTION_SUCCESS_UI_");
                        message = MessageFormat.format(message, connection.getDatabaseDefinition().getProduct());
                        monitor.worked(2);
                        theShell.getDisplay().asyncExec((Runnable)new DisplayMessage(title, message));
                    }
                }
                catch (Exception e) {
                    isFinalConnection = false;
                    String title = RDBWizardPage.getBundle().getString("CUI_TESTCONNECTION_TITLE_UI_");
                    String message = RDBWizardPage.getBundle().getString("CUI_TESTCONNECTION_FAILURE_UI_");
                    message = MessageFormat.format(message, connection.getDatabaseDefinition().getProduct(), e.getMessage());
                    monitor.worked(2);
                    theShell.getDisplay().asyncExec((Runnable)new DisplayMessage(title, message));
                }
                monitor.setTaskName(RDBWizardPage.getBundle().getString("CUI_CREATECONDONE_UI_"));
                monitor.worked(3);
                monitor.done();
            }
        };
        return progMonitor;
    }

    public boolean isFinalConnection() {
        return isFinalConnection;
    }

    public static class DisplayMessage
    implements Runnable {
        protected String title;
        protected String message;

        public DisplayMessage(String title, String message) {
            this.title = title;
            this.message = message;
        }

        public void run() {
            MessageDialog.openInformation((Shell)theShell, (String)this.title, (String)this.message);
        }
    }
}

