/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import org.eclipse.wst.css.core.internal.document.CSSDeclarationItemParser;
import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSPrimitiveValueImpl;
import org.eclipse.wst.css.core.internal.document.CSSStructuredDocumentRegionContainer;
import org.eclipse.wst.css.core.internal.encoding.CSSDocumentLoader;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceGenerator;
import org.eclipse.wst.css.core.internal.formatter.StyleDeclItemFormatter;
import org.eclipse.wst.css.core.internal.parser.CSSSourceParser;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSValue;

class CSSStyleDeclItemImpl
extends CSSStructuredDocumentRegionContainer
implements ICSSStyleDeclItem {
    private String fPropertyName;

    CSSStyleDeclItemImpl(CSSStyleDeclItemImpl that) {
        super(that);
        this.fPropertyName = that.fPropertyName;
    }

    CSSStyleDeclItemImpl(String propertyName) {
        this.fPropertyName = propertyName;
    }

    public ICSSPrimitiveValue appendValue(ICSSPrimitiveValue value) throws DOMException {
        return this.insertValueBefore(value, null);
    }

    public ICSSNode cloneNode(boolean deep) {
        CSSStyleDeclItemImpl cloned = new CSSStyleDeclItemImpl(this);
        if (deep) {
            this.cloneChildNodes(cloned, deep);
        }
        return cloned;
    }

    String generateValueSource() {
        CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter((INodeNotifier)this);
        if (formatter != null && formatter instanceof StyleDeclItemFormatter) {
            return ((StyleDeclItemFormatter)formatter).formatValue(this).toString();
        }
        return "";
    }

    public CSSValue getCSSValue() {
        int nValue = this.getLength();
        if (nValue <= 0) {
            return null;
        }
        if (nValue == 1) {
            return this.item(0);
        }
        return this;
    }

    public String getCSSValueText() {
        if (this.getFirstChild() == null) {
            return "";
        }
        ICSSNode child = this.getFirstChild();
        while (child != null) {
            if (((IndexedRegion)child).getEndOffset() <= 0) {
                return this.generateValueSource();
            }
            child = child.getNextSibling();
        }
        IStructuredDocumentRegion node = this.getFirstStructuredDocumentRegion();
        int start = ((IndexedRegion)this.getFirstChild()).getStartOffset() - node.getStartOffset();
        int end = ((IndexedRegion)this.getLastChild()).getEndOffset() - node.getStartOffset();
        return node.getText().substring(start, end);
    }

    public short getCssValueType() {
        return 2;
    }

    public int getLength() {
        int i = 0;
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            if (node instanceof CSSPrimitiveValueImpl) {
                ++i;
            }
            node = node.getNextSibling();
        }
        return i;
    }

    public short getNodeType() {
        return 9;
    }

    public String getPriority() {
        return this.getAttribute("important");
    }

    public String getPropertyName() {
        return this.fPropertyName.trim().toLowerCase();
    }

    ICSSPrimitiveValue insertValueBefore(ICSSPrimitiveValue newValue, ICSSPrimitiveValue refValue) {
        CSSNodeImpl node = this.insertBefore((CSSNodeImpl)((Object)newValue), (CSSNodeImpl)((Object)refValue));
        return (ICSSPrimitiveValue)((Object)node);
    }

    public CSSValue item(int index) {
        int i = 0;
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            if (node instanceof CSSPrimitiveValueImpl && i++ == index) {
                return (CSSValue)((Object)node);
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public ICSSPrimitiveValue removeValue(ICSSPrimitiveValue value) throws DOMException {
        CSSNodeImpl node = this.removeChild((CSSNodeImpl)((Object)value));
        return (ICSSPrimitiveValue)((Object)node);
    }

    public ICSSPrimitiveValue replaceValue(ICSSPrimitiveValue newValue, ICSSPrimitiveValue oldValue) throws DOMException {
        if (oldValue == null) {
            return newValue;
        }
        if (newValue != null) {
            this.insertValueBefore(newValue, oldValue);
        }
        return this.removeValue(oldValue);
    }

    public void setCssValueText(String value) throws DOMException {
        ICSSNode child = this.getFirstChild();
        while (child != null) {
            ICSSNode next = child.getNextSibling();
            if (child instanceof ICSSPrimitiveValue) {
                this.removeChild((CSSNodeImpl)child);
            }
            child = next;
        }
        CSSDocumentLoader loader = new CSSDocumentLoader();
        IStructuredDocument structuredDocument = (IStructuredDocument)loader.createNewStructuredDocument();
        ((CSSSourceParser)structuredDocument.getParser()).setParserMode(2);
        structuredDocument.set(value);
        IStructuredDocumentRegion node = structuredDocument.getFirstStructuredDocumentRegion();
        if (node == null) {
            return;
        }
        if (node.getNext() != null) {
            throw new DOMException(13, "");
        }
        CSSDeclarationItemParser itemParser = new CSSDeclarationItemParser(this.getOwnerDocument());
        itemParser.setStructuredDocumentTemporary(true);
        itemParser.setupValues(this, node, node.getRegions());
    }

    public void setPriority(String newPriority) throws DOMException {
        this.setAttribute("important", newPriority);
    }
}

