/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.navigator.internal.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.navigator.internal.workingsets.ComponentWorkingSet;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.wst.common.componentcore.internal.ComponentType;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;

public class ComponentWorkingSetUpdater
implements IWorkingSetUpdater,
IResourceChangeListener {
    public static final String ID = "org.eclipse.jst.j2ee.navigator.ui.ComponentWorkingSetPage";
    private List fWorkingSets = new ArrayList();
    private HashMap projectStructureEdits;

    public ComponentWorkingSetUpdater() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IWorkingSet workingSet) {
        List list = this.fWorkingSets;
        synchronized (list) {
            this.updateElements(workingSet);
            this.fWorkingSets.add(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsModuleType(IProject project, String typeId) {
        boolean bReturn;
        block9: {
            bReturn = false;
            try {
                if (!project.isAccessible()) break block9;
                ComponentWorkingSetUpdater componentWorkingSetUpdater = this;
                synchronized (componentWorkingSetUpdater) {
                    StructureEdit moduleCore;
                    block10: {
                        moduleCore = null;
                        moduleCore = this.getStructureEdit(project);
                        if (moduleCore != null) break block10;
                        return false;
                    }
                    WorkbenchComponent[] workBenchModules = moduleCore.getWorkbenchModules();
                    if (workBenchModules != null) {
                        int i = 0;
                        while (i < workBenchModules.length) {
                            WorkbenchComponent module = workBenchModules[i];
                            ComponentType componentType = module.getComponentType();
                            if (componentType != null && typeId.equals(componentType.getComponentTypeId())) {
                                bReturn = true;
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger().logError((Throwable)ex);
            }
        }
        return bReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IWorkingSet workingSet) {
        boolean result;
        List list = this.fWorkingSets;
        synchronized (list) {
            result = this.fWorkingSets.remove(workingSet);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IWorkingSet workingSet) {
        List list = this.fWorkingSets;
        synchronized (list) {
            return this.fWorkingSets.contains(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.clear();
        }
        this.disposeStructureEdits();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(7, 4);
        if (affectedChildren.length > 0) {
            int i = 0;
            while (i < affectedChildren.length) {
                IWorkingSet[] workingSets;
                IResourceDelta projectDelta = affectedChildren[i];
                IProject project = (IProject)projectDelta.getResource();
                List list = this.fWorkingSets;
                synchronized (list) {
                    workingSets = this.fWorkingSets.toArray(new IWorkingSet[this.fWorkingSets.size()]);
                }
                int w = 0;
                while (w < workingSets.length) {
                    WorkingSetDelta workingSetDelta = new WorkingSetDelta(workingSets[w]);
                    this.processResourceDelta(workingSetDelta, projectDelta, project);
                    workingSetDelta.process();
                    ++w;
                }
                ++i;
            }
        }
    }

    private void processResourceDelta(WorkingSetDelta result, IResourceDelta aDelta, IProject aProject) {
        int index = result.indexOf(aProject);
        aDelta.getKind();
        aDelta.getFlags();
        switch (aDelta.getKind()) {
            case 2: {
                if (index != -1) {
                    result.remove(index);
                }
                this.disposeStructureEdits(aProject);
                break;
            }
            case 1: {
                ComponentWorkingSet workingSet = (ComponentWorkingSet)result.getWorkingSet();
                if (!this.containsModuleType(aProject, workingSet.getTypeId()) || index != -1) break;
                result.add(aProject);
                break;
            }
            case 4: {
                boolean projectOpenStateChanged;
                boolean bl = projectOpenStateChanged = (aDelta.getFlags() & 0x4000) != 0;
                if (projectOpenStateChanged) {
                    if (aProject.isOpen()) {
                        ComponentWorkingSet workingSet = (ComponentWorkingSet)result.getWorkingSet();
                        if (!this.containsModuleType(aProject, workingSet.getTypeId())) break;
                        result.add(aProject);
                        break;
                    }
                    if (index != -1) {
                        result.remove(index);
                    }
                    this.disposeStructureEdits(aProject);
                    break;
                }
                ComponentWorkingSet workingSet = (ComponentWorkingSet)result.getWorkingSet();
                if (this.containsModuleType(aProject, workingSet.getTypeId())) {
                    if (index != -1) break;
                    result.add(aProject);
                    break;
                }
                if (index == -1) break;
                result.remove(index);
                break;
            }
        }
    }

    private void updateElements(IWorkingSet workingSet) {
        if (workingSet instanceof ComponentWorkingSet) {
            ComponentWorkingSet componentWorkingSet = (ComponentWorkingSet)workingSet;
            ArrayList<IProject> result = new ArrayList<IProject>();
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                try {
                    if (this.containsModuleType(projects[i], componentWorkingSet.getTypeId())) {
                        result.add(projects[i]);
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger().logError((Throwable)ex);
                }
                ++i;
            }
            componentWorkingSet.setElements(result.toArray(new IAdaptable[result.size()]));
        }
    }

    private void disposeStructureEdits() {
        Set keys = this.getProjectStructureEdits().keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            IProject proj = (IProject)iter.next();
            StructureEdit se = (StructureEdit)this.getProjectStructureEdits().get(proj);
            if (se == null) continue;
            se.dispose();
        }
    }

    private void disposeStructureEdits(IProject aProject) {
        StructureEdit se = (StructureEdit)this.getProjectStructureEdits().get(aProject);
        if (se != null) {
            se.dispose();
        }
        this.getProjectStructureEdits().remove(aProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getProjectStructureEdits() {
        if (this.projectStructureEdits != null) {
            return this.projectStructureEdits;
        }
        ComponentWorkingSetUpdater componentWorkingSetUpdater = this;
        synchronized (componentWorkingSetUpdater) {
            if (this.projectStructureEdits == null) {
                this.projectStructureEdits = new HashMap();
            }
        }
        return this.projectStructureEdits;
    }

    public StructureEdit getStructureEdit(IProject aProject) {
        if (this.getProjectStructureEdits().get(aProject) == null) {
            this.getProjectStructureEdits().put(aProject, StructureEdit.getStructureEditForRead((IProject)aProject));
        }
        return (StructureEdit)this.getProjectStructureEdits().get(aProject);
    }

    private static class WorkingSetDelta {
        private IWorkingSet fWorkingSet;
        private List fElements;
        private boolean fChanged;

        public WorkingSetDelta(IWorkingSet workingSet) {
            this.fWorkingSet = workingSet;
            this.fElements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        }

        public IWorkingSet getWorkingSet() {
            return this.fWorkingSet;
        }

        public int indexOf(Object element) {
            return this.fElements.indexOf(element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Object element) {
            IWorkingSet iWorkingSet = this.fWorkingSet;
            synchronized (iWorkingSet) {
                if (this.indexOf(element) == -1) {
                    this.fElements.add(element);
                    this.fChanged = true;
                }
            }
        }

        public void remove(int index) {
            if (this.fElements.remove(index) != null) {
                this.fChanged = true;
            }
        }

        public void process() {
            if (this.fChanged) {
                this.fWorkingSet.setElements(this.fElements.toArray(new IAdaptable[this.fElements.size()]));
            }
        }
    }
}

