/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class ReconcileStepForMarkup
extends StructuredReconcileStep {
    private String DQUOTE = "\"";
    protected String SEVERITY_ATTR_MISSING_VALUE = "org.eclipse.wst.sse.ui.temp.error";
    protected String SEVERITY_ATTR_NO_VALUE = "org.eclipse.wst.sse.ui.temp.error";
    protected String SEVERITY_GENERIC_ILLFORMED_SYNTAX = "org.eclipse.wst.sse.ui.temp.warning";
    protected String SEVERITY_STRUCTURE = "org.eclipse.wst.sse.ui.temp.error";
    protected String SEVERITY_SYNTAX_ERROR = "org.eclipse.wst.sse.ui.temp.error";
    private String SQUOTE = "'";

    public ReconcileStepForMarkup() {
    }

    public ReconcileStepForMarkup(IReconcileStep step) {
        super(step);
    }

    private void addAttributeError(String message, String attributeValueText, int start, int length, int problemId, IStructuredDocumentRegion sdRegion, List results) {
        if (sdRegion.isDeleted()) {
            return;
        }
        Position p = new Position(start, length);
        ReconcileAnnotationKey key = this.createKey(sdRegion, this.getScope());
        TemporaryAnnotation annotation = new TemporaryAnnotation(p, this.SEVERITY_SYNTAX_ERROR, message, key, problemId);
        annotation.setAdditionalFixInfo((Object)attributeValueText);
        results.add(annotation);
    }

    private void checkAttributesInEndTag(IStructuredDocumentRegion structuredDocumentRegion, List results) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList textRegions = structuredDocumentRegion.getRegions();
        int errorCount = 0;
        int start = structuredDocumentRegion.getEndOffset();
        int end = structuredDocumentRegion.getEndOffset();
        int i = 0;
        while (i < textRegions.size() && errorCount < 25 && !structuredDocumentRegion.isDeleted()) {
            ITextRegion textRegion = textRegions.get(i);
            if (textRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" || textRegion.getType() == "XML_TAG_ATTRIBUTE_EQUALS" || textRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                if (start > structuredDocumentRegion.getStartOffset(textRegion)) {
                    start = structuredDocumentRegion.getStartOffset(textRegion);
                }
                end = structuredDocumentRegion.getEndOffset(textRegion);
                ++errorCount;
            }
            ++i;
        }
        if (errorCount > 0) {
            Position p = new Position(start, end - start);
            String message = XMLUIMessages.End_tag_has_attributes;
            results.add(new TemporaryAnnotation(p, this.SEVERITY_GENERIC_ILLFORMED_SYNTAX, message, this.createKey(structuredDocumentRegion, this.getScope()), 3));
        }
    }

    private void checkClosingBracket(IStructuredDocumentRegion structuredDocumentRegion, List results) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        ITextRegion r = null;
        boolean closed = false;
        int i = 0;
        while (i < regions.size() && !structuredDocumentRegion.isDeleted()) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_CLOSE" || r.getType() == "XML_EMPTY_TAG_CLOSE") {
                closed = true;
            }
            ++i;
        }
        if (!closed) {
            String message = XMLUIMessages.ReconcileStepForMarkup_6;
            int start = structuredDocumentRegion.getStartOffset();
            int length = structuredDocumentRegion.getText().trim().length();
            Position p = new Position(start, length);
            ReconcileAnnotationKey key = this.createKey(structuredDocumentRegion, this.getScope());
            TemporaryAnnotation annotation = new TemporaryAnnotation(p, this.SEVERITY_SYNTAX_ERROR, message, key, 14);
            results.add(annotation);
        }
    }

    private void checkEmptyTag(IStructuredDocumentRegion structuredDocumentRegion, List results) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        if (regions.size() == 2 && regions.get(0).getType() == "XML_TAG_OPEN" && regions.get(1).getType() == "XML_TAG_CLOSE") {
            String message = XMLUIMessages.ReconcileStepForMarkup_3;
            int start = structuredDocumentRegion.getStartOffset();
            int length = structuredDocumentRegion.getLength();
            Position p = new Position(start, length);
            ReconcileAnnotationKey key = this.createKey(structuredDocumentRegion, this.getScope());
            TemporaryAnnotation annotation = new TemporaryAnnotation(p, this.SEVERITY_SYNTAX_ERROR, message, key, 1);
            results.add(annotation);
        }
    }

    private void checkForAttributeValue(IStructuredDocumentRegion structuredDocumentRegion, List results) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        int attrState = 0;
        ITextRegionList textRegions = structuredDocumentRegion.getRegions();
        ReconcileAnnotationKey key = this.createKey(structuredDocumentRegion, this.getScope());
        int errorCount = 0;
        int i = 0;
        while (i < textRegions.size() && errorCount < 25) {
            ITextRegion textRegion = textRegions.get(i);
            if (textRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" || this.isTagCloseTextRegion(textRegion)) {
                TemporaryAnnotation annotation;
                Position p;
                int end;
                int start;
                String message;
                Object[] args;
                if (attrState == 2 && i >= 2) {
                    ITextRegion nameRegion = textRegions.get(i - 2);
                    args = new Object[]{structuredDocumentRegion.getText(nameRegion)};
                    message = NLS.bind((String)XMLUIMessages.Attribute__is_missing_a_value, (Object[])args);
                    start = structuredDocumentRegion.getStartOffset(nameRegion);
                    end = structuredDocumentRegion.getTextEndOffset(nameRegion);
                    p = new Position(start, end - start);
                    annotation = new TemporaryAnnotation(p, this.SEVERITY_ATTR_MISSING_VALUE, message, key, 4);
                    ITextRegion equalsRegion = textRegions.get(i - 2 + 1);
                    int insertOffset = structuredDocumentRegion.getTextEndOffset(equalsRegion) - end;
                    Object[] additionalFixInfo = new Object[]{structuredDocumentRegion.getText(nameRegion), new Integer(insertOffset)};
                    annotation.setAdditionalFixInfo((Object)additionalFixInfo);
                    results.add(annotation);
                    ++errorCount;
                } else if (attrState == 1 && i >= 1) {
                    ITextRegion previousRegion = textRegions.get(i - 1);
                    args = new Object[]{structuredDocumentRegion.getText(previousRegion)};
                    message = NLS.bind((String)XMLUIMessages.Attribute__has_no_value, (Object[])args);
                    start = structuredDocumentRegion.getStartOffset(previousRegion);
                    end = structuredDocumentRegion.getTextEndOffset(previousRegion);
                    p = new Position(start, end - start);
                    annotation = new TemporaryAnnotation(p, this.SEVERITY_ATTR_NO_VALUE, message, key, 5);
                    annotation.setAdditionalFixInfo((Object)structuredDocumentRegion.getText(previousRegion));
                    results.add(annotation);
                    ++errorCount;
                }
                attrState = 1;
            } else if (textRegion.getType() == "XML_TAG_ATTRIBUTE_EQUALS") {
                attrState = 2;
            } else if (textRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                attrState = 0;
            }
            ++i;
        }
    }

    private void checkForSpaceBeforeName(IStructuredDocumentRegion structuredDocumentRegion, List results) {
        IStructuredDocumentRegion prev;
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        String sdRegionText = structuredDocumentRegion.getFullText();
        if (sdRegionText.startsWith(" ") && (prev = structuredDocumentRegion.getPrevious()) != null && prev.getRegions().size() == 1 && this.isStartTag(prev)) {
            String message = XMLUIMessages.ReconcileStepForMarkup_2;
            int start = structuredDocumentRegion.getStartOffset();
            int length = sdRegionText.trim().equals("") ? sdRegionText.length() : sdRegionText.indexOf(sdRegionText.trim());
            Position p = new Position(start, length);
            ReconcileAnnotationKey key = this.createKey(structuredDocumentRegion, this.getScope());
            TemporaryAnnotation annotation = new TemporaryAnnotation(p, this.SEVERITY_SYNTAX_ERROR, message, key, 6);
            results.add(annotation);
        }
    }

    private void checkNoNamespaceInPI(IStructuredDocumentRegion structuredDocumentRegion, List results) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        ITextRegion r = null;
        int errorCount = 0;
        int i = 0;
        while (i < regions.size() && errorCount < 25 && !structuredDocumentRegion.isDeleted()) {
            String piText;
            int index;
            r = regions.get(i);
            if (r.getType() == "XML_TAG_NAME" && (index = (piText = structuredDocumentRegion.getText(r)).indexOf(":")) != -1) {
                String message = XMLUIMessages.ReconcileStepForMarkup_4;
                int start = structuredDocumentRegion.getStartOffset(r) + index;
                int length = piText.trim().length() - index;
                Position p = new Position(start, length);
                ReconcileAnnotationKey key = this.createKey(structuredDocumentRegion, this.getScope());
                TemporaryAnnotation annotation = new TemporaryAnnotation(p, this.SEVERITY_SYNTAX_ERROR, message, key, 8);
                results.add(annotation);
                ++errorCount;
            }
            ++i;
        }
    }

    private void checkQuotesForAttributeValues(IStructuredDocumentRegion structuredDocumentRegion, List results) {
        ITextRegionList regions = structuredDocumentRegion.getRegions();
        ITextRegion r = null;
        String attrValueText = "";
        int errorCount = 0;
        int i = 0;
        while (i < regions.size() && errorCount < 25) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                attrValueText = structuredDocumentRegion.getText(r);
                StringTokenizer st = new StringTokenizer(attrValueText, "\"'", true);
                int size = st.countTokens();
                String one = "";
                String two = "";
                if (size > 0) {
                    one = st.nextToken();
                }
                if (size > 1) {
                    two = st.nextToken();
                }
                if (size <= 2) {
                    String message;
                    if (size == 1) {
                        if (one.equals(this.DQUOTE) || one.equals(this.SQUOTE)) {
                            message = XMLUIMessages.ReconcileStepForMarkup_0;
                            this.addAttributeError(message, attrValueText, structuredDocumentRegion.getStartOffset(r), attrValueText.trim().length(), 0, structuredDocumentRegion, results);
                            ++errorCount;
                        } else {
                            message = XMLUIMessages.ReconcileStepForMarkup_1;
                            this.addAttributeError(message, attrValueText, structuredDocumentRegion.getStartOffset(r), attrValueText.trim().length(), 13, structuredDocumentRegion, results);
                            ++errorCount;
                        }
                    } else if (size == 2 && (one.equals(this.SQUOTE) && !two.equals(this.SQUOTE) || one.equals(this.DQUOTE) && !two.equals(this.DQUOTE))) {
                        message = XMLUIMessages.ReconcileStepForMarkup_0;
                        this.addAttributeError(message, attrValueText, structuredDocumentRegion.getStartOffset(r), attrValueText.trim().length(), 0, structuredDocumentRegion, results);
                        ++errorCount;
                    }
                }
            }
            ++i;
        }
    }

    private void checkStartEndTagPairs(IStructuredDocumentRegion sdRegion, List results) {
        IStructuredDocumentRegion startRegion;
        IStructuredDocumentRegion endRegion;
        if (sdRegion.isDeleted()) {
            return;
        }
        IDOMNode xmlNode = this.getXMLNode(sdRegion);
        if (xmlNode == null) {
            return;
        }
        boolean selfClosed = false;
        String tagName = null;
        int length = 0;
        if (xmlNode.isContainer() && (endRegion = xmlNode.getEndStructuredDocumentRegion()) == null && !(startRegion = xmlNode.getStartStructuredDocumentRegion()).isDeleted()) {
            ITextRegionList regions = startRegion.getRegions();
            ITextRegion r = null;
            int i = 0;
            while (i < regions.size()) {
                r = regions.get(i);
                if (r.getType() == "XML_TAG_OPEN" || r.getType() == "XML_TAG_CLOSE") {
                    ++length;
                } else if (r.getType() == "XML_TAG_NAME") {
                    tagName = sdRegion.getText(r);
                    length += tagName.length();
                } else if (r.getType() == "XML_EMPTY_TAG_CLOSE") {
                    selfClosed = true;
                }
                ++i;
            }
            if (!selfClosed && tagName != null) {
                Object[] args = new Object[]{tagName};
                String message = NLS.bind((String)XMLUIMessages.Missing_end_tag_, (Object[])args);
                int start = sdRegion.getStart();
                Position p = new Position(start, length);
                TemporaryAnnotation annotation = new TemporaryAnnotation(p, this.SEVERITY_STRUCTURE, message, this.createKey(sdRegion, this.getScope()), 2);
                String tagClose = "/>";
                int tagCloseOffset = xmlNode.getFirstStructuredDocumentRegion().getEndOffset();
                if (r != null && r.getType() == "XML_TAG_CLOSE") {
                    tagClose = "/";
                    --tagCloseOffset;
                }
                IDOMNode firstChild = (IDOMNode)xmlNode.getFirstChild();
                while (firstChild != null && firstChild.getNodeType() == 3) {
                    firstChild = (IDOMNode)firstChild.getNextSibling();
                }
                int endOffset = xmlNode.getEndOffset();
                int firstChildStartOffset = firstChild == null ? endOffset : firstChild.getStartOffset();
                Object[] additionalFixInfo = new Object[]{tagName, tagClose, new Integer(tagCloseOffset), new Integer(xmlNode.getFirstStructuredDocumentRegion().getEndOffset()), new Integer(firstChildStartOffset), new Integer(endOffset)};
                annotation.setAdditionalFixInfo((Object)additionalFixInfo);
                results.add(annotation);
            }
        }
    }

    private void checkStartingSpaceForPI(IStructuredDocumentRegion structuredDocumentRegion, List results) {
        if (structuredDocumentRegion.isDeleted()) {
            return;
        }
        IStructuredDocumentRegion prev = structuredDocumentRegion.getPrevious();
        if (prev != null && !prev.isDeleted()) {
            String prevText = prev.getFullText();
            if (prev.getType() == "XML_CONTENT" && prevText.endsWith(" ")) {
                String message = XMLUIMessages.ReconcileStepForMarkup_5;
                int start = prev.getStartOffset();
                int length = prev.getLength();
                Position p = new Position(start, length);
                ReconcileAnnotationKey key = this.createKey(structuredDocumentRegion, this.getScope());
                TemporaryAnnotation annotation = new TemporaryAnnotation(p, this.SEVERITY_SYNTAX_ERROR, message, key, 7);
                results.add(annotation);
            }
        }
    }

    public int getScope() {
        return 1;
    }

    private IStructuredDocumentRegion[] getStructuredDocumentRegions(DirtyRegion dirtyRegion) {
        ArrayList<IStructuredDocumentRegion> regions = new ArrayList<IStructuredDocumentRegion>();
        if (this.getStructuredDocument() == null) {
            return new IStructuredDocumentRegion[0];
        }
        IStructuredDocumentRegion sdRegion = this.getStructuredDocument().getRegionAtCharacterOffset(dirtyRegion.getOffset());
        if (sdRegion != null) {
            if (!sdRegion.isDeleted()) {
                regions.add(sdRegion);
            }
            IDOMNode xmlNode = this.getXMLNode(sdRegion);
            while (sdRegion != null && !sdRegion.isDeleted() && xmlNode != null && sdRegion.getEndOffset() <= xmlNode.getEndOffset()) {
                if (!sdRegion.isDeleted()) {
                    regions.add(sdRegion);
                }
                sdRegion = sdRegion.getNext();
                xmlNode = this.getXMLNode(sdRegion);
            }
        }
        return regions.toArray(new IStructuredDocumentRegion[regions.size()]);
    }

    /*
     * Exception decompiling
     */
    private IDOMNode getXMLNode(IStructuredDocumentRegion sdRegion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 68->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isEndTag(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_END_TAG_OPEN";
    }

    private boolean isPI(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_PI_OPEN";
    }

    private boolean isStartTag(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_TAG_OPEN";
    }

    private boolean isTagCloseTextRegion(ITextRegion textRegion) {
        return textRegion.getType() == "XML_TAG_CLOSE" || textRegion.getType() == "XML_EMPTY_TAG_CLOSE";
    }

    private boolean isXMLContent(IStructuredDocumentRegion structuredDocumentRegion) {
        if (structuredDocumentRegion == null || structuredDocumentRegion.isDeleted()) {
            return false;
        }
        return structuredDocumentRegion.getFirstRegion().getType() == "XML_CONTENT";
    }

    protected IReconcileResult[] reconcile(IStructuredDocumentRegion structuredDocumentRegion) {
        ArrayList results = new ArrayList();
        if (structuredDocumentRegion == null) {
            return this.EMPTY_RECONCILE_RESULT_SET;
        }
        if (this.isStartTag(structuredDocumentRegion)) {
            this.checkForAttributeValue(structuredDocumentRegion, results);
            this.checkStartEndTagPairs(structuredDocumentRegion, results);
            this.checkEmptyTag(structuredDocumentRegion, results);
            this.checkQuotesForAttributeValues(structuredDocumentRegion, results);
            this.checkClosingBracket(structuredDocumentRegion, results);
        } else if (this.isEndTag(structuredDocumentRegion)) {
            this.checkAttributesInEndTag(structuredDocumentRegion, results);
            this.checkClosingBracket(structuredDocumentRegion, results);
        } else if (this.isPI(structuredDocumentRegion)) {
            this.checkStartingSpaceForPI(structuredDocumentRegion, results);
            this.checkNoNamespaceInPI(structuredDocumentRegion, results);
        } else if (this.isXMLContent(structuredDocumentRegion)) {
            this.checkForSpaceBeforeName(structuredDocumentRegion, results);
        }
        return results.toArray(new IReconcileResult[results.size()]);
    }

    protected IReconcileResult[] reconcileModel(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (dirtyRegion == null) {
            return this.EMPTY_RECONCILE_RESULT_SET;
        }
        if (DEBUG) {
            System.out.println("[trace reconciler] > reconcile model in MARKUP step w/ dirty region: [" + dirtyRegion.getOffset() + ":" + dirtyRegion.getLength() + "]" + (dirtyRegion == null ? "null" : dirtyRegion.getText()));
        }
        IReconcileResult[] results = this.EMPTY_RECONCILE_RESULT_SET;
        IStructuredDocumentRegion[] regions = this.getStructuredDocumentRegions(dirtyRegion);
        int i = 0;
        while (i < regions.length) {
            if (!regions[i].isDeleted()) {
                results = this.merge(results, this.reconcile(regions[i]));
            }
            ++i;
        }
        if (DEBUG) {
            System.out.println("[trace reconciler] > MARKUP step done");
        }
        return results;
    }
}

