/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.views.contentoutline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.wst.common.ui.internal.dnd.DragAndDropManager;
import org.eclipse.wst.common.ui.internal.dnd.ObjectTransfer;
import org.eclipse.wst.common.ui.internal.dnd.ViewerDragAdapter;
import org.eclipse.wst.common.ui.internal.dnd.ViewerDropAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.editor.EditorPluginImageHelper;
import org.eclipse.wst.sse.ui.internal.provisional.views.contentoutline.StructuredContentOutlineConfiguration;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeAdapterFactory;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;
import org.eclipse.wst.xml.ui.internal.dnd.XMLDragAndDropManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class XMLContentOutlineConfiguration
extends StructuredContentOutlineConfiguration {
    private IContentProvider fContentProvider = null;
    private ILabelProvider fLabelProvider = null;
    private final String OUTLINE_SHOW_ATTRIBUTE_PREF = "outline-show-attribute-editor";
    protected ActionManagerMenuListener fContextMenuFiller = null;
    private TransferDragSourceListener[] fTransferDragSourceListeners;
    private TransferDropTargetListener[] fTransferDropTargetListeners;

    protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
        PropertyChangeUpdateActionContributionItem showAttributeItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)new ToggleShowAttributeAction(this.getPreferenceStore(), "outline-show-attribute-editor", viewer));
        IContributionItem[] items = super.createMenuContributions(viewer);
        if (items == null) {
            items = new IContributionItem[]{showAttributeItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 1];
            System.arraycopy(items, 0, combinedItems, 0, items.length);
            combinedItems[items.length] = showAttributeItem;
            items = combinedItems;
        }
        return items;
    }

    protected XMLNodeActionManager createNodeActionManager(TreeViewer treeViewer) {
        return new XMLNodeActionManager(this.getEditor().getModel(), (Viewer)treeViewer);
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.fContentProvider == null) {
            this.fContentProvider = this.getFactory() != null ? new JFaceNodeContentProvider((INodeAdapterFactory)this.getFactory()) : super.getContentProvider(viewer);
        }
        return this.fContentProvider;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = this.getFactory() != null ? new JFaceNodeLabelProvider((INodeAdapterFactory)this.getFactory()) : super.getLabelProvider(viewer);
        }
        return this.fLabelProvider;
    }

    public IMenuListener getMenuListener(TreeViewer viewer) {
        if (this.fContextMenuFiller == null) {
            this.fContextMenuFiller = new ActionManagerMenuListener(viewer);
        }
        return this.fContextMenuFiller;
    }

    public List getNodes(List nodes) {
        ArrayList<Node> filteredNodes = new ArrayList<Node>(super.getNodes(nodes));
        int i = 0;
        while (i < filteredNodes.size()) {
            Object selectedNode = filteredNodes.get(i);
            if (selectedNode instanceof Node) {
                Node eachNode = (Node)selectedNode;
                if (eachNode.getNodeType() == 2) {
                    filteredNodes.set(i, ((Attr)eachNode).getOwnerElement());
                } else if (eachNode.getNodeType() == 3) {
                    filteredNodes.set(i, eachNode.getParentNode());
                }
            }
            ++i;
        }
        return filteredNodes;
    }

    public List getSelectedNodes(NodeSelectionChangedEvent event) {
        return this.getNodes(super.getSelectedNodes(event));
    }

    public TransferDragSourceListener[] getTransferDragSourceListeners(TreeViewer treeViewer) {
        if (this.fTransferDragSourceListeners == null) {
            final ViewerDragAdapter dragAdapter = new ViewerDragAdapter((Viewer)treeViewer);
            this.fTransferDragSourceListeners = new TransferDragSourceListener[]{new TransferDragSourceListener(){

                public void dragFinished(DragSourceEvent event) {
                    dragAdapter.dragFinished(event);
                }

                public void dragSetData(DragSourceEvent event) {
                    dragAdapter.dragSetData(event);
                }

                public void dragStart(DragSourceEvent event) {
                    dragAdapter.dragStart(event);
                }

                public Transfer getTransfer() {
                    return ObjectTransfer.getInstance();
                }
            }};
        }
        return this.fTransferDragSourceListeners;
    }

    public TransferDropTargetListener[] getTransferDropTargetListeners(TreeViewer treeViewer) {
        if (this.fTransferDropTargetListeners == null) {
            final ViewerDropAdapter dropAdapter = new ViewerDropAdapter((Viewer)treeViewer, (DragAndDropManager)new XMLDragAndDropManager());
            this.fTransferDropTargetListeners = new TransferDropTargetListener[]{new TransferDropTargetListener(){

                public void dragEnter(DropTargetEvent event) {
                    dropAdapter.dragEnter(event);
                }

                public void dragLeave(DropTargetEvent event) {
                    dropAdapter.dragLeave(event);
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    dropAdapter.dragOperationChanged(event);
                }

                public void dragOver(DropTargetEvent event) {
                    dropAdapter.dragOver(event);
                }

                public void drop(DropTargetEvent event) {
                    dropAdapter.drop(event);
                }

                public void dropAccept(DropTargetEvent event) {
                    dropAdapter.dropAccept(event);
                }

                public Transfer getTransfer() {
                    return ObjectTransfer.getInstance();
                }

                public boolean isEnabled(DropTargetEvent event) {
                    return this.getTransfer().isSupportedType(event.currentDataType);
                }
            }};
        }
        return this.fTransferDropTargetListeners;
    }

    public void unconfigure(TreeViewer viewer) {
        super.unconfigure(viewer);
        this.fTransferDragSourceListeners = null;
        this.fTransferDropTargetListeners = null;
        if (this.fContextMenuFiller != null) {
            this.fContextMenuFiller.release();
            this.fContextMenuFiller = null;
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return XMLUIPlugin.getDefault().getPreferenceStore();
    }

    void updateForShowAttributes(boolean showAttr, TreeViewer viewer) {
        ((JFaceNodeAdapterFactory)this.getFactory()).setShowAttribute(showAttr);
        viewer.refresh();
    }

    private class ActionManagerMenuListener
    implements IMenuListener,
    IReleasable {
        private XMLNodeActionManager fActionManager;
        private TreeViewer fTreeViewer;

        public ActionManagerMenuListener(TreeViewer viewer) {
            this.fTreeViewer = viewer;
            this.fActionManager = XMLContentOutlineConfiguration.this.createNodeActionManager(this.fTreeViewer);
        }

        public void menuAboutToShow(IMenuManager manager) {
            if (this.fActionManager != null) {
                this.fActionManager.fillContextMenu(manager, this.fTreeViewer.getSelection());
            }
        }

        public void release() {
            this.fTreeViewer = null;
            this.fActionManager.setModel(null);
        }
    }

    private class ToggleShowAttributeAction
    extends PropertyChangeUpdateAction {
        private TreeViewer fTreeViewer;

        public ToggleShowAttributeAction(IPreferenceStore store, String preference, TreeViewer treeViewer) {
            super(XMLUIMessages.XMLContentOutlineConfiguration_0, store, preference, false);
            this.setToolTipText(this.getText());
            this.setImageDescriptor(EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/prop_ps.gif"));
            this.fTreeViewer = treeViewer;
            this.update();
        }

        public void update() {
            super.update();
            XMLContentOutlineConfiguration.this.updateForShowAttributes(this.isChecked(), this.fTreeViewer);
        }
    }
}

