/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.WSDLSelectionManager;
import org.eclipse.wst.wsdl.ui.internal.actions.BaseNodeAction;
import org.eclipse.wst.wsdl.ui.internal.actions.DeleteAction;
import org.eclipse.wst.wsdl.ui.internal.actions.DeleteInterfaceAction;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtension;
import org.eclipse.wst.wsdl.ui.internal.extension.WSDLEditorExtensionRegistry;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Node;

public class DeleteWSDLAndXSDAction
extends BaseNodeAction {
    List list;
    Node recordingNode;
    WSDLEditor wsdlEditor;

    public DeleteWSDLAndXSDAction(List deleteList, Node recordingNode, WSDLEditor wsdlEditor) {
        this.setText(WSDLEditorPlugin.getWSDLString("_UI_ACTION_DELETE"));
        this.list = deleteList;
        this.recordingNode = recordingNode;
        this.wsdlEditor = wsdlEditor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Iterator it = this.list.iterator();
        ArrayList wsdlDeleteList = new ArrayList();
        ArrayList xsdDeleteList = new ArrayList();
        while (it.hasNext()) {
            Object object = it.next();
            if (object instanceof WSDLElement || object instanceof XSDSchema) {
                wsdlDeleteList.add(object);
                continue;
            }
            xsdDeleteList.add(object);
        }
        Object newSelection = null;
        WSDLElement topLevelObject = null;
        if (wsdlDeleteList.size() > 0 || xsdDeleteList.size() > 0) {
            try {
                this.beginRecording();
                if (wsdlDeleteList.size() > 0) {
                    Object wsdlObject = wsdlDeleteList.get(0);
                    if (wsdlObject instanceof WSDLElement) {
                        newSelection = ((WSDLElement)wsdlObject).eContainer();
                        topLevelObject = this.getTopLevelWSDLObject((WSDLElement)wsdlObject);
                    }
                    DeleteAction wsdlDelete = new DeleteAction(wsdlDeleteList);
                    wsdlDelete.run();
                }
                if (xsdDeleteList.size() > 0) {
                    Object xsdObject = xsdDeleteList.get(0);
                    if (xsdObject instanceof XSDConcreteComponent) {
                        newSelection = ((XSDConcreteComponent)xsdObject).getContainer();
                        topLevelObject = this.getTopLevelXSDObject((XSDConcreteComponent)xsdObject);
                    }
                    DeleteInterfaceAction xsdDelete = (DeleteInterfaceAction)this.getXSDDelete();
                    xsdDelete.setDeleteList(xsdDeleteList);
                    xsdDelete.run();
                    this.wsdlEditor.getDefinition().setQName(this.wsdlEditor.getDefinition().getQName());
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.endRecording();
                throw throwable;
            }
            this.endRecording();
            WSDLSelectionManager selectionProvider = this.wsdlEditor.getSelectionManager();
            if (selectionProvider != null) {
                if (newSelection instanceof XSDParticle) {
                    newSelection = ((XSDParticle)newSelection).getContainer();
                }
                if (newSelection == null) {
                    newSelection = this.getNewSelection();
                }
                if (newSelection != null) {
                    if (this.list.contains(newSelection) && topLevelObject != null) {
                        newSelection = topLevelObject;
                    }
                    selectionProvider.setSelection((ISelection)new StructuredSelection(newSelection));
                }
            }
        }
    }

    public Node getNode() {
        return this.recordingNode;
    }

    public String getUndoDescription() {
        return WSDLEditorPlugin.getWSDLString("_UI_ACTION_DELETE");
    }

    private Object getXSDDelete() {
        WSDLEditorExtensionRegistry registry = WSDLEditorPlugin.getInstance().getWSDLEditorExtensionRegistry();
        WSDLEditorExtension[] extensions = registry.getRegisteredExtensions(3);
        Object xsdDelete = null;
        int i = 0;
        while (i < extensions.length) {
            xsdDelete = extensions[i].createExtensionObject(12, null);
            if (xsdDelete != null) break;
            ++i;
        }
        return xsdDelete;
    }

    private Object getNewSelection() {
        Object selection;
        try {
            selection = this.wsdlEditor.getGraphViewer().getComponentViewer().getInput();
            if (selection == null) {
                selection = this.wsdlEditor.getDefinition();
            }
        }
        catch (Exception exception) {
            selection = this.wsdlEditor.getDefinition();
        }
        return selection;
    }

    private WSDLElement getTopLevelWSDLObject(WSDLElement element) {
        WSDLElement topObject = (WSDLElement)element.eContainer();
        while (topObject != null && !(topObject instanceof Definition)) {
            topObject = (WSDLElement)topObject.eContainer();
        }
        return topObject;
    }

    private XSDConcreteComponent getTopLevelXSDObject(XSDConcreteComponent component) {
        XSDConcreteComponent topObject = component.getContainer();
        while (topObject != null && !(topObject instanceof XSDSchema)) {
            topObject = (XSDConcreteComponent)topObject.eContainer();
        }
        return topObject;
    }
}

