/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.gef.util.editparts.MultiContentPaneEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.GraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.ExtensibleEditPartFactory;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.IFeedbackHandler;
import org.eclipse.wst.wsdl.ui.internal.graph.model.WSDLGraphModelAdapterFactory;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapter;
import org.eclipse.wst.wsdl.ui.internal.model.ModelAdapterListener;

public abstract class WSDLEditPart
extends MultiContentPaneEditPart
implements ModelAdapterListener,
GraphicsConstants {
    public void activate() {
        super.activate();
        this.addModelAdapterListener(this.getModel(), this);
    }

    public void deactivate() {
        this.removeModelAdapterListener(this.getModel(), this);
        super.deactivate();
    }

    protected void createEditPolicies() {
        SelectionEditPolicy policy = new SelectionEditPolicy(){

            protected void hideSelection() {
                EditPart editPart = this.getHost();
                if (editPart instanceof IFeedbackHandler) {
                    ((IFeedbackHandler)editPart).removeFeedback();
                }
            }

            protected void showSelection() {
                EditPart editPart = this.getHost();
                if (editPart instanceof IFeedbackHandler) {
                    ((IFeedbackHandler)editPart).addFeedback();
                }
            }
        };
        this.installEditPolicy("Selection Feedback", (EditPolicy)policy);
    }

    protected EditPart createChild(Object model) {
        return this.getEditPartFactory().createEditPart((EditPart)this, model);
    }

    public void propertyChanged(Object object, String property) {
        if (property == "CHILDREN_PROPERTY") {
            this.refreshChildren();
        } else if (property == "DETAIL_PROPERTY") {
            this.refreshVisuals();
        } else {
            this.refreshChildren();
            this.refreshVisuals();
        }
    }

    protected List getModelChildren() {
        List result = null;
        ModelAdapter modelAdapter = this.getModelAdapter(this.getModel());
        if (modelAdapter != null) {
            result = (List)modelAdapter.getProperty(this.getModel(), "CHILDREN_PROPERTY");
        }
        return result != null ? result : Collections.EMPTY_LIST;
    }

    protected EditPartFactory getEditPartFactory() {
        return ExtensibleEditPartFactory.getInstance();
    }

    protected ModelAdapter getModelAdapter(Object modelObject) {
        return WSDLGraphModelAdapterFactory.getWSDLGraphModelAdapterFactory().getAdapter(modelObject);
    }

    protected void addModelAdapterListener(Object modelObject, ModelAdapterListener listener) {
        ModelAdapter adapter = this.getModelAdapter(modelObject);
        if (adapter != null) {
            adapter.addListener(listener);
        }
    }

    protected void removeModelAdapterListener(Object modelObject, ModelAdapterListener listener) {
        ModelAdapter adapter = this.getModelAdapter(modelObject);
        if (adapter != null) {
            adapter.removeListener(listener);
        }
    }

    public boolean hitTest(IFigure target, Point location) {
        Rectangle b = target.getBounds().getCopy();
        target.translateToAbsolute((Translatable)b);
        return b.contains(location);
    }
}

