/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLPackage;
import org.eclipse.wst.wsdl.internal.util.WSDLSwitch;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;

public class ReferenceManager {
    protected static InternalAdapterFactory internalAdapterFactory = new InternalAdapterFactory();

    public static void adaptDefinition(Definition definition) {
        internalAdapterFactory.adapt((Notifier)definition);
        Iterator i = definition.getEBindings().iterator();
        while (i.hasNext()) {
            Binding binding = (Binding)i.next();
            internalAdapterFactory.adaptBinding(binding);
        }
    }

    public static void addBindingListener(Operation operation, Listener listener) {
        OperationAdapter adapter = (OperationAdapter)internalAdapterFactory.adapt((Notifier)operation);
        if (adapter != null) {
            adapter.addListener(listener);
        }
    }

    public static void removeBindingListener(Operation operation, Listener listener) {
        OperationAdapter adapter = (OperationAdapter)internalAdapterFactory.adapt((Notifier)operation);
        if (adapter != null) {
            adapter.removeListener(listener);
        }
    }

    protected static void fireNotificationForPortType(PortType portType) {
        if (portType != null) {
            Iterator i = portType.getEOperations().iterator();
            while (i.hasNext()) {
                ReferenceManager.fireNotificationForOperation((Operation)i.next());
            }
        }
    }

    protected static void fireNotificationForOperation(Operation operation) {
        if (operation != null) {
            OperationAdapter adapter = (OperationAdapter)internalAdapterFactory.adapt((Notifier)operation);
            adapter.fireBindingsChanged();
        }
    }

    public static interface Listener {
        public void bindingsChanged(Operation var1);
    }

    public static class InternalAdapterFactory
    extends AdapterFactoryImpl {
        public Adapter createAdapter(Notifier target) {
            WSDLSwitch wsdlSwitch = new WSDLSwitch(this){
                final /* synthetic */ InternalAdapterFactory this$1;
                {
                    this.this$1 = internalAdapterFactory;
                }

                public Object caseBinding(Binding binding) {
                    return this.this$1.createBindingAdapter();
                }

                public Object caseBindingFault(BindingFault bindingFault) {
                    return this.this$1.createBindingFaultAdapter();
                }

                public Object caseBindingOperation(BindingOperation bindingOperation) {
                    return this.this$1.createBindingOperationAdapter();
                }

                public Object caseDefinition(Definition definition) {
                    return this.this$1.createDefinitionAdapter();
                }

                public Object caseOperation(Operation operation) {
                    return this.this$1.createOperationAdapter();
                }
            };
            Object o = wsdlSwitch.doSwitch((EObject)target);
            Adapter result = null;
            if (o instanceof Adapter) {
                result = (Adapter)o;
            } else {
                System.out.println("did not create adapter for target : " + target);
                Thread.dumpStack();
            }
            return result;
        }

        public Adapter createBindingAdapter() {
            return new BindingAdapter();
        }

        public Adapter createBindingFaultAdapter() {
            return new BindingFaultAdapter();
        }

        public Adapter createBindingOperationAdapter() {
            return new BindingOperationAdapter();
        }

        public Adapter createDefinitionAdapter() {
            return new DefinitionAdapter();
        }

        public Adapter createOperationAdapter() {
            return new OperationAdapter();
        }

        public Adapter adapt(Notifier target) {
            return target != null ? this.adapt(target, (Object)internalAdapterFactory) : null;
        }

        protected void adaptBinding(Binding binding) {
            this.adapt((Notifier)binding);
            Iterator i = binding.getEBindingOperations().iterator();
            while (i.hasNext()) {
                BindingOperation bindingOperation = (BindingOperation)i.next();
                this.adapt((Notifier)bindingOperation);
                Iterator j = bindingOperation.getEBindingFaults().iterator();
                while (j.hasNext()) {
                    BindingFault bindingFault = (BindingFault)j.next();
                    this.adapt((Notifier)bindingFault);
                }
            }
        }
    }

    protected static abstract class BaseAdapter
    extends AdapterImpl {
        protected BaseAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == internalAdapterFactory;
        }

        public WSDLPackage getPackage() {
            return WSDLPackage.eINSTANCE;
        }
    }

    protected static class DefinitionAdapter
    extends BaseAdapter {
        protected DefinitionAdapter() {
        }

        public void notifyChanged(Notification msg) {
            Definition cfr_ignored_0 = (Definition)this.getTarget();
            if ((EStructuralFeature)msg.getFeature() == this.getPackage().getDefinition_EBindings()) {
                Object newValue = msg.getNewValue();
                switch (msg.getEventType()) {
                    case 3: {
                        this.handleAdd((Binding)newValue);
                        break;
                    }
                    case 5: {
                        Iterator newValues = ((Collection)newValue).iterator();
                        while (newValues.hasNext()) {
                            this.handleAdd((Binding)newValues.next());
                        }
                        break;
                    }
                }
            }
        }

        protected void handleAdd(Binding binding) {
            internalAdapterFactory.adaptBinding(binding);
            PortType portType = binding.getEPortType();
            if (portType != null) {
                ReferenceManager.fireNotificationForPortType(portType);
            }
        }
    }

    protected static class BindingAdapter
    extends BaseAdapter {
        protected BindingAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if ((EStructuralFeature)msg.getFeature() == this.getPackage().getBinding_EPortType()) {
                ReferenceManager.fireNotificationForPortType((PortType)msg.getNewValue());
                ReferenceManager.fireNotificationForPortType((PortType)msg.getOldValue());
            } else if ((EStructuralFeature)msg.getFeature() == this.getPackage().getBinding_EBindingOperations()) {
                Object newValue = msg.getNewValue();
                Object oldValue = msg.getNewValue();
                switch (msg.getEventType()) {
                    case 3: {
                        this.handleAdd((BindingOperation)newValue);
                        break;
                    }
                    case 5: {
                        Iterator newValues = ((Collection)newValue).iterator();
                        while (newValues.hasNext()) {
                            this.handleAdd((BindingOperation)newValues.next());
                        }
                        break;
                    }
                    case 4: {
                        this.handleRemove((BindingOperation)oldValue);
                        break;
                    }
                    case 6: {
                        Iterator oldValues = ((Collection)oldValue).iterator();
                        while (oldValues.hasNext()) {
                            this.handleRemove((BindingOperation)oldValues.next());
                        }
                        break;
                    }
                }
            }
        }

        protected void handleAdd(BindingOperation bindingOperation) {
            internalAdapterFactory.adapt((Notifier)bindingOperation);
            Operation operation = ComponentReferenceUtil.computeOperation(bindingOperation);
            ReferenceManager.fireNotificationForOperation(operation);
        }

        protected void handleRemove(BindingOperation bindingOperation) {
            if (bindingOperation != null) {
                Operation operation = ComponentReferenceUtil.computeOperation(bindingOperation);
                ReferenceManager.fireNotificationForOperation(operation);
            }
        }
    }

    protected static class BindingOperationAdapter
    extends BaseAdapter {
        protected BindingOperationAdapter() {
        }

        public void notifyChanged(Notification msg) {
            BindingOperation bindingOperation = (BindingOperation)this.getTarget();
            Operation operation = ComponentReferenceUtil.computeOperation(bindingOperation);
            ReferenceManager.fireNotificationForOperation(operation);
        }
    }

    protected static class BindingFaultAdapter
    extends BaseAdapter {
        protected BindingFaultAdapter() {
        }

        public void notifyChanged(Notification msg) {
            BindingFault bindingFault = (BindingFault)this.getTarget();
            BindingOperation bindingOperation = (BindingOperation)bindingFault.eContainer();
            Operation operation = ComponentReferenceUtil.computeOperation(bindingOperation);
            ReferenceManager.fireNotificationForOperation(operation);
        }
    }

    protected static class OperationAdapter
    extends BaseAdapter {
        protected Definition definition;
        protected List listeners = new ArrayList();

        protected OperationAdapter() {
        }

        public void addListener(Listener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(Listener listener) {
            this.listeners.remove(listener);
        }

        public void fireBindingsChanged() {
            Operation operation = (Operation)this.getTarget();
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                Listener listener = (Listener)i.next();
                listener.bindingsChanged(operation);
            }
        }
    }
}

