/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util.flatui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class FlatPageHeader
extends Canvas
implements IPropertyChangeListener {
    private Image backgroundImage;
    private String text;
    private Image buttonImage;
    private Color imageBackgroundColor = new Color(null, 255, 255, 255);
    private Color textForegroundColor = new Color(null, 0, 0, 0);
    private int textHMargin = 10;
    private int textVMargin = 5;
    private Font headerFont;
    private int widthHint;
    private List listeners;
    private int buttonImageX;
    private int buttonImageY;

    public FlatPageHeader(Composite parent, int style) {
        super(parent, style);
        this.setBackground(this.imageBackgroundColor);
        this.headerFont = JFaceResources.getHeaderFont();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FlatPageHeader.this.widgetDisposed(e);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                FlatPageHeader.this.paintControl(e);
            }
        });
        this.listeners = new ArrayList();
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                FlatPageHeader.this.handleMouseDown(event);
            }
        });
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Rectangle bounds;
        this.widthHint = wHint;
        int width = this.getParent().getClientArea().width;
        int height = 0;
        if (this.backgroundImage != null) {
            bounds = this.backgroundImage.getBounds();
            height = bounds.height;
        }
        if (this.text != null) {
            GC gc = new GC((Drawable)this);
            this.getTextWidth(gc);
            int textHeight = this.getTextHeight(gc);
            gc.dispose();
            height = Math.max(height, textHeight);
        }
        if (this.buttonImage != null) {
            bounds = this.buttonImage.getBounds();
            if (height < bounds.height) {
                height = bounds.height;
            }
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width + 2, height + 2);
    }

    protected void paintControl(PaintEvent e) {
        GC gc = e.gc;
        this.getTextHeight(gc);
        if (this.backgroundImage != null) {
            Rectangle imageBounds = this.backgroundImage.getBounds();
            int y = 0;
            int x = 0;
            if (this.imageBackgroundColor != null) {
                gc.setBackground(this.imageBackgroundColor);
                gc.fillRectangle(0, 0, imageBounds.width, imageBounds.height);
            }
            if (!SWT.getPlatform().equals("motif")) {
                gc.drawImage(this.backgroundImage, x, y);
            }
            if (this.textForegroundColor != null) {
                gc.setForeground(this.textForegroundColor);
            }
            gc.setFont(this.headerFont);
            gc.drawText(this.text, this.textHMargin, this.textVMargin, true);
            if (this.buttonImage != null) {
                Rectangle parentBounds = this.getParent().getClientArea();
                Rectangle buttonBounds = this.buttonImage.getBounds();
                int p = parentBounds.x + parentBounds.width;
                this.buttonImageX = p - buttonBounds.width - 4;
                this.buttonImageY = 4;
                gc.drawImage(this.buttonImage, this.buttonImageX, this.buttonImageY);
            }
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    protected void handleMouseDown(MouseEvent event) {
        if (this.buttonImage == null) {
            return;
        }
        int x = event.x;
        int y = event.y;
        if (x < this.buttonImageX || x > this.buttonImageX + this.buttonImage.getBounds().width) {
            return;
        }
        if (y < this.buttonImageY || y > this.buttonImageY + this.buttonImage.getBounds().height) {
            return;
        }
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            SelectionListener listener = (SelectionListener)this.listeners.get(i);
            listener.widgetSelected(null);
            ++i;
        }
    }

    protected void widgetDisposed(DisposeEvent e) {
        if (this.imageBackgroundColor != null) {
            this.imageBackgroundColor.dispose();
        }
        if (this.textForegroundColor != null) {
            this.textForegroundColor.dispose();
        }
        if (this.backgroundImage != null) {
            this.backgroundImage.dispose();
        }
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
        this.redraw();
    }

    public Image getButtonImage() {
        return this.buttonImage;
    }

    public void setButtonImage(Image buttonImage) {
        this.buttonImage = buttonImage;
        this.redraw();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.redraw();
    }

    public int getTextHMargin() {
        return this.textHMargin;
    }

    public void setTextHMargin(int textHMargin) {
        this.textHMargin = textHMargin;
    }

    public int getTextVMargin() {
        return this.textVMargin;
    }

    public void setTextVMargin(int textVMargin) {
        this.textVMargin = textVMargin;
    }

    public Color getImageBackgroundColor() {
        return this.imageBackgroundColor;
    }

    public void setImageBackgroundColor(Color imageBackgroundColor) {
        if (imageBackgroundColor == null) {
            return;
        }
        this.imageBackgroundColor = imageBackgroundColor;
        this.redraw();
    }

    public Color getTextForegroundColor() {
        return this.textForegroundColor;
    }

    public void setTextForegroundColor(Color textForegroundColor) {
        if (textForegroundColor == null) {
            return;
        }
        this.textForegroundColor = textForegroundColor;
        this.redraw();
    }

    private int getTextHeight(GC gc) {
        int imageHeight = 0;
        if (this.backgroundImage != null && !SWT.getPlatform().equals("motif")) {
            imageHeight = this.backgroundImage.getBounds().height;
        }
        gc.setFont(this.headerFont);
        FontMetrics fm = gc.getFontMetrics();
        int fontHeight = fm.getHeight();
        int height = fontHeight + this.textVMargin + this.textVMargin;
        return Math.max(height, imageHeight);
    }

    private int getTextWidth(GC gc) {
        int imageWidth = 0;
        if (this.backgroundImage != null && !SWT.getPlatform().equals("motif")) {
            imageWidth = this.backgroundImage.getBounds().width;
        }
        gc.setFont(this.headerFont);
        FontMetrics fm = gc.getFontMetrics();
        int fontWidth = fm.getAverageCharWidth() + 5;
        int width = fontWidth * this.text.length() + this.textHMargin + this.textHMargin;
        return Math.max(width, imageWidth);
    }

    public void handleEvent(Event e) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "org.eclipse.jface.headerfont" && !this.isDisposed()) {
            this.headerFont = JFaceResources.getFontRegistry().get("org.eclipse.jface.headerfont");
            this.layout(true);
            this.redraw();
        }
    }
}

