/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util.flatui;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.wsdl.ui.internal.util.flatui.HyperlinkAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.flatui.ToggleControl;
import org.eclipse.wst.wsdl.ui.internal.util.flatui.WidgetFactory;

public abstract class FlatPageSection
extends ViewForm
implements IPropertyChangeListener {
    public static final int SELECTION = 1;
    private String headerColorKey = "__default__header__";
    private String headerText;
    private Control client;
    protected Label header;
    protected Control separator;
    private String description;
    private boolean dirty;
    protected Label descriptionLabel;
    private ToggleControl toggle;
    private boolean readOnly;
    private boolean titleAsHyperlink;
    private boolean addSeparator = true;
    private boolean descriptionPainted = true;
    private boolean headerPainted = true;
    private boolean collapsable = false;
    private Composite control;

    public FlatPageSection(Composite parent) {
        super(parent, 0x800000);
        if (SWT.getPlatform().equals("motif")) {
            this.descriptionPainted = false;
        }
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
    }

    public void commitChanges(boolean onSave) {
    }

    public abstract Composite createClient(Composite var1, WidgetFactory var2);

    public final Control createControl(Composite parent, WidgetFactory factory) {
        Composite section = factory.createComposite(parent);
        SectionLayout slayout = new SectionLayout();
        section.setLayout((Layout)slayout);
        section.setData((Object)this);
        if (this.headerPainted) {
            Color headerColor = factory.getColor(this.getHeaderColorKey());
            this.header = factory.createHeadingLabel(section, this.getHeaderText(), headerColor, 64);
            if (this.titleAsHyperlink) {
                factory.turnIntoHyperlink((Control)this.header, new HyperlinkAdapter(){

                    public void linkActivated(Control label) {
                        FlatPageSection.this.titleActivated();
                    }
                });
            }
            if (this.collapsable) {
                this.toggle = new ToggleControl(section, 0);
                this.toggle.setBackground(factory.getBackgroundColor());
                this.toggle.setActiveDecorationColor(factory.getHyperlinkColor());
                this.toggle.setDecorationColor(factory.getColor("__compSep"));
                this.toggle.setActiveCursor(factory.getHyperlinkCursor());
                this.toggle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean collapsed = FlatPageSection.this.toggle.getSelection();
                        FlatPageSection.this.reflow();
                        if (FlatPageSection.this.descriptionLabel != null) {
                            FlatPageSection.this.descriptionLabel.setVisible(!collapsed);
                        }
                        if (FlatPageSection.this.client != null) {
                            FlatPageSection.this.client.setVisible(!collapsed);
                        }
                    }
                });
            }
        }
        if (this.addSeparator) {
            this.separator = factory.createCompositeSeparator(section);
        }
        if (this.descriptionPainted && this.description != null) {
            this.descriptionLabel = factory.createLabel(section, this.description, 64);
        }
        this.client = this.createClient(section, factory);
        section.setData((Object)this);
        this.control = section;
        return section;
    }

    protected void reflow() {
        this.control.layout(true);
        this.control.getParent().layout(true);
        Composite grandParent = this.control.getParent().getParent();
        if (grandParent != null && grandParent instanceof Composite) {
            grandParent.layout(true);
        }
    }

    protected Text createText(Composite parent, String label, WidgetFactory factory) {
        return this.createText(parent, label, factory, 1);
    }

    protected Text createText(Composite parent, String label, WidgetFactory factory, int span) {
        factory.createLabel(parent, label);
        Text text = factory.createText(parent, "");
        GridData gd = new GridData(772);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = span;
        text.setLayoutData((Object)gd);
        return text;
    }

    protected Text createText(Composite parent, WidgetFactory factory, int span) {
        Text text = factory.createText(parent, "");
        GridData gd = new GridData(772);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = span;
        text.setLayoutData((Object)gd);
        return text;
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void doGlobalAction(String actionId) {
    }

    public void expandTo(Object object) {
    }

    public String getDescription() {
        return this.description;
    }

    public String getHeaderColorKey() {
        return this.headerColorKey;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public void initialize(Object input) {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isTitleAsHyperlink() {
        return this.titleAsHyperlink;
    }

    public void sectionChanged(FlatPageSection source, int changeType, Object changeObject) {
    }

    public void setAddSeparator(boolean newAddSeparator) {
        this.addSeparator = newAddSeparator;
    }

    private String trimNewLines(String text) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\n') {
                buff.append(' ');
            } else {
                buff.append(c);
            }
            ++i;
        }
        return buff.toString();
    }

    public void setDescription(String newDescription) {
        this.description = this.trimNewLines(newDescription);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setText(newDescription);
        }
    }

    public void setDescriptionPainted(boolean newDescriptionPainted) {
        this.descriptionPainted = newDescriptionPainted;
    }

    public void setDirty(boolean newDirty) {
        this.dirty = newDirty;
    }

    public void setHeaderColorKey(String newHeaderColorKey) {
        this.headerColorKey = newHeaderColorKey;
    }

    public void setHeaderPainted(boolean newHeaderPainted) {
        this.headerPainted = newHeaderPainted;
    }

    public void setHeaderText(String newHeaderText) {
        this.headerText = newHeaderText;
        if (this.header != null) {
            this.header.setText(this.headerText);
        }
    }

    public void setReadOnly(boolean newReadOnly) {
        this.readOnly = newReadOnly;
    }

    public void setTitleAsHyperlink(boolean newTitleAsHyperlink) {
        this.titleAsHyperlink = newTitleAsHyperlink;
    }

    public void titleActivated() {
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (this.control != null && this.header != null) {
            if (!this.header.isDisposed()) {
                this.header.setFont(JFaceResources.getBannerFont());
            }
            if (!this.control.isDisposed()) {
                this.control.layout(true);
            }
        }
    }

    public boolean getCollapsable() {
        return this.collapsable;
    }

    public void setCollapsable(boolean collapsable) {
        this.collapsable = collapsable;
    }

    class SectionLayout
    extends Layout {
        int vspacing = 3;
        int sepHeight = 2;

        SectionLayout() {
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean flush) {
            int width = 0;
            int height = 0;
            int cwidth = 0;
            int collapsedHeight = 0;
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            cwidth = width;
            if (FlatPageSection.this.client != null) {
                Point csize = FlatPageSection.this.client.computeSize(-1, -1, flush);
                if (width == 0) {
                    cwidth = width = csize.x;
                }
                if (height == 0) {
                    height = csize.y;
                }
            }
            Point toggleSize = null;
            if (FlatPageSection.this.collapsable && FlatPageSection.this.toggle != null) {
                toggleSize = FlatPageSection.this.toggle.computeSize(-1, -1, flush);
            }
            if (hHint == -1 && FlatPageSection.this.headerPainted && FlatPageSection.this.header != null) {
                int hwidth = cwidth;
                if (toggleSize != null) {
                    hwidth = cwidth - toggleSize.x - 5;
                }
                Point hsize = FlatPageSection.this.header.computeSize(hwidth, -1, flush);
                height += hsize.y;
                collapsedHeight = hsize.y;
                height += this.vspacing;
            }
            if (hHint == -1 && FlatPageSection.this.addSeparator) {
                height += this.sepHeight;
                height += this.vspacing;
                collapsedHeight += this.vspacing + this.sepHeight;
            }
            if (hHint == -1 && FlatPageSection.this.descriptionPainted && FlatPageSection.this.descriptionLabel != null) {
                Point dsize = FlatPageSection.this.descriptionLabel.computeSize(cwidth, -1, flush);
                height += dsize.y;
                height += this.vspacing;
            }
            if (FlatPageSection.this.toggle != null && FlatPageSection.this.toggle.getSelection()) {
                height = collapsedHeight;
            }
            return new Point(width, height);
        }

        protected void layout(Composite parent, boolean flush) {
            int width = parent.getClientArea().width;
            int height = parent.getClientArea().height;
            int y = 0;
            Point toggleSize = null;
            if (FlatPageSection.this.collapsable) {
                toggleSize = FlatPageSection.this.toggle.computeSize(-1, -1, flush);
            }
            if (FlatPageSection.this.headerPainted && FlatPageSection.this.header != null) {
                Point hsize;
                if (FlatPageSection.this.titleAsHyperlink) {
                    hsize = FlatPageSection.this.header.computeSize(-1, -1, flush);
                    FlatPageSection.this.header.setBounds(0, y, hsize.x, hsize.y);
                } else {
                    int availableWidth = width;
                    if (toggleSize != null) {
                        availableWidth = width - toggleSize.x - 5;
                    }
                    hsize = FlatPageSection.this.header.computeSize(availableWidth, -1, flush);
                    int hx = 0;
                    if (FlatPageSection.this.toggle != null) {
                        int ty = y + hsize.y - toggleSize.y;
                        FlatPageSection.this.toggle.setBounds(0, ty, toggleSize.x, toggleSize.y);
                        hx = toggleSize.x;
                    }
                    FlatPageSection.this.header.setBounds(hx, y, availableWidth, hsize.y);
                }
                y += hsize.y + this.vspacing;
            }
            if (FlatPageSection.this.addSeparator && FlatPageSection.this.separator != null) {
                FlatPageSection.this.separator.setBounds(0, y, width, 2);
                y += this.sepHeight + this.vspacing;
            }
            if (FlatPageSection.this.toggle != null && FlatPageSection.this.toggle.getSelection()) {
                return;
            }
            if (FlatPageSection.this.descriptionPainted && FlatPageSection.this.descriptionLabel != null) {
                Point dsize = FlatPageSection.this.descriptionLabel.computeSize(width, -1, flush);
                FlatPageSection.this.descriptionLabel.setBounds(0, y, width, dsize.y);
                y += dsize.y + this.vspacing;
            }
            if (FlatPageSection.this.client != null) {
                FlatPageSection.this.client.setBounds(0, y, width, height - y);
            }
        }
    }
}

