/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.filters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterActivationManager;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterDescriptor;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterProvider;
import org.eclipse.wst.common.navigator.internal.views.filters.ThirdPartyFilterProviderRegistry;

public class ExtensionFilterViewerRegistry
extends RegistryReader {
    public static final String NAVIGATOR_FILTER = "commonFilter";
    private final String viewerId;
    private final Map navigatorFilters = new HashMap();
    private final ExtensionFilterActivationManager activationManager;
    private final ThirdPartyFilterProviderRegistry thirdPartyFilterProviderRegistry = new ThirdPartyFilterProviderRegistry();

    public ExtensionFilterViewerRegistry(String viewerId) {
        super(NavigatorPlugin.PLUGIN_ID, NAVIGATOR_FILTER);
        this.viewerId = viewerId;
        this.activationManager = new ExtensionFilterActivationManager(this.viewerId, this);
        this.readRegistry();
        this.initializeActivations();
    }

    private void initializeActivations() {
        String navigatorExtensionId = null;
        Iterator keysItr = this.navigatorFilters.keySet().iterator();
        while (keysItr.hasNext()) {
            navigatorExtensionId = (String)keysItr.next();
            this.getActivationManager().revertFilterActivations(navigatorExtensionId);
        }
    }

    public boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(NAVIGATOR_FILTER)) {
            ExtensionFilterDescriptor descriptor = new ExtensionFilterDescriptor(element);
            this.getExtensionFilterDescriptors(descriptor.getNavigatorExtensionId()).add(descriptor);
            return true;
        }
        return false;
    }

    public final ExtensionFilterDescriptor[] getActiveDescriptors(String navigatorExtensionId) {
        List availableDescriptors = this.getExtensionFilterDescriptors(navigatorExtensionId);
        ArrayList activeDescriptors = new ArrayList();
        int i = 0;
        while (i < availableDescriptors.size()) {
            if (this.getActivationManager().isFilterActive((ExtensionFilterDescriptor)availableDescriptors.get(i))) {
                activeDescriptors.add(availableDescriptors.get(i));
            }
            ++i;
        }
        ExtensionFilterDescriptor[] descriptorsArray = new ExtensionFilterDescriptor[activeDescriptors.size()];
        activeDescriptors.toArray(descriptorsArray);
        return descriptorsArray;
    }

    public final ExtensionFilterDescriptor[] getAllDescriptors(String navigatorExtensionId) {
        List descriptors = this.getExtensionFilterDescriptors(navigatorExtensionId);
        ExtensionFilterDescriptor[] descriptorsArray = new ExtensionFilterDescriptor[descriptors.size()];
        descriptors.toArray(descriptorsArray);
        return descriptorsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List getExtensionFilterDescriptors(String navigatorExtensionId) {
        ArrayList descriptors = (ArrayList)this.getNavigatorFilters().get(navigatorExtensionId);
        if (descriptors != null) {
            return descriptors;
        }
        Map map = this.getNavigatorFilters();
        synchronized (map) {
            descriptors = (List)this.getNavigatorFilters().get(navigatorExtensionId);
            if (descriptors == null) {
                descriptors = new ArrayList();
                this.initializeThirdPartyFilterProviders(navigatorExtensionId, descriptors);
                this.getNavigatorFilters().put(navigatorExtensionId, descriptors);
            }
        }
        return descriptors;
    }

    public void clearCachedNavigatorFilters() {
        this.printFilters();
        this.navigatorFilters.clear();
        this.readRegistry();
        this.printFilters();
    }

    protected String getViewerId() {
        return this.viewerId;
    }

    protected Map getNavigatorFilters() {
        return this.navigatorFilters;
    }

    protected ThirdPartyFilterProviderRegistry getThirdPartyFilterProviderRegistry() {
        return this.thirdPartyFilterProviderRegistry;
    }

    public ExtensionFilterActivationManager getActivationManager() {
        return this.activationManager;
    }

    private void initializeThirdPartyFilterProviders(String navigatorExtensionId, List descriptors) {
        List thirdPartyExtensionFilterProviders = this.getThirdPartyFilterProviderRegistry().getThirdPartyFilterProviders(navigatorExtensionId);
        ExtensionFilterProvider provider = null;
        int i = 0;
        while (i < thirdPartyExtensionFilterProviders.size()) {
            try {
                provider = ((ThirdPartyFilterProviderRegistry.ThirdPartyFilterProviderDescriptor)thirdPartyExtensionFilterProviders.get(i)).createProvider();
                if (provider != null) {
                    descriptors.addAll(provider.getExtensionFilterDescriptors(navigatorExtensionId, this.viewerId));
                }
            }
            catch (RuntimeException e) {
                System.err.println("Problem loading a Third Party Filter Extension. Continuing anyway.");
                e.printStackTrace();
            }
            catch (NoClassDefFoundError ncdfe) {
                System.err.println("Problem loading a Third Party Filter Extension. Continuing anyway.");
                ncdfe.printStackTrace();
            }
            ++i;
        }
    }

    private void printFilters() {
    }
}

