/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.style.java;

import java.util.Collection;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.internal.style.java.JavaCodeScanner;
import org.eclipse.jst.jsp.ui.internal.style.java.JavaColorProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorHelper;
import org.eclipse.wst.sse.ui.internal.provisional.style.AbstractLineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.w3c.dom.Node;

public class LineStyleProviderForJava
extends AbstractLineStyleProvider
implements LineStyleProvider {
    private IDocument fDocument;
    protected RuleBasedScanner fScanner;
    protected TextAttribute fDefaultTextAttribute;
    protected Node targetNode;

    public LineStyleProviderForJava() {
        this.loadColors();
        this.fScanner = new JavaCodeScanner();
        this.fDefaultTextAttribute = new TextAttribute(EditorUtility.getColor((RGB)JavaColorProvider.DEFAULT));
    }

    protected void addRange(Collection presentation, int offset, int length, TextAttribute attr) {
        String styleString = JSPUIPlugin.getDefault().getPreferenceStore().getString("jsp_content");
        String[] prefs = ColorHelper.unpackStylePreferences((String)styleString);
        Color bgColor = prefs != null && prefs.length == 3 && prefs[1].startsWith("#") && Display.getCurrent() != null ? new Color((Device)Display.getCurrent(), ColorHelper.toRGB((String)prefs[1])) : attr.getBackground();
        presentation.add(new StyleRange(offset, length, attr.getForeground(), bgColor, attr.getStyle()));
    }

    protected void clearColors() {
        this.getTextAttributes().clear();
    }

    protected TextAttribute getTokenTextAttribute(IToken token) {
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            return (TextAttribute)data;
        }
        return this.fDefaultTextAttribute;
    }

    protected void loadColors() {
        this.clearColors();
        this.addTextAttribute("SCRIPT_AREA_BORDER");
        this.addTextAttribute("tagAttributeName");
        this.addTextAttribute("tagAttributeValue");
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        String styleKey = null;
        if (event != null) {
            String prefKey = event.getProperty();
            if ("SCRIPT_AREA_BORDER".equals(prefKey)) {
                styleKey = "SCRIPT_AREA_BORDER";
            } else if ("tagAttributeName".equals(prefKey)) {
                styleKey = "tagAttributeName";
            } else if ("tagAttributeValue".equals(prefKey)) {
                styleKey = "tagAttributeValue";
            }
        }
        if (styleKey != null) {
            this.addTextAttribute(styleKey);
            super.handlePropertyChange(event);
        }
    }

    public boolean prepareRegions(ITypedRegion typedRegion, int ssssrequestedStart, int ssssrequestedLength, Collection holdResults) {
        boolean result = true;
        try {
            int offsetAdjustment = typedRegion.getOffset();
            String content = super.getDocument().get(typedRegion.getOffset(), typedRegion.getLength());
            Document document = new Document(content);
            this.setDocument((IDocument)document);
            int lastStart = 0;
            int length = 0;
            IToken lastToken = Token.UNDEFINED;
            int remainingLength = typedRegion.getLength();
            this.fScanner.setRange(this.fDocument, lastStart, remainingLength);
            while (true) {
                IToken token;
                if ((token = this.fScanner.nextToken()).isEOF()) {
                    if (!lastToken.isUndefined() && length != 0) {
                        this.addRange(holdResults, lastStart + offsetAdjustment, length, this.getTokenTextAttribute(lastToken));
                    }
                    break;
                }
                if (token.isWhitespace()) {
                    length += this.fScanner.getTokenLength();
                    continue;
                }
                if (lastToken.isUndefined()) {
                    lastToken = token;
                    length += this.fScanner.getTokenLength();
                    continue;
                }
                if (token != lastToken) {
                    this.addRange(holdResults, lastStart + offsetAdjustment, length, this.getTokenTextAttribute(lastToken));
                    lastToken = token;
                    lastStart = this.fScanner.getTokenOffset();
                    length = this.fScanner.getTokenLength();
                    continue;
                }
                length += this.fScanner.getTokenLength();
            }
        }
        catch (BadLocationException badLocationException) {
            result = false;
        }
        return result;
    }

    protected IPreferenceStore getColorPreferences() {
        return JSPUIPlugin.getDefault().getPreferenceStore();
    }

    protected void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void setTargetNode(Node newTargetNode) {
        this.targetNode = newTargetNode;
    }
}

