/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.core.fragment;

import java.util.Stack;
import org.eclipse.wst.command.internal.env.core.data.DataFlowManager;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.core.fragment.FragmentListener;
import org.eclipse.wst.command.internal.env.core.fragment.SequenceFragment;
import org.eclipse.wst.command.internal.provisional.env.core.Command;
import org.eclipse.wst.command.internal.provisional.env.core.CommandFactory;
import org.eclipse.wst.command.internal.provisional.env.core.CommandManager;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.data.DataMappingRegistry;

public class CommandFragmentEngine
implements CommandManager {
    private Stack commandStack_;
    private FragmentListener undoFragmentListener_;
    private FragmentListener nextFragmentListener_;
    private FragmentListener peekFragmentListener_;
    private DataFlowManager dataManager_;
    private Environment environment_;
    private Status lastStatus_;

    public CommandFragmentEngine(CommandFragment startFragment, DataFlowManager dataManager, Environment environment) {
        SequenceFragment root = new SequenceFragment();
        root.add(startFragment);
        this.commandStack_ = new Stack();
        this.addToStack(root, -1);
        this.addToStack(startFragment, 0);
        this.dataManager_ = dataManager;
        this.environment_ = environment;
    }

    public DataMappingRegistry getMappingRegistry() {
        return this.dataManager_.getMappingRegistry();
    }

    public Status getLastStatus() {
        return this.lastStatus_;
    }

    public boolean isUndoEnabled() {
        return true;
    }

    public void setNextFragmentListener(FragmentListener listener) {
        this.nextFragmentListener_ = listener;
    }

    public void setPeekFragmentListener(FragmentListener listener) {
        this.peekFragmentListener_ = listener;
    }

    public void setUndoFragmentListener(FragmentListener listener) {
        this.undoFragmentListener_ = listener;
    }

    public void peekForwardToNextStop() {
        CommandListEntry topEntry = (CommandListEntry)this.commandStack_.lastElement();
        int parentIndex = topEntry.parentIndex_;
        CommandFragment childFragment = topEntry.fragment_;
        boolean continueLoop = this.navigateChildFragments(childFragment, false);
        while (parentIndex != -1 && continueLoop) {
            CommandListEntry parentEntry = (CommandListEntry)this.commandStack_.elementAt(parentIndex);
            CommandFragment parentFragment = parentEntry.fragment_;
            CommandFragment nextFragment = parentFragment.getNextSubFragment(childFragment);
            if (nextFragment == null) {
                parentIndex = parentEntry.parentIndex_;
                childFragment = parentFragment;
                continue;
            }
            if (this.navigateChildFragments(nextFragment, true)) {
                childFragment = nextFragment;
                continue;
            }
            continueLoop = false;
        }
    }

    public void moveForwardToNextStop() {
        CommandListEntry topEntry = (CommandListEntry)this.commandStack_.lastElement();
        int parentIndex = topEntry.parentIndex_;
        CommandFragment currentFragment = topEntry.fragment_;
        boolean continueExecute = this.visitTop();
        CommandFragment childFragment = currentFragment.getFirstSubFragment();
        while (childFragment != null && continueExecute) {
            parentIndex = this.commandStack_.size() - 1;
            this.addToStack(childFragment, parentIndex);
            continueExecute = this.visitTop();
            currentFragment = childFragment;
            childFragment = currentFragment.getFirstSubFragment();
        }
        while (parentIndex != -1 && continueExecute) {
            CommandListEntry parentEntry = (CommandListEntry)this.commandStack_.elementAt(parentIndex);
            CommandFragment parentFragment = parentEntry.fragment_;
            CommandFragment nextFragment = null;
            nextFragment = currentFragment == null ? parentFragment.getFirstSubFragment() : parentFragment.getNextSubFragment(currentFragment);
            if (nextFragment == null) {
                parentIndex = parentEntry.parentIndex_;
                currentFragment = parentFragment;
                continue;
            }
            this.addToStack(nextFragment, parentIndex);
            parentIndex = this.commandStack_.size() - 1;
            continueExecute = this.visitTop();
            currentFragment = null;
        }
    }

    public boolean undoToLastStop() {
        CommandListEntry topEntry = (CommandListEntry)this.commandStack_.lastElement();
        this.performUndo(topEntry);
        while (topEntry.parentIndex_ != 0) {
            this.commandStack_.pop();
            topEntry = (CommandListEntry)this.commandStack_.lastElement();
            this.performUndo(topEntry);
            if (topEntry.fragmentStopped_) break;
        }
        return topEntry.parentIndex_ == 0;
    }

    private void performUndo(CommandListEntry entry) {
        if (entry.parentIndex_ == 0) {
            return;
        }
        Command cmd = entry.command_;
        if (cmd != null && cmd.isUndoable() && !entry.beforeExecute_) {
            cmd.undo(this.environment_);
            entry.beforeExecute_ = true;
        }
        this.undoFragmentListener_.notify(entry.fragment_);
    }

    private boolean navigateChildFragments(CommandFragment fragment, boolean visitCurrent) {
        boolean continueNavigate = true;
        CommandFragment childFrag = null;
        if (visitCurrent) {
            continueNavigate = this.peekFragmentListener_.notify(fragment);
            this.dataManager_.process(fragment);
        }
        childFrag = fragment.getFirstSubFragment();
        while (childFrag != null && continueNavigate) {
            continueNavigate = this.navigateChildFragments(childFrag, true);
            childFrag = fragment.getNextSubFragment(childFrag);
        }
        return continueNavigate;
    }

    private boolean visitTop() {
        CommandListEntry entry = (CommandListEntry)this.commandStack_.lastElement();
        boolean continueNavigate = this.nextFragmentListener_.notify(entry.fragment_);
        if (continueNavigate) {
            this.dataManager_.process(entry.fragment_);
            entry.fragment_.registerDataMappings(this.dataManager_.getMappingRegistry());
            this.lastStatus_ = this.runCommand(entry);
            if (this.lastStatus_.getSeverity() == 4) {
                continueNavigate = false;
            }
        }
        if (!continueNavigate) {
            entry.fragmentStopped_ = true;
        }
        return continueNavigate;
    }

    private void addToStack(CommandFragment fragment, int parentIndex) {
        CommandListEntry entry = new CommandListEntry(fragment, parentIndex);
        this.commandStack_.push(entry);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status runCommand(CommandListEntry entry) {
        Command cmd;
        CommandFactory factory = entry.fragment_.getCommandFactory();
        Status status = new SimpleStatus("");
        if (factory == null) return status;
        entry.command_ = cmd = factory.create();
        if (cmd == null) return status;
        this.dataManager_.process(cmd);
        try {
            try {
                this.environment_.getLog().log(1, "command", 5001, (Object)this, "runCommand", "Executing: " + cmd.getClass().getName());
                status = cmd.execute(this.environment_);
                entry.beforeExecute_ = false;
            }
            catch (Throwable exc) {
                MessageUtils utils = new MessageUtils("org.eclipse.wst.command.env.core.environment", this);
                SimpleStatus unexpectedError = new SimpleStatus("id", exc.getMessage(), 4, exc);
                status = new SimpleStatus("", utils.getMessage("MSG_ERROR_UNEXPECTED_ERROR"), new Status[]{unexpectedError});
                this.environment_.getStatusHandler().reportError(status);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            String message = "Ok";
            if (status.getSeverity() == 4) {
                message = "Error: " + status.getMessage();
            }
            this.environment_.getLog().log(1, "command", 5001, (Object)this, "runCommand", "Execution status: " + message);
            throw throwable;
        }
        {
            Object var8_10 = null;
            String message = "Ok";
            if (status.getSeverity() == 4) {
                message = "Error: " + status.getMessage();
            }
            this.environment_.getLog().log(1, "command", 5001, (Object)this, "runCommand", "Execution status: " + message);
            return status;
        }
    }

    private class CommandListEntry {
        public Command command_;
        public CommandFragment fragment_;
        public int parentIndex_;
        public boolean fragmentStopped_;
        public boolean beforeExecute_;

        public CommandListEntry(CommandFragment fragment, int parentIndex) {
            this.fragment_ = fragment;
            this.parentIndex_ = parentIndex;
            this.fragmentStopped_ = false;
            this.beforeExecute_ = true;
        }
    }
}

