/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.core;

import org.eclipse.jst.common.internal.annotations.core.AnnotationsCoreResources;
import org.eclipse.jst.common.internal.annotations.core.TagParseEventHandler;
import org.eclipse.jst.common.internal.annotations.core.Token;

public class AnnotationTagParser {
    private TagParseEventHandler handler;
    private char[] input;
    int pos;
    int endOfLastGoodAttParse;

    public AnnotationTagParser(TagParseEventHandler tp) {
        if (tp == null) {
            throw new IllegalArgumentException(AnnotationsCoreResources.getString("AnnotationTagParser.0"));
        }
        this.handler = tp;
    }

    private boolean eos() {
        return this.pos >= this.input.length;
    }

    private boolean isWS(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    private void skipWS() {
        while (this.pos < this.input.length && (this.isWS(this.input[this.pos]) || this.input[this.pos] == '*')) {
            ++this.pos;
        }
    }

    private char peek() {
        return this.input[this.pos];
    }

    private char nextChar() {
        return this.input[this.pos++];
    }

    private boolean isNextChar(char c) {
        if (this.eos()) {
            return false;
        }
        return this.peek() == c;
    }

    private boolean isIDChar(char c) {
        return !this.isWS(c) && c != '=' && c != '@' && c != '\"';
    }

    private Token collectID() {
        StringBuffer b = new StringBuffer(16);
        Token t = new Token();
        t.setBeginning(this.pos);
        while (!this.eos() && this.isIDChar(this.peek())) {
            b.append(this.nextChar());
        }
        t.setEnd(this.pos - 1);
        t.setText(b.toString());
        return t;
    }

    private Token expectAttribName() {
        if (this.eos()) {
            return null;
        }
        int save = this.pos;
        Token retval = this.collectID();
        if (retval.length() == 0) {
            this.pos = save;
            return null;
        }
        return retval;
    }

    private Token expectTag() {
        if (this.eos()) {
            return null;
        }
        int savePos = this.pos;
        if (this.nextChar() != '@') {
            return null;
        }
        if (this.eos() || this.isWS(this.peek())) {
            return null;
        }
        Token retval = this.expectAttribName();
        if (retval.length() == 0) {
            this.pos = savePos + 1;
        }
        retval.setBeginning(savePos);
        this.endOfLastGoodAttParse = this.pos;
        return retval;
    }

    private Token expectQuotedValue() {
        this.skipWS();
        if (this.eos()) {
            return null;
        }
        Token tok = new Token();
        tok.setBeginning(this.pos);
        if (this.peek() != '\"') {
            return null;
        }
        this.nextChar();
        if (this.eos()) {
            return null;
        }
        StringBuffer b = new StringBuffer(64);
        while (!this.eos() && this.peek() != '\"') {
            b.append(this.nextChar());
        }
        if (!this.eos()) {
            this.nextChar();
        }
        tok.setEnd(this.pos - 1);
        tok.setText(b.toString());
        return tok;
    }

    private boolean expectAssign() {
        if (this.eos()) {
            return false;
        }
        if (this.nextChar() == '=') {
            return true;
        }
        --this.pos;
        return false;
    }

    private Token mkNullToken() {
        Token retval = new Token();
        retval.setBeginning(this.pos);
        retval.setEnd(this.pos - 1);
        retval.setText("");
        return retval;
    }

    private boolean parseNextAttribute() {
        this.skipWS();
        if (this.eos()) {
            return false;
        }
        Token key = this.collectID();
        if (key == null || key.length() == 0) {
            return false;
        }
        this.skipWS();
        if (this.eos()) {
            this.handler.attribute(key, -1, this.mkNullToken());
            return false;
        }
        int eqPos = this.pos;
        if (!this.expectAssign()) {
            this.handler.attribute(key, -1, this.mkNullToken());
            return false;
        }
        this.skipWS();
        if (this.eos()) {
            this.handler.attribute(key, eqPos, this.mkNullToken());
            return false;
        }
        Token value = this.expectQuotedValue();
        if (value == null) {
            value = this.collectID();
            if (this.isNextChar('=')) {
                this.pos = value.getBeginning();
                value = this.mkNullToken();
            }
        }
        this.endOfLastGoodAttParse = this.pos;
        this.handler.attribute(key, eqPos, value);
        return true;
    }

    private void parseAttributes() {
        while (!this.eos() && this.parseNextAttribute()) {
        }
    }

    private void skipToTagChar() {
        while (!this.eos() && this.peek() != '@') {
            this.nextChar();
        }
    }

    public void setParserInput(char[] text) {
        this.input = text;
        this.pos = 0;
        this.endOfLastGoodAttParse = 0;
    }

    public void setParserInput(String text) {
        this.setParserInput(text.toCharArray());
    }

    public void parse() {
        while (!this.eos()) {
            this.skipToTagChar();
            Token tag = this.expectTag();
            if (tag == null) break;
            this.handler.annotationTag(tag);
            this.parseAttributes();
            this.handler.endOfTag(this.endOfLastGoodAttParse);
        }
    }
}

