/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import org.eclipse.emf.common.command.Command;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ValidateXmlCommand;
import org.eclipse.jst.j2ee.model.internal.validation.ApplicationClientMessageConstants;
import org.eclipse.jst.j2ee.model.internal.validation.J2EEValidator;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public class ApplicationClientValidator
extends J2EEValidator
implements ApplicationClientMessageConstants {
    protected ApplicationClientFile appClientFile;
    protected ApplicationClient appClientDD;

    public String getBaseName() {
        return "applicationclientvalidation";
    }

    public void validate() throws ValidationException {
        this.validateMainClassInManifest();
    }

    protected void validateMainClassInManifest() {
        String mainClass;
        if (this.appClientFile != null && this.appClientFile.getManifest() != null && ((mainClass = this.appClientFile.getManifest().getMainClass()) == null || mainClass.length() == 0)) {
            Object target = this.getManifestTarget();
            this.addError(this.getBaseName(), "APPCLIENT_MAIN_CLASS_ERROR_", new String[0], target);
        }
    }

    protected Object getManifestTarget() {
        return null;
    }

    public void validate(IValidationContext inHelper, IReporter inReporter) throws ValidationException {
        super.validate(inHelper, inReporter);
        try {
            this.setAppClientFile((ApplicationClientFile)inHelper.loadModel("APPLICATIONCLIENT_VALIDATION"));
            if (this.appClientFile == null) {
                Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_APPLICATIONCLIENT_INVALID_APPCLIENT_FILE");
                throw new ValidationException((IMessage)errorMsg);
            }
            this.setAppClientDD(this.appClientFile.getDeploymentDescriptor());
            this.validate();
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception e) {
            Message errorMsg = new Message(this.getBaseName(), 1, "ERROR_APPCLIENT_VALIDATION_FAILED");
            throw new ValidationException((IMessage)errorMsg, (Throwable)e);
        }
    }

    public Command createValidateXMLCommand() {
        ValidateXmlCommand cmd = new ValidateXmlCommand((ModuleFile)this.appClientFile);
        return cmd;
    }

    public ApplicationClientFile getAppClientFile() {
        return this.appClientFile;
    }

    public void setAppClientFile(ApplicationClientFile appClientFile) {
        this.appClientFile = appClientFile;
    }

    public ApplicationClient getAppClientDD() {
        return this.appClientDD;
    }

    public void setAppClientDD(ApplicationClient appClientDD) {
        this.appClientDD = appClientDD;
    }
}

