/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;


/**
 * @author ljulien
 */
public class WorkOffline extends AbstractAction
{
    private static final String TITLE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.OFFLINE.TITLE");
    private static final String MESSAGE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.OFFLINE.MESSAGE");    
    private static final String JOB_NAME = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.WORKOFFLINE");
    
    private static final ISchedulingRule MUTEX = new ISchedulingRule()
    {
        public boolean isConflicting(ISchedulingRule rule)
        {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule)
        {
            return rule == this;
        }
    };
    
    private ISelection selection;

    protected void setSelection(ISelection selection)
    {
        this.selection = selection;
    }

    protected ISelection getSelection()
    {
        return this.selection;
    }

    public void run(IAction action)
    {
        IConnectionNode connection = (IConnectionNode) ((IStructuredSelection) selection).getFirstElement();
        ConnectionInfo info = connection.getConnectionInfo();
		Job j = new ConnectionJob(connection, info);
   		j.setUser(true);
   		j.schedule();
    }
    
    private class ConnectionJob extends Job
    {
        private ConnectionInfo info;
        private IConnectionNode connection;

        public ConnectionJob(IConnectionNode connection, ConnectionInfo info)
        {
            super(WorkOffline.JOB_NAME);
            this.info = info;
            this.connection = connection;
            setRule(MUTEX);
        }

        public boolean belongsTo(Object family)
        {
            if (family == WorkOffline.JOB_NAME)
            {
                return true;
            }
            return false;
        }

        public IStatus run(IProgressMonitor monitor)
        {
            try
            {
                monitor.beginTask(this.getName(), 100);
                try
                {
                    monitor.worked(40);
                    final Database database = info.getCachedDatabase();
                    monitor.worked(80);
                    Display.getDefault().syncExec(new Runnable ()
                    {
                        public void run()
                        {
                            if (database != null)
                            {
                                connection.setConnected(true);
                                info.setSharedDatabase(database);
                            }
                            else
                            {
                                MessageDialog.openError(Display.getDefault().getActiveShell(), TITLE, MESSAGE);
                            }
                        }
                
                    });
                    if (monitor.isCanceled())
                    {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.worked(100);
                }
                finally
                {
                    monitor.done();
                }
            }
            catch (Exception e)
            {
            }
            return Status.OK_STATUS;
        }
    }
}
