/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Feb 5, 2004
 *  
 */
package org.eclipse.jst.common.navigator.internal.actions;

import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider;

/**
 * @author mdelder
 *  
 */
public class JavaEditActionsGroup extends CommonActionProvider implements ICommonActionProvider {


	private ActionGroup[] actionGroups;



	/* (non-Javadoc)
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#init(org.eclipse.ui.IViewPart, org.eclipse.jface.viewers.StructuredViewer, org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentService)
	 */
	public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
		actionGroups = new ActionGroup[]{new GenerateActionGroup(aViewPart), new JavaSearchActionGroup(aViewPart)};
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#setActionContext(org.eclipse.ui.actions.ActionContext)
	 */
	public void setActionContext(ActionContext aContext) {
		if (actionGroups == null || actionGroups.length == 0)
			return;

		for (int i = 0; i < actionGroups.length; i++)
			actionGroups[i].setContext(aContext);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#fillActionBars(org.eclipse.ui.IActionBars)
	 */
	public boolean fillActionBars(IActionBars theActionBars) {

		if (actionGroups == null || actionGroups.length == 0)
			return false;
		for (int i = 0; i < actionGroups.length; i++)
			actionGroups[i].fillActionBars(theActionBars);
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public boolean fillContextMenu(IMenuManager aMenu) {

		if (actionGroups == null || actionGroups.length == 0)
			return false;
		for (int i = 0; i < actionGroups.length; i++)
			actionGroups[i].fillContextMenu(aMenu);
		return true;
	}

	public void dispose() {
		super.dispose();

		if (actionGroups == null || actionGroups.length == 0)
			return;
		for (int i = 0; i < actionGroups.length; i++)
			actionGroups[i].dispose();
	}

}