/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.NewExampleAction;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.eclipse.wst.common.navigator.internal.actions.CommonWizardRegistry;
import org.eclipse.wst.common.navigator.internal.actions.WizardActionGroup;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonActionProvider;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonMenuConstants;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.actions.CommonActionProvider;


/**
 * This class implements a navigatorActions extension for adding the New menu to the Navigator
 * context menu. Since the <code>NewWizardMenu</code> cannot be added via XML (the specification
 * does not provide for adding predefined menus), so a class is defined for the navigatorActions
 * extension point.
 * <p>
 * This class is experimental and is subject to change.
 * </p>
 */
public class OpenActionsExtension extends CommonActionProvider implements ICommonActionProvider {

	/**
	 * The id for the Open With submenu.
	 */
	public static final String OPEN_WITH_ID = WorkbenchNavigatorPlugin.PLUGIN_ID + ".OpenWithSubMenu"; //$NON-NLS-1$
	public static final String COMMON_NAVIGATOR_NEW_MENU = "common.new.menu"; //$NON-NLS-1$
	private static final String FULL_EXAMPLES_WIZARD_CATEGORY = "org.eclipse.ui.Examples";//$NON-NLS-1$ WizardsRegistryReader.FULL_EXAMPLES_WIZARD_CATEGORY;
	private static final CommonWizardRegistry COMMON_WIZARD_REGISTRY = CommonWizardRegistry.getInstance();
	
	private NavigateActionGroup openActionGroup;

	private IAction showDlgAction;
	private IAction newProjectAction;
	private IAction newExampleAction;
	private ActionContext actionContext;


	private WizardActionGroup newWizardActionGroup;


	/* (non-Javadoc)
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#init(org.eclipse.ui.IViewPart, org.eclipse.jface.viewers.StructuredViewer, org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentService)
	 */
	public void init(IViewPart aViewPart, StructuredViewer aViewer, NavigatorContentService aContentService) {
		openActionGroup = new NavigateActionGroup(aViewPart);

		IWorkbenchWindow window = aViewPart.getViewSite().getWorkbenchWindow();
		showDlgAction = ActionFactory.NEW.create(window);
		newProjectAction = new NewProjectAction(window);
		newExampleAction = new NewExampleAction(window);

		newWizardActionGroup = new WizardActionGroup(window, WizardActionGroup.NEW_WIZARD);

	}

	/**
	 * Dispose of the resources held by this class.
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorActionsExtension#dispose()
	 */
	public void dispose() {
		openActionGroup.dispose();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.actions.ICommonActionProvider#setActionContext(org.eclipse.ui.actions.ActionContext)
	 */
	public void setActionContext(ActionContext aContext) {
		actionContext = aContext;
		openActionGroup.setContext(aContext);
	}

	/**
	 * Fill the Navigator context menu.
	 * 
	 * @param menuManager
	 *            the Navigator context menu
	 * @param selection
	 *            the current Navigator selection
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorActionsExtension#fillContextMenu(org.eclipse.jface.action.IMenuManager,
	 *      org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public boolean fillContextMenu(IMenuManager aMenu) {
		openActionGroup.fillContextMenu(aMenu);
		addNewMenu(aMenu);
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorActionsExtension#fillActionBars(org.eclipse.ui.IActionBars,
	 *      org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public boolean fillActionBars(IActionBars theActionBars) {
		openActionGroup.fillActionBars(theActionBars);
		return true;
	}

	/**
	 * @param menuManager
	 * @param selection
	 */
	private void addNewMenu(IMenuManager menuManager) {
		CompressedMenu submenu = new CompressedMenu(IDEWorkbenchMessages.Workbench_new, COMMON_NAVIGATOR_NEW_MENU); //$NON-NLS-1$

		// Add new project ..
		submenu.add(newProjectAction);
		submenu.add(new Separator());

		//		 fill the menu from the commonWizard contribution
		fillNewMenu(submenu);
		submenu.add(new Separator(ICommonMenuConstants.GROUP_ADDITIONS));

		if (hasExamples()) {
			// Add examples ..
			submenu.add(new Separator());
			submenu.add(newExampleAction);
		}

		// Add other ..
		submenu.add(new Separator());
		submenu.add(showDlgAction);

		menuManager.insertAfter(ICommonMenuConstants.GROUP_NEW, submenu);
	}

	/**
	 * Return whether or not any examples are in the current install.
	 * 
	 * @return boolean
	 */
	private boolean hasExamples() {
		IWizardRegistry newRegistry = WorkbenchPlugin.getDefault().getNewWizardRegistry();
		IWizardCategory category = newRegistry.findCategory(FULL_EXAMPLES_WIZARD_CATEGORY);
		//return category.getWizards().length > 0;
		return category != null;
 
	}

	/**
	 * @param submenu
	 */
	private void fillNewMenu(IMenuManager aSubmenu) {
		if (actionContext != null && !actionContext.getSelection().isEmpty() && actionContext.getSelection() instanceof IStructuredSelection) {

			IStructuredSelection structuredSelection = (IStructuredSelection) actionContext.getSelection();
			if (structuredSelection.size() == 1)
				/* structuredSelection.size() = 1 */
				addCommomWizardNewMenus(aSubmenu, structuredSelection.getFirstElement());
		}
	}

	private void addCommomWizardNewMenus(IMenuManager aSubmenu, Object anElement) {
		String[] wizardDescriptorIds = COMMON_WIZARD_REGISTRY.getEnabledCommonWizardDescriptorIds(anElement, CommonWizardRegistry.WIZARD_TYPE_NEW);
		if (wizardDescriptorIds.length == 0)
			return;

		newWizardActionGroup.setWizardActionIds(wizardDescriptorIds);
		newWizardActionGroup.setContext(actionContext);
		newWizardActionGroup.fillContextMenu(aSubmenu);

	}

}