/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.common.navigator.internal.java;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider;

/**
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class JavaExtensionLabelProvider extends PackageExplorerLabelProvider implements ICommonLabelProvider {

	private final long LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | JavaElementLabels.ROOT_POST_QUALIFIED | JavaElementLabels.APPEND_ROOT_PATH | JavaElementLabels.M_PARAMETER_TYPES | JavaElementLabels.M_PARAMETER_NAMES | JavaElementLabels.M_APP_RETURNTYPE | JavaElementLabels.M_EXCEPTIONS | JavaElementLabels.F_APP_TYPE_SIGNATURE;

	/**
	 * @param flags
	 */
	public JavaExtensionLabelProvider() {
		super(AppearanceAwareLabelProvider.DEFAULT_TEXTFLAGS | JavaElementLabels.P_COMPRESSED, AppearanceAwareLabelProvider.DEFAULT_IMAGEFLAGS | JavaElementImageProvider.SMALL_ICONS);
		setIsFlatLayout(true);
	}

	/**
	 * <p>
	 * No-op.
	 * </p>
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider#initialize(java.lang.String)
	 */
	public void initialize(String aViewerId) {
		//do nothing
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.extensions.ICommonLabelProvider#getDescription(java.lang.Object)
	 */
	public String getDescription(Object anElement) {

		if (anElement instanceof IJavaElement)
			return JavaElementLabels.getElementLabel((IJavaElement) anElement, LABEL_FLAGS);
		else if (anElement instanceof IResource) {
			return ((IResource) anElement).getFullPath().makeRelative().toString();
		}
		return null;
	}
}