/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.connection.internal.ui.filter;

import java.util.Iterator;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilterImpl;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

/**
 * @author ledunnel
 */
public class SchemaFilterWizardPage extends RDBFilterWizardPage {

    private ConnectionInfo connectionInfo;

    /**
     * @param pageName
     */
    public SchemaFilterWizardPage(String pageName) {
        super(pageName);
    }

    protected ConnectionFilter getConnectionFilter() {
        ConnectionFilter connFilter = null;
        if (connectionInfo != null) {
            connFilter = connectionInfo
                    .getFilter(ConnectionFilter.SCHEMA_FILTER);
        }
        return connFilter;
    }

    protected void populateSelectionTable() {
        selectionTable.removeAll();
        if (connectionInfo != null) {
            Iterator schemas = connectionInfo.getSharedDatabase().getSchemas()
                    .iterator();
            while (schemas.hasNext()) {
                TableItem tableItem = new TableItem(selectionTable, SWT.NONE);
                tableItem.setText(((SQLObject) schemas.next()).getName());
            }
            isSelectionListPopulated = true;
        }
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        initializeValues();
    }

    public void applyFilter() {
        if (connectionInfo != null) {
            if (!this.isFilterSpecified()) {
                connectionInfo.removeFilter(ConnectionFilter.SCHEMA_FILTER);
            } else {
                ConnectionFilter connFilter = new ConnectionFilterImpl();
                connFilter.setPredicate(this.getPredicate());
                connectionInfo.addFilter(ConnectionFilter.SCHEMA_FILTER,
                        connFilter);
            }
        }
    }
}