/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.connection.internal.ui.util.help;

/**
 * Context help id constants.
 */

public class RSCCommonUIContextIds {
  public static final String PLUGIN_NAME = "com.ibm.etools.rsc"; //$NON-NLS-1$

  /* CONTEXT_IDs for RSC UI*/

  /* Data Perspective view */
  public static final String RSC_DATA_PERSPECTIVE = PLUGIN_NAME + ".view0001"; //$NON-NLS-1$

  /* DB Explorer view */
  public static final String RSC_DB_EXPLORER = PLUGIN_NAME + ".view0002"; //$NON-NLS-1$

  /* Data View */
  public static final String RSC_DATA_VIEW = PLUGIN_NAME + ".view0003"; //$NON-NLS-1$

  /** New connection wizard. */
  public static final String RSC_NEWCW = PLUGIN_NAME + ".newcw"; //$NON-NLS-1$

  /** New connection wizard: existing connection radio. */
  public static final String RSC_NEWCW_EXISTINGCONRADIO = PLUGIN_NAME + ".newcwExistingConRadio"; //$NON-NLS-1$
  /** New connection wizard: existing connection combo. */
  public static final String RSC_NEWCW_EXISTINGCONCOMBO = PLUGIN_NAME + ".newcwExistingConCombo"; //$NON-NLS-1$
  /** New connection wizard: new connection radio. */
  public static final String RSC_NEWCW_NEWCONRADIO = PLUGIN_NAME + ".newcwNewConRadio"; //$NON-NLS-1$
  /** New connection wizard: new connection text. */
  public static final String RSC_NEWCW_NEWCONTEXT = PLUGIN_NAME + ".newcwNewConText"; //$NON-NLS-1$
  /** New connection wizard: alias connection type. */
  public static final String RSC_NEWCW_ALIASTYPERADIO = PLUGIN_NAME + ".newcwAliasTypeRadio"; //$NON-NLS-1$
  /** New connection wizard: JDBC connection type. */
  public static final String RSC_NEWCW_JDBCTYPERADIO = PLUGIN_NAME + ".newcwJDBCTypeRadio"; //$NON-NLS-1$
  /** New connection wizard: JNDI connection type. */
  public static final String RSC_NEWCW_JNDITYPERADIO = PLUGIN_NAME + ".newcwJNDITypeRadio"; //$NON-NLS-1$

  /** New connection wizard: JDBC driver combo. */
  public static final String RSC_NEWCW_DRIVERCOMBO = PLUGIN_NAME + ".newcwDriverCombo"; //$NON-NLS-1$
  /** New connection wizard: Test Connection button. */
  public static final String RSC_NEWCW_TESTCONNECTION = PLUGIN_NAME + ".newcwTestConnection"; //$NON-NLS-1$
  /** New connection wizard: DBMS tree. */
  public static final String RSC_NEWCW_DBMSTREE = PLUGIN_NAME + ".newcwDBMSTree"; //$NON-NLS-1$

  /** New connection wizard: driver class. */
  public static final String RSC_NEWCW_DRIVERCLASS = PLUGIN_NAME + ".newcwDriverClass"; //$NON-NLS-1$
  /** New connection wizard: driver class location. */
  public static final String RSC_NEWCW_DRIVERLOCATION = PLUGIN_NAME + ".newcwLocationCombo"; //$NON-NLS-1$
  /** New connection wizard: Browse button for driver class location. */
  public static final String RSC_NEWCW_BROWSELOCATION = PLUGIN_NAME + ".newcwBrowseLocation"; //$NON-NLS-1$
  /** New connection wizard: database location. */
  public static final String RSC_NEWCW_DBLOCATION = PLUGIN_NAME + ".newcwDBLocationCombo"; //$NON-NLS-1$
  /** New connection wizard: Browse button for database location. */
  public static final String RSC_NEWCW_BROWSEDBLOCATION = PLUGIN_NAME + ".newcwBrowseDBLocation"; //$NON-NLS-1$
  /** New connection wizard: Browse button for database location. */
  public static final String RSC_NEWCW_CREATEDBCHECK = PLUGIN_NAME + ".newcwCreateDBifRequired"; //$NON-NLS-1$
  /** New connection wizard: URL. */
  public static final String RSC_NEWCW_URL = PLUGIN_NAME + ".newcwURL"; //$NON-NLS-1$

  /** New connection wizard: DB2 alias. */
  public static final String RSC_NEWCW_ALIASCOMBO = PLUGIN_NAME + ".newcwAliasCombo"; //$NON-NLS-1$
  /** New connection wizard: comments for alias. */
  public static final String RSC_NEWCW_CMTSAREA = PLUGIN_NAME + ".newcwCmtsArea"; //$NON-NLS-1$
  /** New connection wizard: add button to manage aliases. */
  public static final String RSC_NEWCW_ADDBUTTON = PLUGIN_NAME + ".newcwAddButton"; //$NON-NLS-1$

  /** New connection wizard: Initial context factory. */
  public static final String RSC_NEWCW_FACTORYCOMBO = PLUGIN_NAME + ".newcwFactoryCombo"; //$NON-NLS-1$
  /** New connection wizard: Provider URL. */
  public static final String RSC_NEWCW_PROVIDERTEXT = PLUGIN_NAME + ".newcwProviderText"; //$NON-NLS-1$
  /** New connection wizard: JNDI data source name. */
  public static final String RSC_NEWCW_JNDICOMBO = PLUGIN_NAME + ".newcwJNDICombo"; //$NON-NLS-1$
  /** New connection wizard: JNDI browse button. */
  public static final String RSC_NEWCW_JNDIBROWSE = PLUGIN_NAME + ".newcwJNDIBrowse"; //$NON-NLS-1$
  /** New connection wizard: Database name. */
  public static final String RSC_NEWCW_DATABASENAME = PLUGIN_NAME + ".newcwDatabasename"; //$NON-NLS-1$
  /** New connection wizard: Oracle SID. */
  public static final String RSC_NEWCW_SID = PLUGIN_NAME + ".newcwSID"; //$NON-NLS-1$
  /** New connection wizard: TCP/IP host name. */
  public static final String RSC_NEWCW_HOST = PLUGIN_NAME + ".newcwHost"; //$NON-NLS-1$
  /** New connection wizard: TCP/IP port. */
  public static final String RSC_NEWCW_PORT = PLUGIN_NAME + ".newcwPort"; //$NON-NLS-1$

  /** New connection wizard: current OS user ID and password. */
  public static final String RSC_NEWCW_CURRENTCHECK = PLUGIN_NAME + ".newcwCurrentCheck"; //$NON-NLS-1$
  /** New connection wizard: user ID. */
  public static final String RSC_NEWCW_USERIDCOMBO = PLUGIN_NAME + ".newcwUserIdCombo"; //$NON-NLS-1$
  /** New connection wizard: password. */
  public static final String RSC_NEWCW_PASSWORDTEXT = PLUGIN_NAME + ".newcwPasswordText"; //$NON-NLS-1$

  /** New connection wizard Add Alias dialog. */
  public static final String RSC_NEWCW_ADD_DIALOG = PLUGIN_NAME + ".newcwAddDialog"; //$NON-NLS-1$
  /** New connection wizard Add Alias dialog: host combo. */
  public static final String RSC_NEWCW_ADD_DRIVERCOMBO = PLUGIN_NAME + ".newcwAddHostCombo"; //$NON-NLS-1$
  /** New connection wizard Add Alias dialog: search button. */
  public static final String RSC_NEWCW_ADD_TESTCONNECTION = PLUGIN_NAME + ".newcwAddSearchButton"; //$NON-NLS-1$
  /** New connection wizard Add Alias dialog: existing alias table. */
  public static final String RSC_NEWCW_ADD_EXISTINGTABLE = PLUGIN_NAME + ".newcwAddExistingTable"; //$NON-NLS-1$
  /** New connection wizard Add Alias dialog: new alias name. */
  public static final String RSC_NEWCW_ADD_ALIASTEXT = PLUGIN_NAME + ".newcwAddAliasText"; //$NON-NLS-1$
  /** New connection wizard Add Alias dialog: new alias comments. */
  public static final String RSC_NEWCW_ADD_CMTSAREA = PLUGIN_NAME + ".newcwAddCmtsArea"; //$NON-NLS-1$

  /** New connection wizard filter page: Meet all conditions. */
  public static final String RSC_NEWCW_FILTER_SCHEMA_AND_RADIO = PLUGIN_NAME + ".newcwSchemaAndRadio"; //$NON-NLS-1$
  /** New connection wizard filter page: Meet any conditions. */
  public static final String RSC_NEWCW_FILTER_SCHEMA_OR_RADIO = PLUGIN_NAME + ".newcwSchemaOrRadio"; //$NON-NLS-1$
  /** New connection wizard filter page: Meet all conditions. */
  public static final String RSC_NEWCW_FILTER_OBJECT_AND_RADIO = PLUGIN_NAME + ".newcwObjectAndRadio"; //$NON-NLS-1$
  /** New connection wizard filter page: Meet any conditions. */
  public static final String RSC_NEWCW_FILTER_OBJECT_OR_RADIO = PLUGIN_NAME + ".newcwObjectOrRadio"; //$NON-NLS-1$
  /** New connection wizard filter page: schema filters. */
  public static final String RSC_NEWCW_FILTER_SCHEMA_TABLE = PLUGIN_NAME + ".newcwSchemaTable"; //$NON-NLS-1$
  /** New connection wizard filter page: table filters. */
  public static final String RSC_NEWCW_FILTER_TABLE_TABLE = PLUGIN_NAME + ".newcwTableTable"; //$NON-NLS-1$
  /** New connection wizard filter page: routine filters. */
  public static final String RSC_NEWCW_FILTER_ROUTINE_TABLE = PLUGIN_NAME + ".newcwRoutineTable"; //$NON-NLS-1$
  /** New connection wizard filter page: add new schema filter. */
  public static final String RSC_NEWCW_FILTER_SCHEMA_ADD = PLUGIN_NAME + ".newcwSchemaAddButton"; //$NON-NLS-1$
  /** New connection wizard filter page: edit schema filter. */
  public static final String RSC_NEWCW_FILTER_SCHEMA_EDIT = PLUGIN_NAME + ".newcwSchemaEditButton"; //$NON-NLS-1$
  /** New connection wizard filter page: remove schema filter. */
  public static final String RSC_NEWCW_FILTER_SCHEMA_REMOVE = PLUGIN_NAME + ".newcwSchemaRemoveButton"; //$NON-NLS-1$
  /** New connection wizard filter page: add new object filter. */
  public static final String RSC_NEWCW_FILTER_OBJECT_ADD = PLUGIN_NAME + ".newcwObjectAddButton"; //$NON-NLS-1$
  /** New connection wizard filter page: edit object filter. */
  public static final String RSC_NEWCW_FILTER_OBJECT_EDIT = PLUGIN_NAME + ".newcwObjectEditButton"; //$NON-NLS-1$
  /** New connection wizard filter page: remove object filter. */
  public static final String RSC_NEWCW_FILTER_OBJECT_REMOVE = PLUGIN_NAME + ".newcwObjectRemoveButton"; //$NON-NLS-1$

  /** New connection wizard properties page: Java home. */
  public static final String RSC_CONNECTION_DIALOG_JAVAHOME = PLUGIN_NAME + ".newcwJavaHomeCombo"; //$NON-NLS-1$
  /** New connection wizard properties page: Java home browse button. */
  public static final String RSC_CONNECTION_DIALOG_JAVAHOMEBROWSE = PLUGIN_NAME + ".newcwJavaHomeButton"; //$NON-NLS-1$
  /** New connection wizard properties page: Schema or SQL ID. */
  public static final String RSC_CONNECTION_DIALOG_SCHEMASQLID = PLUGIN_NAME + ".newcwSchemaSQLIDCombo"; //$NON-NLS-1$
  /** New connection wizard properties page: Package owner. */
  public static final String RSC_CONNECTION_DIALOG_PACKAGEOWNER = PLUGIN_NAME + ".newcwPackageOwnerCombo"; //$NON-NLS-1$
  /** New connection wizard properties page: build owner. */
  public static final String RSC_CONNECTION_DIALOG_BUILDOWNER = PLUGIN_NAME + ".newcwBuildOwnerCombo"; //$NON-NLS-1$

  /** Connection Filter, Add/Edit filter dialog, Enabled */
  public static final String RSC_NEWCW_FILTER_ADDFILTER_ENABLED = PLUGIN_NAME + ".newcwEnabledCheck"; //$NON-NLS-1$
  /** Connection Filter, Add/Edit filter dialog, Target */
  public static final String RSC_NEWCW_FILTER_ADDFILTER_TARGET = PLUGIN_NAME + ".newcwTargetCombo"; //$NON-NLS-1$
  /** Connection Filter, Add/Edit filter dialog, Predicate */
  public static final String RSC_NEWCW_FILTER_ADDFILTER_PREDICATE = PLUGIN_NAME + ".newcwPredCombo"; //$NON-NLS-1$
  /** Connection Filter, Add/Edit filter dialog, text entry */
  public static final String RSC_NEWCW_FILTER_ADDFILTER_NAME = PLUGIN_NAME + ".newcwFilterCombo"; //$NON-NLS-1$
  /** Connection Filter, Add/Edit filter dialog, Operator */
  public static final String RSC_NEWCW_FILTER_ADDFILTER_OPERATOR = PLUGIN_NAME + ".newcwOperatorCombo"; //$NON-NLS-1$

  /** Connection wizard calling page combo listing existing connections. */
  public static final String RSC_NEWCW_CALLER_COMBO = PLUGIN_NAME + ".newcwCallerCombo"; //$NON-NLS-1$
  /** Connection wizard calling page button. */
  public static final String RSC_NEWCW_CALLER_BUTTON = PLUGIN_NAME + ".newcwCallerButton"; //$NON-NLS-1$

  /** Connection Summary table. */
  public static final String RSC_NEWCW_SUMMARY_TABLE = PLUGIN_NAME + ".newcwSummaryTable"; //$NON-NLS-1$

  /* Connection dialog */
  public static final String RSC_CONNECTION_DIALOG = PLUGIN_NAME + ".conn0001"; //$NON-NLS-1$

  /* Connection dialog name */
  public static final String RSC_CONNECTION_DIALOG_NAME = PLUGIN_NAME + ".conn0011"; //$NON-NLS-1$

  /* Connection dialog port */
  public static final String RSC_CONNECTION_DIALOG_PORT = PLUGIN_NAME + ".conn0013"; //$NON-NLS-1$

  /* Connection dialog server */
  public static final String RSC_CONNECTION_DIALOG_SERVER = PLUGIN_NAME + ".conn0014"; //$NON-NLS-1$

  /* Connection dialog use existing connection */
  public static final String RSC_CONNECTION_DIALOG_EXISTING_CON = PLUGIN_NAME + ".conn0015"; //$NON-NLS-1$

  /* Connection dialog database location */
  public static final String RSC_CONNECTION_DIALOG_DATABASE_LOCATION = PLUGIN_NAME + ".conn0018"; //$NON-NLS-1$

  /* Connection dialog database */
  public static final String RSC_CONNECTION_DIALOG_DATABASE = PLUGIN_NAME + ".conn0002"; //$NON-NLS-1$

  /* Connection dialog user ID */
  public static final String RSC_CONNECTION_DIALOG_USER_ID = PLUGIN_NAME + ".conn0003"; //$NON-NLS-1$

  /* Connection dialog password */
  public static final String RSC_CONNECTION_DIALOG_PASSWORD = PLUGIN_NAME + ".conn0004"; //$NON-NLS-1$

  /* Connection dialog JDBC driver */
  public static final String RSC_CONNECTION_DIALOG_JDBC_DRIVER = PLUGIN_NAME + ".conn0005"; //$NON-NLS-1$

//  /* Connection dialog JDBC subprotocol */
//  public static final String RSC_CONNECTION_DIALOG_JDBC_SUBPROTOCOL = PLUGIN_NAME + ".conn0006";

  /* Connection dialog host */
  public static final String RSC_CONNECTION_DIALOG_HOST = PLUGIN_NAME + ".conn0007"; //$NON-NLS-1$

  /* Connection dialog JDBC driver class */
  public static final String RSC_CONNECTION_DIALOG_JDBC_DRIVER_CLASS = PLUGIN_NAME + ".conn0008"; //$NON-NLS-1$

  /* Connection dialog JDBC driver class location */
  public static final String RSC_CONNECTION_DIALOG_JDBC_DRIVER_CLASS_LOCATION = PLUGIN_NAME + ".conn0009"; //$NON-NLS-1$

  /* Connection dialog filters */
  public static final String RSC_CONNECTION_DIALOG_FILTERS = PLUGIN_NAME + ".conn0010"; //$NON-NLS-1$

  /* Connection Filter properties dialog */
  public static final String RSC_FILTER_PROPERTIES_DIALOG = PLUGIN_NAME + ".filt0001"; //$NON-NLS-1$

  /* Connection Filter properties new filter/add */
  public static final String RSC_FILTER_PROPERTIES_NEW_FILT_ADD = PLUGIN_NAME + ".filt0002"; //$NON-NLS-1$

  /* Connection Filter properties exclude system schemas */
  public static final String RSC_FILTER_PROPERTIES_EXCLUDE = PLUGIN_NAME + ".filt0003"; //$NON-NLS-1$

  /* Connection Filter properties connection filters table */
  public static final String RSC_FILTER_PROPERTIES_FILTERS = PLUGIN_NAME + ".filt0004"; //$NON-NLS-1$

  /* Connection Filter properties remove */
  public static final String RSC_FILTER_PROPERTIES_REMOVE = PLUGIN_NAME + ".filt0005"; //$NON-NLS-1$

  /* Connection Filter properties Move up/down */
  public static final String RSC_FILTER_PROPERTIES_MOVE = PLUGIN_NAME + ".filt0007"; //$NON-NLS-1$

  /* Connection Filter properties Language options */
  public static final String RSC_FILTER_PROPERTIES_LANG_OPTS = PLUGIN_NAME + ".filt0009"; //$NON-NLS-1$

  /* Connection Filter properties Query preview */
  public static final String RSC_FILTER_PROPERTIES_QUERYTXT = PLUGIN_NAME + ".filt0006"; //$NON-NLS-1$

  /* Connection Filter, Add filter dialog, Target */
  public static final String RSC_FILTER_ADDFILTER_TARGET = PLUGIN_NAME + ".filt0010"; //$NON-NLS-1$

  /* Connection Filter, Add filter dialog, Predicate */
  public static final String RSC_FILTER_ADDFILTER_PREDICATE = PLUGIN_NAME + ".filt0011"; //$NON-NLS-1$

  /* Connection Filter, Add filter dialog, Name entry */
  public static final String RSC_FILTER_ADDFILTER_NAME = PLUGIN_NAME + ".filt0012"; //$NON-NLS-1$

  /* Database wizard */
  public static final String RSC_DATABASE_WIZARD = PLUGIN_NAME + ".datb0001"; //$NON-NLS-1$

  /* Database properties */
  public static final String RSC_DATABASE_PROPERTIES = PLUGIN_NAME + ".datb0002"; //$NON-NLS-1$

  /* Database wizard folder*/
  public static final String RSC_DATABASE_WIZARD_FOLDER = PLUGIN_NAME + ".datb0003"; //$NON-NLS-1$

  /* Database wizard name */
  public static final String RSC_DATABASE_WIZARD_NAME = PLUGIN_NAME + ".datb0004"; //$NON-NLS-1$

  /* Database wizard comments*/
  public static final String RSC_DATABASE_WIZARD_COMMENTS = PLUGIN_NAME + ".datb0005"; //$NON-NLS-1$

  /* Database wizard vendor type*/
  public static final String RSC_DATABASE_WIZARD_VENDOR_TYPE = PLUGIN_NAME + ".datb0006"; //$NON-NLS-1$


 /* Schema wizard */
  public static final String RSC_SCHEMA_WIZARD = PLUGIN_NAME + ".schm0001"; //$NON-NLS-1$

  /* Schema properties */
  public static final String RSC_SCHEMA_PROPERTIES = PLUGIN_NAME + ".schm0002"; //$NON-NLS-1$

  /* Schema wizard folder*/
  public static final String RSC_SCHEMA_WIZARD_FOLDER = PLUGIN_NAME + ".schm0003"; //$NON-NLS-1$

  /* Schema wizard name */
  public static final String RSC_SCHEMA_WIZARD_NAME = PLUGIN_NAME + ".schm0004"; //$NON-NLS-1$

  /* Schema wizard database name*/
  public static final String RSC_SCHEMA_WIZARD_DATABASE_NAME = PLUGIN_NAME + ".schm0005"; //$NON-NLS-1$

  /* Table wizard */
  public static final String RSC_TABLE_WIZARD = PLUGIN_NAME + ".tabl0001"; //$NON-NLS-1$

  /* Table properties */
  public static final String RSC_TABLE_PROPERTIES = PLUGIN_NAME + ".tabl0002"; //$NON-NLS-1$

  /* Table general page context*/
  public static final String RSC_TABLE_GENERAL_PAGE = PLUGIN_NAME + ".tabl0003"; //$NON-NLS-1$

  /* Table wizard folder*/
  public static final String RSC_TABLE_WIZARD_FOLDER = PLUGIN_NAME + ".tabl0004"; //$NON-NLS-1$

  /* Table wizard name */
  public static final String RSC_TABLE_WIZARD_NAME = PLUGIN_NAME + ".tabl0005"; //$NON-NLS-1$

  /* Table wizard database name*/
  public static final String RSC_TABLE_WIZARD_DATABASE_NAME = PLUGIN_NAME + ".tabl0006"; //$NON-NLS-1$

  /* Table wizard schema name*/
  public static final String RSC_TABLE_WIZARD_SCHEMA_NAME = PLUGIN_NAME + ".tabl0007"; //$NON-NLS-1$

//  /* Table wizard transient*/
//  public static final String RSC_TABLE_WIZARD_TRANSIENT = PLUGIN_NAME + ".tabl0008";
////
//  /* Table wizard immutable*/
//  public static final String RSC_TABLE_WIZARD_IMMUTABLE = PLUGIN_NAME + ".tabl0009";
////
//  /* Schema wizard reference generation*/
//  public static final String RSC_TABLE_WIZARD_REFERENCE_GENERATION = PLUGIN_NAME + ".tabl0010";

  /* Table wizard comments*/
  public static final String RSC_TABLE_WIZARD_COMMENTS = PLUGIN_NAME + ".tabl0011"; //$NON-NLS-1$

  /* Table wizard cols more button */
  public static final String RSC_TABLE_WIZARD_MORE_COLS = PLUGIN_NAME + ".tabl0012"; //$NON-NLS-1$

  /* Table wizard fk more button */
  public static final String RSC_TABLE_WIZARD_MORE_FK = PLUGIN_NAME + ".tabl0013"; //$NON-NLS-1$

  /* Table wizard pk more button */
  public static final String RSC_TABLE_WIZARD_MORE_PK = PLUGIN_NAME + ".tabl0014"; //$NON-NLS-1$


  /* Table wizard column page*/
  public static final String RSC_TABLE_WIZARD_COLUMN_PAGE  = PLUGIN_NAME + ".tabl0020"; //$NON-NLS-1$

  /* Table wizard column name */
  public static final String RSC_TABLE_WIZARD_COLUMN_NAME  = PLUGIN_NAME + ".tabl0021"; //$NON-NLS-1$

  /* Table wizard column type */
  public static final String RSC_TABLE_WIZARD_COLUMN_TYPE  = PLUGIN_NAME + ".tabl0022"; //$NON-NLS-1$

  /* Table wizard column default */
  public static final String RSC_TABLE_WIZARD_COLUMN_DEFAULT  = PLUGIN_NAME + ".tabl0023"; //$NON-NLS-1$

  /* Table wizard column nullable */
  public static final String RSC_TABLE_WIZARD_COLUMN_NULLABLE  = PLUGIN_NAME + ".tabl0024"; //$NON-NLS-1$

  /* Table wizard column add/delete */
  public static final String RSC_TABLE_WIZARD_COLUMN_ADD_DEL  = PLUGIN_NAME + ".tabl0025"; //$NON-NLS-1$

  /* Table wizard column comments */
  public static final String RSC_TABLE_WIZARD_COLUMN_COMMENTS  = PLUGIN_NAME + ".tabl0026"; //$NON-NLS-1$

  /* Table wizard column key column */
  public static final String RSC_TABLE_WIZARD_COLUMN_IS_KEY  = PLUGIN_NAME + ".tabl0027"; //$NON-NLS-1$



  /* Table wizard primary key page*/
  public static final String RSC_TABLE_WIZARD_PRIMARY_KEY_PAGE = PLUGIN_NAME + ".tabl0030"; //$NON-NLS-1$

  /* Table wizard primary key name */
  public static final String RSC_TABLE_WIZARD_PRIMARY_KEY_NAME = PLUGIN_NAME + ".tabl0031"; //$NON-NLS-1$

  /* Table wizard primary key source columns, >, <, <<, >> */
  public static final String RSC_TABLE_WIZARD_PRIMARY_KEY_SRC_COLS = PLUGIN_NAME + ".tabl0032"; //$NON-NLS-1$

  /* Table wizard primary key sort */
  public static final String RSC_TABLE_WIZARD_PRIMARY_KEY_SORT = PLUGIN_NAME + ".tabl0033"; //$NON-NLS-1$


  /* Table wizard foreign key page*/
  public static final String RSC_TABLE_WIZARD_FOREIGN_KEY_PAGE = PLUGIN_NAME + ".tabl0040"; //$NON-NLS-1$

  /* Table wizard foreign key name */
  public static final String RSC_TABLE_WIZARD_FOREIGN_KEY_NAME = PLUGIN_NAME + ".tabl0041"; //$NON-NLS-1$

  /* Table wizard foreign key on delete */
  public static final String RSC_TABLE_WIZARD_FOREIGN_KEY_ON_DELETE = PLUGIN_NAME + ".tabl0042"; //$NON-NLS-1$

  /* Table wizard foreign key on update */
  public static final String RSC_TABLE_WIZARD_FOREIGN_KEY_ON_UPDATE = PLUGIN_NAME + ".tabl0043"; //$NON-NLS-1$

  /* Table wizard foreign key target table & browse btn */
  public static final String RSC_TABLE_WIZARD_FOREIGN_KEY_TARGET_TBL = PLUGIN_NAME + ".tabl0044"; //$NON-NLS-1$

  /* Table wizard foreign key add/delete */
  public static final String RSC_TABLE_WIZARD_FOREIGN_KEY_ADD_DEL = PLUGIN_NAME + ".tabl0045"; //$NON-NLS-1$

  /* Table wizard foreign key source columns, >, <, >>, << */
  public static final String RSC_TABLE_WIZARD_FOREIGN_KEY_SRC_COL = PLUGIN_NAME + ".tabl0046"; //$NON-NLS-1$

  /* Table wizard foreign key sort */
  public static final String RSC_TABLE_WIZARD_FOREIGN_KEY_SORT = PLUGIN_NAME + ".tabl0047"; //$NON-NLS-1$



  /* ExecuteViewer.java -- Execute SQL Statement Page*/
  public static final String RSC_EXECUTE_STATEMENT_PAGE = PLUGIN_NAME + ".sqls1000"; //$NON-NLS-1$


  /* New view dialog */
  public static final String RSC_VIEW_WIZARD = PLUGIN_NAME + ".newv0001"; //$NON-NLS-1$

  /* New view name */
  public static final String RSC_VIEW_WIZARD_NAME = PLUGIN_NAME + ".newv0002"; //$NON-NLS-1$

  /* New view dialog */
  public static final String RSC_VIEW_STATEMENT_TYPE = PLUGIN_NAME + ".newv0003"; //$NON-NLS-1$


  /* Data export */
  public static final String RSC_DATA_EXPORT = PLUGIN_NAME + ".srvx0001"; //$NON-NLS-1$

  /* Data definition */
  public static final String RSC_DATA_EXPORT_DEF = PLUGIN_NAME + ".srvx0002"; //$NON-NLS-1$

  /* Data Export confirm dialog - Commit */
  public static final String RSC_DATA_EXPORT_COMMITBUTTON = PLUGIN_NAME + ".srvx0003"; //$NON-NLS-1$

  /* Data Export confirm dialog - Rollback */
  public static final String RSC_DATA_EXPORT_ROLLBACKBUTTON = PLUGIN_NAME + ".srvx0004"; //$NON-NLS-1$

  /* Data export options */
  public static final String RSC_DATA_EXPORT_OPTIONS = PLUGIN_NAME + ".datx0001"; //$NON-NLS-1$

  /* Data export automatically commit changes */
  public static final String RSC_DATA_EXPORT_AUTO_COMMIT = PLUGIN_NAME + ".datx0002"; //$NON-NLS-1$

  /* Data export commit changes upon success */
  public static final String RSC_DATA_EXPORT_COMMIT_SUCCESS = PLUGIN_NAME + ".datx0003"; //$NON-NLS-1$

  /* Data export prompt before commit */
  public static final String RSC_DATA_EXPORT_COMMIT_PROMPT = PLUGIN_NAME + ".datx0004"; //$NON-NLS-1$

  /* Data export generate DDL  with DROP */
  public static final String RSC_DATA_EXPORT_GEN_DDL_DROP = PLUGIN_NAME + ".gddl0006"; //$NON-NLS-1$


  /* Generate DDL wizard */
  public static final String RSC_GEN_DDL = PLUGIN_NAME + ".gddl0001"; //$NON-NLS-1$

  /* Generate DDL wizard folder and browse button */
  public static final String RSC_GEN_DDL_FOLDER = PLUGIN_NAME + ".gddl0002"; //$NON-NLS-1$

  /* Generate DDL wizard file name */
  public static final String RSC_GEN_DDL_FILENAME = PLUGIN_NAME + ".gddl0003"; //$NON-NLS-1$

  /* Generate DDL wizard fully qualified */
  public static final String RSC_GEN_DDL_QUAL = PLUGIN_NAME + ".gddl0004"; //$NON-NLS-1$

  /* Generate DDL wizard - delimited */
  public static final String RSC_GEN_DDL_DELIM = PLUGIN_NAME + ".gddl0005"; //$NON-NLS-1$

  /* Generate DDL wizard with DROP */
  public static final String RSC_GEN_DDL_DROP = PLUGIN_NAME + ".gddl0006"; //$NON-NLS-1$

  /* Generate DDL wizard open for editting */
  public static final String RSC_GEN_DDL_EDIT = PLUGIN_NAME + ".gddl0007"; //$NON-NLS-1$

  /* Run script */
  public static final String RSC_RUN_SCRIPT = PLUGIN_NAME + ".srvr0001"; //$NON-NLS-1$

  /* Run script statement list */
  public static final String RSC_RUN_SCRIPT_STATEMENT = PLUGIN_NAME + ".srvr0002"; //$NON-NLS-1$


  /* Execute */
  public static final String RSC_EXEC = PLUGIN_NAME + ".exec0001"; //$NON-NLS-1$

  /* Execute folder + browse button */
  public static final String RSC_EXEC_FOLDER = PLUGIN_NAME + ".exec0002"; //$NON-NLS-1$

  /* Execute database name */
  public static final String RSC_EXEC_DB = PLUGIN_NAME + ".exec0003"; //$NON-NLS-1$

  /* Execute schema */
  public static final String RSC_EXEC_SCHEMA = PLUGIN_NAME + ".exec0004"; //$NON-NLS-1$

  /* Execute - use default schema folder or ejb's */
  public static final String RSC_EXEC_DEF_EJB_FOLDER = PLUGIN_NAME + ".exec0005"; //$NON-NLS-1$


  /* Statements */
  public static final String RSC_STATEMENTS = PLUGIN_NAME + ".stat0001"; //$NON-NLS-1$

  /* Statements list */
  public static final String RSC_STATEMENTS_LIST = PLUGIN_NAME + ".stat0002"; //$NON-NLS-1$


  /* New DDL wizard */
  public static final String RSC_NEW_DDL = PLUGIN_NAME + ".sddl0001"; //$NON-NLS-1$

  /* New DDL wizard folder */
  public static final String RSC_NEW_DDL_FOLDER = PLUGIN_NAME + ".sddl0002"; //$NON-NLS-1$

  /* New DDL wizard filename */
  public static final String RSC_NEW_DDL_FILENAME = PLUGIN_NAME + ".sddl0003"; //$NON-NLS-1$

  /* New DDL wizard - gen sample DML */
  public static final String RSC_NEW_DDL_SAMPLE_DML = PLUGIN_NAME + ".sddl0004"; //$NON-NLS-1$

  /* New DDL wizard - gen sample DDL */
  public static final String RSC_NEW_DDL_SAMPLE_DDL = PLUGIN_NAME + ".sddl0005"; //$NON-NLS-1$

  /* New DDL wizard - open for editting */
  public static final String RSC_NEW_DDL_EDIT = PLUGIN_NAME + ".sddl0006"; //$NON-NLS-1$


  /* Preference - default db vendor */
  public static final String RSC_PREF_DEFAULT_VENDOR = PLUGIN_NAME + ".pref0002"; //$NON-NLS-1$


  /* Filters - show project hierarchy */
  public static final String RSC_FILT_SHOW_HIERARCHY = PLUGIN_NAME + ".filt1001"; //$NON-NLS-1$

  /* Filters - only projects with db resources */
  public static final String RSC_FILT_PROJ_WITH_DB = PLUGIN_NAME + ".filt1004"; //$NON-NLS-1$

  /* Filters - show SQL/DDL scripts */
  public static final String RSC_FILT_SHOW_SQL = PLUGIN_NAME + ".filt1005"; //$NON-NLS-1$

  /* Filters - show columns in tree */
  public static final String RSC_FILT_SHOW_IN_TREE = PLUGIN_NAME + ".filt1006"; //$NON-NLS-1$


  /* View builder - view details page */
  public static final String RSC_VB_DETAILS = PLUGIN_NAME + ".vbld0001"; //$NON-NLS-1$

  /* RSCCoreUIPreferencePage - SQL Query Preference page */
  public static final String RSC_SQL_QUERY_PREFERENCE_PAGE = PLUGIN_NAME + ".sqlp0001"; //$NON-NLS-1$
  public static final String P_VALIDATE_BEFORE_SAVE = PLUGIN_NAME + ".sqlp0002"; //$NON-NLS-1$
}

