/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import java.util.List;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.NewCWJDBCPage;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

/**
 * Overrides NewCWJDBCPage to allow user to create a new connection
 * @author Quy V. On, quyon@us.ibm.com
 */
public class ConnectionSelectionJDBCWizardPage extends NewCWJDBCPage {
    
    /**
     * Creates an instance of ConnectionSelectionJDBCWizardPage
     * @param aName the name of this page
     */
    public ConnectionSelectionJDBCWizardPage (String aName) {
    	super(aName);
    }
    
    /**
     * Creates an instance of this class
     * @param name the name for this page
     * @param existingConnectionNames the list of existing connection names
     */
    public ConnectionSelectionJDBCWizardPage(String name, List existingConnectionNames) {
        super(name, existingConnectionNames);
    }
    
    /**
     * The <code>WizardPage</code> implementation of this <code>IWizardPage</code>
     * method returns <code>true</code> if this page is complete (<code>isPageComplete</code>)
     * and there is a next page to flip to. Subclasses may override (extend or reimplement).
     *
     * @see #getNextPage
     * @see #isPageComplete
     */
    public boolean canFlipToNextPage() {
    	// removed the check for the next page being null as it isn't constructed until 
    	// the next page button is pressed.
    	return isPageComplete();
    }
    
    /**
     * @see org.eclipse.jface.wizard.IWizardPage#getNextPage()
     */
    public IWizardPage getNextPage() {
    	IWizardPage page = null;
    	if (isPageComplete() && (getWizard() instanceof ConnectionSelectionWizard)) {
    		ConnectionSelectionWizard conSelectWiz = (ConnectionSelectionWizard)getWizard();
    		ConnectionSelectionFilterWizardPage filterPage = 
                (ConnectionSelectionFilterWizardPage)conSelectWiz.getPage(
                        ConnectionSelectionWizard.CONNECTION_SELECTION_FILTER_NAME);                        
    		// create the connection so that the schema filter page can populate the
    		// selection list if the user so wishes.
    		boolean isOk = conSelectWiz.createConnection();
    		if (isOk) {
    			ConnectionInfo conInfo = conSelectWiz.getConInfo();
    			if (filterPage.getDefaultPredicate() == null) {
    				String userName = (conInfo == null) ? "" : conInfo.getUserName(); 
    				String predicate = "LIKE '" + userName.toUpperCase() + "%'"; //$NON-NLS-1$ $NON-NLS-2$
    				filterPage.setDefaultPredicate(predicate);
    			}
    			filterPage.setConnectionInfo(conInfo);
    			filterPage.setPageComplete(true);
    			setNextPage(filterPage);
    			page = filterPage;
    		}
    	}
    	return page;
    }
    
    /**
     * @see org.eclipse.jface.dialogs.IDialogPage#setVisible(boolean)
     */
    public void setVisible(boolean visible) {
    	// If the user displays this page, then the filter pages is effectively "reset".  
    	if (visible) {
    		IWizardPage filterPage = getWizard().getPage(
                    ConnectionSelectionWizard.CONNECTION_SELECTION_FILTER_NAME);            
    		if (filterPage != null) {
    			filterPage.getControl().setData(ConnectionSelectionWizard.SKIP, Boolean.TRUE);
    		}
    	}
    	super.setVisible(visible);
    }
}