/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import java.sql.Connection;
import java.text.MessageFormat;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.util.DatabaseProviderHelper;

/**
 * @author ledunnel
 */
public class ConnectionUtils {
    private static boolean isFinalConnection;
    private static Shell theShell;
    
	public static boolean openConnectionWithProgress(ConnectionInfo connectionInfo, boolean showSuccessfulMessage, IWizardContainer container) {
	    theShell = container.getShell();
	    ConnectionInfo connection = connectionInfo;
		try {
			boolean showStatus = false;
			try {
			    container.run(
						true,
						true,
						getTestRunnable(connection,
								NewConnectionWizard.JDBC_CONNECTION_TYPE,
								showSuccessfulMessage));
			} catch (InterruptedException e) {
				showStatus = false;
			} finally {
			}
		} catch (Exception e) {
			MessageDialog.openError((Shell) null, RDBWizardPage.getBundle()
					.getString("CUI_WIZARD_ERRTITLE_UI_"), NewConnectionWizard //$NON-NLS-1$
					.getMessages(e));
			return false;
		}
		return isFinalConnection;
	}

	/**
	 * Gets a Runnable to make the connection.
	 */
	private static IRunnableWithProgress getTestRunnable(
			final ConnectionInfo connection, final int conType,
			final boolean showStatus) {
		IRunnableWithProgress progMonitor = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) {
				if (monitor == null) {
					monitor = new NullProgressMonitor();
				}
				monitor.beginTask("", 3); //$NON-NLS-1$
				if (showStatus){
				    monitor.setTaskName(RDBWizardPage.getBundle()
							.getString("TEST_CONNECTION_PROGRESS_BAR_MESSAGE_UI_")); //$NON-NLS-1$
				}
				monitor.worked(1);
				try {
					if (connection.getSharedConnection() == null) {
						Connection cnx = connection.connect();
						if (cnx == null) {
							throw new Exception(RDBWizardPage.getBundle()
									.getString("CUI_TESTCONNECTION_ERROR_UI_")); //$NON-NLS-1$
						}
						connection.setSharedConnection(cnx);
    				    new DatabaseProviderHelper().setDatabase(cnx, connection, connection.getDatabaseName());
    				    connection.saveConnectionInfo();
					}
					isFinalConnection = true;
					if (showStatus) {
						String title = RDBWizardPage.getBundle().getString(
								"CUI_TESTCONNECTION_TITLE_UI_"); //$NON-NLS-1$
						String message = RDBWizardPage.getBundle().getString(
								"CUI_TESTCONNECTION_SUCCESS_UI_"); //$NON-NLS-1$
						message = MessageFormat
								.format(message, new String[] { connection
										.getDatabaseDefinition().getProduct() });
						monitor.worked(2);
						theShell.getDisplay().asyncExec(
								new DisplayMessage(title, message));
					}
				} catch (Exception e) {
					isFinalConnection = false;
					String title = RDBWizardPage.getBundle().getString(
							"CUI_TESTCONNECTION_TITLE_UI_"); //$NON-NLS-1$
					String message = RDBWizardPage.getBundle().getString(
							"CUI_TESTCONNECTION_FAILURE_UI_"); //$NON-NLS-1$
					message = MessageFormat.format(message, new String[] {
							connection.getDatabaseDefinition().getProduct(),
							e.getMessage() });
					monitor.worked(2);
					theShell.getDisplay().asyncExec(
							new DisplayMessage(title, message));
				}
				monitor.setTaskName(RDBWizardPage.getBundle().getString(
						"CUI_CREATECONDONE_UI_")); //$NON-NLS-1$
				monitor.worked(3);
				monitor.done();
			};
		};
		return progMonitor;
	}
	
	public boolean isFinalConnection() {
		return isFinalConnection;
	}
	
	/** Runnable to display success or failure of Test Connection. */
	public static class DisplayMessage implements Runnable {
		protected String title, message;

		public DisplayMessage(String title, String message) {
			this.title = title;
			this.message = message;
		}

		public void run() {
			MessageDialog.openInformation(theShell, title, message);
		}
	}
}
