/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;

public class NewProcedureAction extends Action {

   private static final String PROCEDURE_TEMPLATE = "ProcedureTemplate.ddl"; //$NON-NLS-1$
   private static final String PROCEDURE_JAVA_TEMPLATE = "JavaProcedureTemplate.ddl"; //$NON-NLS-1$
   private static final String TITLE = ServerExtensionsPlugin.getString("NEW_PROCEDURE"); //$NON-NLS-1$

   /**
    * Launch SQL Editor with template content
    */
   public void run(IAction action) {
      try {
         init(); //sets database
         // if cloudscape, use java template since it only has Java Sps  
         if (Utility.isCloudscape(Utility.getDBDef(database)))
            launchSQLEditor(PROCEDURE_JAVA_TEMPLATE, TITLE);
         else
            launchSQLEditor(PROCEDURE_TEMPLATE, TITLE);
      }
      catch (Exception e) {
         ServerExtensionsPlugin.getDefault().writeLog(IStatus.ERROR, 0, e.getMessage(), e);
      }
   }

}