package org.eclipse.jst.j2ee.internal.reference;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceExtManager;
import org.eclipse.jst.j2ee.internal.webservices.WSDLServiceHelper;
import org.eclipse.jst.j2ee.internal.webservices.WebServicesClientDataHelper;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class ServiceReferenceDataModel extends ReferenceDataModel implements WebServicesClientDataHelper {
	/**
	 * Required, type String
	 */
	public static final String TARGET_WEB_SERVICE = "ServiceReferenceDataModel.TARGET_WEB_SERVICE"; //$NON-NLS-1$
	/**
	 * Required, type String
	 */
	public static final String WSDL_FILE = "ServiceReferenceDataModel.WSDL_FILE"; //$NON-NLS-1$
	/**
	 * Required, type String
	 */
	public static final String JAX_RPC_MAPPING_FILE = "ServiceReferenceDataModel.JAX_RPC_MAPPING_FILE"; //$NON-NLS-1$
	/**
	 * Required, type String
	 */
	public static final String QNAME_NAMESPACE_URI = "ServiceReferenceDataModel.QNAME_NAMESPACE_URI"; //$NON-NLS-1$
	/**
	 * Required, type String
	 */
	public static final String QNAME_lOCAL_PART = "ServiceReferenceDataModel.QNAME_lOCAL_PART"; //$NON-NLS-1$
	/**
	 * Required, type String
	 */
	public static final String WSDL_URL = "ServiceReferenceDataModel.WSDL_URL"; //$NON-NLS-1$
	/**
	 * Required, type String
	 */
	public static final String QNAME = "ServiceReferenceDataModel.QNAME"; //$NON-NLS-1$
	/**
	 * Required, type String
	 */
	public static final String LINKS = "ServiceReferenceDataModel.LINK"; //$NON-NLS-1$

	private String[] serviceEndpointInterfaceNames = null;
	private String serviceInterfaceName = null;
	private boolean didGenDescriptor = false;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jem.util.emf.workbench.operation.EditModelOperationDataModel#initValidBaseProperties()
	 */
	protected void initValidBaseProperties() {
		addValidBaseProperty(TARGET_WEB_SERVICE);
		addValidBaseProperty(WSDL_FILE);
		addValidBaseProperty(JAX_RPC_MAPPING_FILE);
		addValidBaseProperty(QNAME_NAMESPACE_URI);
		addValidBaseProperty(QNAME_lOCAL_PART);
		addValidBaseProperty(WSDL_URL);
		addValidBaseProperty(QNAME);
		addValidBaseProperty(LINKS);
		super.initValidBaseProperties();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.etools.j2ee.reference.ReferenceDataModel#doSetProperty(java.lang.String,
	 *      java.lang.Object)
	 */
	protected boolean doSetProperty(String propertyName, Object propertyValue) {
		boolean doSet = super.doSetProperty(propertyName, propertyValue);
		if (propertyName.equals(TARGET_WEB_SERVICE)) {
			notifyDefaultChange(REF_NAME);
			notifyDefaultChange(WSDL_FILE);
			notifyDefaultChange(WSDL_URL);
			notifyDefaultChange(QNAME);
			notifyDefaultChange(QNAME_NAMESPACE_URI);
			notifyDefaultChange(QNAME_lOCAL_PART);
		}
		return doSet;
	}

	protected Object getLocationForServiceFromWSIL(EObject wsdl) {
		// Fix to get "external" workspace wsdl file because wsilparser uses generic resource set
		WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
		if (wsdl.eResource() == null)
			return serviceHelper.getServiceDefinitionLocation(wsdl);
		URI uri = wsdl.eResource().getURI();
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IPath rootPath = root.getLocation();
		IPath wsdlPath = new Path(uri.toFileString());
		if (wsdlPath.matchingFirstSegments(rootPath) == rootPath.segmentCount()) {
			IFile wsdlFile = root.getFile(wsdlPath.removeFirstSegments(rootPath.segmentCount()));
			if (wsdlFile.exists()) {
				return wsdlFile.getProjectRelativePath().removeFirstSegments(1).toString();
			}
		}
		return null;
	}

	protected Object getDefaultProperty(String propertyName) {
		WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
		if (propertyName.equals(REF_NAME)) {
			Object wsdl = getProperty(TARGET_WEB_SERVICE);
			if (wsdl != null)
				return "service/" + serviceHelper.getServiceLocalPart(wsdl); //$NON-NLS-1$
		} else if (propertyName.equals(WSDL_FILE)) {
			EObject wsdl = (EObject)getProperty(TARGET_WEB_SERVICE);
			if (wsdl != null) {
				boolean isInternal = WorkbenchResourceHelper.getFile(wsdl) != null && WorkbenchResourceHelper.getFile(wsdl).exists();
				if (isInternal)
					return WorkbenchResourceHelper.getFile(wsdl).getProjectRelativePath().removeFirstSegments(1).toString();

				Object location = getLocationForServiceFromWSIL(wsdl);
				if (location != null)
					return location;
			}
		} else if (propertyName.equals(WSDL_URL)) {
			EObject wsdl = (EObject) getProperty(TARGET_WEB_SERVICE);
			if (wsdl != null) {
				boolean isInternal = WorkbenchResourceHelper.getFile(wsdl) != null && WorkbenchResourceHelper.getFile(wsdl).exists();
				if (isInternal)
					return "file:/" + WorkbenchResourceHelper.getFile(wsdl).getRawLocation().toString(); //$NON-NLS-1$
				return serviceHelper.getServiceDefinitionLocation(wsdl);
			}
		} else if (propertyName.equals(QNAME)) {
			EObject wsdl = (EObject) getProperty(TARGET_WEB_SERVICE);
			if (wsdl != null)
				return serviceHelper.getServiceQName(wsdl);
		} else if (propertyName.equals(QNAME_NAMESPACE_URI)) {
			EObject wsdl = (EObject) getProperty(TARGET_WEB_SERVICE);
			if (wsdl != null) {
				Object qName = serviceHelper.getServiceQName(wsdl);
				if (qName != null)
					return serviceHelper.getServiceNamespaceURI(wsdl);
			}
		} else if (propertyName.equals(QNAME_lOCAL_PART)) {
			EObject wsdl = (EObject) getProperty(TARGET_WEB_SERVICE);
			if (wsdl != null) {
				Object qName = serviceHelper.getServiceQName(wsdl);
				if (qName != null)
					return serviceHelper.getServiceLocalPart(wsdl);
			}
		}
		return super.getDefaultProperty(propertyName);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.etools.j2ee.reference.ReferenceDataModel#doValidateProperty(java.lang.String)
	 */
	protected IStatus doValidateProperty(String propertyName) {
		IStatus stat = super.doValidateProperty(propertyName);
		WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
		if (!serviceHelper.isService(getProperty(TARGET_WEB_SERVICE))) {
			return WTPCommonPlugin.createErrorStatus(J2EECreationResourceHandler.getString("ServiceReferenceDataModel_ERROR_8")); //$NON-NLS-1$
		}
		return stat;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jem.util.operation.WTPOperationDataModel#getDefaultOperation()
	 */
	public WTPOperation getDefaultOperation() {
		return new ServiceReferenceCreationOperation(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.j2ee.webservices.WebServicesClientDataHelper#getWSDLUrl()
	 */
	public String getWSDLUrl() {
		return getStringProperty(WSDL_URL);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.j2ee.webservices.WebServicesClientDataHelper#getServiceQName()
	 */
	public String getServiceQName() {
		return getStringProperty(QNAME_NAMESPACE_URI) + ":" + getStringProperty(QNAME_lOCAL_PART); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.j2ee.webservices.WebServicesClientDataHelper#getServiceInterfaceName()
	 */
	public String getServiceInterfaceName() {
		return serviceInterfaceName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.j2ee.webservices.WebServicesClientDataHelper#getServiceEndpointInterfaceNames()
	 */
	public String[] getServiceEndpointInterfaceNames() {
		return serviceEndpointInterfaceNames;
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.j2ee.webservices.WebServicesClientDataHelper#setServiceInterfaceName(java.lang.String)
	 */
	public void setServiceInterfaceName(String name) {
		serviceInterfaceName = name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.j2ee.webservices.WebServicesClientDataHelper#setServiceEndpointInterfaceNames(java.lang.String[])
	 */
	public void setServiceEndpointInterfaceNames(String[] names) {
		serviceEndpointInterfaceNames = names;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.j2ee.webservices.WebServicesClientDataHelper#getProjectName()
	 */
	public String getProjectName() {
		Object owner = getProperty(OWNER);
		String name = ProjectUtilities.getProject(owner).getName();
		return name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.j2ee.webservices.WebServicesClientDataHelper#getOutputWSDLFileName()
	 */
	public String getOutputWSDLFileName() {
		WSDLServiceHelper serviceHelper = WSDLServiceExtManager.getServiceHelper();
		Object owner = getProperty(OWNER);
		String outputLocation = null;
		IProject project;
		switch (getDeploymentDescriptorType()) {
			case XMLResource.APP_CLIENT_TYPE :
				project = ProjectUtilities.getProject(owner);
				outputLocation = project.getFullPath().toString() + "\\appClientModule\\META-INF\\"; //$NON-NLS-1$
				break;
			case XMLResource.EJB_TYPE :
				project = ProjectUtilities.getProject(owner);
				outputLocation = project.getFullPath().toString() + "\\ejbModule\\META-INF\\"; //$NON-NLS-1$
				break;
			case XMLResource.WEB_APP_TYPE :
				project = ProjectUtilities.getProject(owner);
				outputLocation = project.getFullPath().toString() + "\\Web Content\\WEB-INF\\"; //$NON-NLS-1$
				break;
		}
		EObject service = (EObject) getProperty(TARGET_WEB_SERVICE);
		if (service == null)
			return ""; //$NON-NLS-1$
		return outputLocation + serviceHelper.getServiceLocalPart(service) + ".wsdl"; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.j2ee.webservices.WebServicesClientDataHelper#shouldDeploy()
	 */
	public boolean shouldDeploy() {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.j2ee.webservices.WebServicesClientDataHelper#shouldGenDescriptors()
	 */
	public boolean shouldGenDescriptors() {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ibm.wtp.j2ee.webservices.WebServicesClientDataHelper#setDidGenDescriptors(boolean)
	 */
	public void setDidGenDescriptors(boolean b) {
		didGenDescriptor = b;
	}

	public boolean didGenDescriptors() {
		return didGenDescriptor;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jem.util.operation.WTPOperationDataModel#isResultProperty(java.lang.String)
	 */
	protected boolean isResultProperty(String propertyName) {
		if (propertyName.equals(JAX_RPC_MAPPING_FILE))
			return true;
		return super.isResultProperty(propertyName);
	}

}
