package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.jface.viewers.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.*;

public class TableDataCellEditor extends TextCellEditor {

    protected TableDataEditor editor;
    
    public TableDataCellEditor(TableDataEditor editor, Composite parent)
    {
        super(parent);
        
        this.editor = editor;
        
    }
    
    protected Control createControl(Composite parent) {
        Control c = super.createControl(parent);
		c.addTraverseListener(new TraverseListener() {
            public void keyTraversed(TraverseEvent e) {
                handleTraverse(e);
                
            }
		});
        return c;
    }
        
    protected void handleTraverse(TraverseEvent e)
    {
        if (e.detail == SWT.TRAVERSE_TAB_PREVIOUS || e.detail == SWT.TRAVERSE_TAB_NEXT) {
            fireApplyEditorValue();
            deactivate();
            editor.getCursor().handleTraverse(e);
            editor.getCursor().edit();
        }
    }
}
