/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.core.runtime.*;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.wst.rdb.data.internal.core.common.*;
import org.eclipse.wst.rdb.data.internal.core.editor.*;
import org.eclipse.wst.rdb.data.internal.ui.*;


public class TableDataCellModifier implements ICellModifier {

    protected TableDataEditor editor;
    protected TableViewer viewer;
    
    protected boolean canModify = false;
    
    public TableDataCellModifier(TableDataEditor editor, TableViewer viewer)
    {
        this.editor = editor;
        this.viewer = viewer;
    }
    
    public boolean canModify(Object element, String property) {
        return canModify && !editor.isReadonly();
    }
    
    public void setCanModify(boolean canModify)
    {
        this.canModify = canModify;
    }

    public Object getValue(Object element, String property) {
        int col = getColumnIndex(property);
        
        if (!(element instanceof IRowData))
            return ""; //$NON-NLS-1$
        
        IRowData row = (IRowData)element;

        try {            
            Object o = row.getValue(col);
            String s = DataSerializer.serialize(o , row.getTable().getColumnType(col));
            
            return (s==null)?"":s; //$NON-NLS-1$
        } catch (Exception ex) {
            DataUIPlugin.getDefault().writeLog(IStatus.ERROR, 0, ex.getMessage(), ex);
            return Messages.getString("TableDataCellModifier.error"); //$NON-NLS-1$
        }
    }

    public void modify(Object element, String property, Object value) {
        int column = getColumnIndex(property);        
        
        if (element instanceof Item)
            element = ((Item) element).getData();
        
        IRowData row = editor.getOrCreateRow();
        
        Object oldObject = row.getValue(column);
        String oldString = DataSerializer.serialize(oldObject , row.getTable().getColumnType(column));
        if (value.equals(oldString))
            return;               
        
        try {
            editor.setDirty(true);
            Object o = DataDeserializer.deserialize((String)value, row.getTable().getColumnType(column));
            row.updateValue(column, o);
        }  catch (Exception ex) {            
            IStatus warning = new Status(IStatus.ERROR, DataUIPlugin.PLUGIN_ID, 1, Messages.getString("TableDataCellModifier.dataFormatError"), ex); //$NON-NLS-1$
            ErrorDialog.openError(viewer.getControl().getShell(), Messages.getString("TableDataCellModifier.ErrorUpdatingData"), null, warning); //$NON-NLS-1$
        }
    
        viewer.refresh(row);
    }
    
    protected int getColumnIndex(String property) {
        Object[] properties = viewer.getColumnProperties();
        int col=0;
        while (properties[col]!=property && col<properties.length)
            ++col;
        if (col==properties.length)
            return -1;
        else 
            return col;
    }
    

}
