/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.actions.FormInputException;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.FindAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.QueryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.DiscoveryURL;
import org.uddi4j.util.DiscoveryURLs;
import org.uddi4j.util.FindQualifier;
import org.uddi4j.util.FindQualifiers;
import org.uddi4j.util.IdentifierBag;
import org.uddi4j.util.KeyedReference;
import org.uddi4j.util.TModelBag;

public class RegFindBusinessesAdvancedAction
extends FindAction {
    public RegFindBusinessesAdvancedAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(0));
        this.propertyTable_.put("queryStyleBusinesses", String.valueOf(1));
        this.propertyTable_.put("advancedBusinessMaxSearchSet", String.valueOf(100));
        this.propertyTable_.put("advancedBusinessMaxResults", String.valueOf(10));
    }

    protected final boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        KeyedReference kr;
        int i;
        String ownedChecked = parser.getParameter("advancedOwned");
        String[] languages = parser.getParameterValues("advancedNameLanguage");
        String[] names = parser.getParameterValues("advancedName");
        String[] idTypes = parser.getParameterValues("advancedIdentifierType");
        String[] idKeyNames = parser.getParameterValues("advancedIdentifierKeyName");
        String[] idKeyValues = parser.getParameterValues("advancedIdentifierKeyValue");
        String[] catTypes = parser.getParameterValues("advancedCategoryType");
        String[] catKeyNames = parser.getParameterValues("advancedCategoryKeyName");
        String[] catKeyValues = parser.getParameterValues("advancedCategoryKeyValue");
        String[] siNodeIds = parser.getParameterValues("nodeId_ServiceInterface");
        String[] discoveryURLValues = parser.getParameterValues("advancedDiscoveryURL");
        String[] findQualifierValues = parser.getParameterValues("advancedFindQualifier");
        String maxSearchSet = parser.getParameter("advancedMaxSearchSet");
        String maxResults = parser.getParameter("advancedMaxResults");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        this.getSelectedNavigatorNode();
        this.getRegistryNode();
        RegistryElement cfr_ignored_0 = (RegistryElement)this.regNode_.getTreeElement();
        if (ownedChecked != null) {
            this.propertyTable_.put("advancedBusinessOwned", ownedChecked);
        } else {
            this.removeProperty("advancedBusinessOwned");
        }
        if (languages != null && names != null) {
            Vector<Name> nameVector = new Vector<Name>();
            i = 0;
            while (i < names.length) {
                Name uddi4jName = languages[i].length() > 0 ? new Name(names[i], languages[i]) : new Name(names[i]);
                nameVector.addElement(uddi4jName);
                ++i;
            }
            this.propertyTable_.put("advancedBusinessNames", nameVector);
        } else {
            this.removeProperty("advancedBusinessNames");
        }
        if (idTypes != null && idKeyNames != null && idKeyValues != null) {
            IdentifierBag idBag = new IdentifierBag();
            i = 0;
            while (i < idKeyNames.length) {
                kr = new KeyedReference(idKeyNames[i], idKeyValues[i], idTypes[i]);
                idBag.add(kr);
                ++i;
            }
            this.propertyTable_.put("advancedBusinessIdentifiers", idBag);
        } else {
            this.removeProperty("advancedBusinessIdentifiers");
        }
        if (catTypes != null && catKeyNames != null && catKeyValues != null) {
            CategoryBag catBag = new CategoryBag();
            i = 0;
            while (i < catTypes.length) {
                kr = new KeyedReference(catKeyNames[i], catKeyValues[i], catTypes[i]);
                catBag.add(kr);
                ++i;
            }
            this.propertyTable_.put("advancedBusinessCategories", catBag);
        } else {
            this.removeProperty("advancedBusinessCategories");
        }
        if (siNodeIds != null) {
            Vector<ListElement> busServiceInterfaces = (Vector<ListElement>)formToolPI.getProperty("advancedBusinessServiceInterfaces");
            if (busServiceInterfaces == null) {
                busServiceInterfaces = new Vector<ListElement>();
            } else {
                busServiceInterfaces.removeAllElements();
            }
            Vector busServiceInterfacesCopy = (Vector)formToolPI.getProperty("advancedBusinessServiceInterfacesCopy");
            Vector<String> tModelKeyStringVector = new Vector<String>();
            Hashtable<String, Boolean> resultHash = new Hashtable<String, Boolean>();
            int i2 = 0;
            while (i2 < siNodeIds.length) {
                resultHash.put(siNodeIds[i2], Boolean.TRUE);
                ++i2;
            }
            i2 = 0;
            while (i2 < busServiceInterfacesCopy.size()) {
                ListElement listElement = (ListElement)busServiceInterfacesCopy.elementAt(i2);
                if (resultHash.get(String.valueOf(listElement.getTargetNodeId())) != null) {
                    busServiceInterfaces.addElement(listElement);
                    TModel tModel = (TModel)listElement.getObject();
                    tModelKeyStringVector.addElement(tModel.getTModelKey());
                }
                ++i2;
            }
            TModelBag tModelBag = new TModelBag(tModelKeyStringVector);
            this.propertyTable_.put("advancedBusinessServiceInterfaces", busServiceInterfaces);
            this.propertyTable_.put("advancedBusinessTModelBag", tModelBag);
        } else {
            this.removeProperty("advancedBusinessServiceInterfaces");
            this.removeProperty("advancedBusinessTModelBag");
        }
        if (discoveryURLValues != null) {
            DiscoveryURLs discoveryURLs = new DiscoveryURLs();
            Vector<DiscoveryURL> discoveryURLVector = new Vector<DiscoveryURL>();
            int i3 = 0;
            while (i3 < discoveryURLValues.length) {
                DiscoveryURL discoveryURL = new DiscoveryURL(discoveryURLValues[i3], "");
                discoveryURLVector.addElement(discoveryURL);
                ++i3;
            }
            discoveryURLs.setDiscoveryURLVector(discoveryURLVector);
            this.propertyTable_.put("advancedBusinessDiscoveryURLs", discoveryURLs);
        } else {
            this.removeProperty("advancedBusinessDiscoveryURLs");
        }
        if (findQualifierValues != null) {
            FindQualifiers findQualifiers = new FindQualifiers();
            Vector<FindQualifier> findQualifierVector = new Vector<FindQualifier>();
            int i4 = 0;
            while (i4 < findQualifierValues.length) {
                FindQualifier findQualifier = new FindQualifier(findQualifierValues[i4]);
                findQualifierVector.addElement(findQualifier);
                ++i4;
            }
            findQualifiers.setFindQualifierVector(findQualifierVector);
            this.propertyTable_.put("advancedBusinessFindQualifiers", findQualifiers);
        } else {
            this.removeProperty("advancedBusinessFindQualifiers");
        }
        if (maxSearchSet != null) {
            this.propertyTable_.put("advancedBusinessMaxSearchSet", maxSearchSet);
        }
        if (!this.subQueryInitiated_ && !Validator.validateInteger(maxSearchSet)) {
            formToolPI.flagError("advancedBusinessMaxSearchSet");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_MAX_SEARCH_SET"));
            inputsValid = false;
        }
        if (maxResults != null) {
            this.propertyTable_.put("advancedBusinessMaxResults", maxResults);
        }
        if (!this.subQueryInitiated_ && !Validator.validateInteger(maxResults)) {
            formToolPI.flagError("advancedBusinessMaxResults");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_MAX_RESULTS"));
            inputsValid = false;
        }
        return inputsValid;
    }

    private DiscoveryURLs dupDiscoveryURLs(DiscoveryURLs discoveryURLs, String useType, String dupUseType) {
        if (discoveryURLs == null) {
            return discoveryURLs;
        }
        Vector discoveryURLVector = discoveryURLs.getDiscoveryURLVector();
        if (discoveryURLVector == null) {
            return discoveryURLs;
        }
        Vector<DiscoveryURL> newDiscoveryURLVector = new Vector<DiscoveryURL>(discoveryURLVector);
        Enumeration e = discoveryURLVector.elements();
        while (e.hasMoreElements()) {
            DiscoveryURL discoveryURL = (DiscoveryURL)e.nextElement();
            if (!discoveryURL.getUseType().equals(useType)) continue;
            newDiscoveryURLVector.add(new DiscoveryURL(discoveryURL.getText(), dupUseType));
        }
        DiscoveryURLs newDiscoveryURLs = new DiscoveryURLs();
        newDiscoveryURLs.setDiscoveryURLVector(newDiscoveryURLVector);
        return newDiscoveryURLs;
    }

    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        try {
            boolean shouldAddQueryNode = this.propertyTable_.get("overrideAddQueryNode") == null;
            FindQualifiers findQualifiers = (FindQualifiers)this.propertyTable_.get("advancedBusinessFindQualifiers");
            Vector nameVector = (Vector)this.propertyTable_.get("advancedBusinessNames");
            DiscoveryURLs discoveryURLs = (DiscoveryURLs)this.propertyTable_.get("advancedBusinessDiscoveryURLs");
            IdentifierBag identifierBag = (IdentifierBag)this.propertyTable_.get("advancedBusinessIdentifiers");
            CategoryBag categoryBag = (CategoryBag)this.propertyTable_.get("advancedBusinessCategories");
            TModelBag tModelBag = (TModelBag)this.propertyTable_.get("advancedBusinessTModelBag");
            boolean owned = this.propertyTable_.get("advancedBusinessOwned") != null;
            String publishURL = (String)this.propertyTable_.get("advancedPublishURL");
            String userId = (String)this.propertyTable_.get("advancedUserId");
            String password = (String)this.propertyTable_.get("advancedPassword");
            int maxSearchSet = Integer.parseInt((String)this.propertyTable_.get("advancedBusinessMaxSearchSet"));
            int maxResults = Integer.parseInt((String)this.propertyTable_.get("advancedBusinessMaxResults"));
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            if (owned && !regElement.isLoggedIn()) {
                regElement.performLogin(publishURL, userId, password);
            }
            UDDIProxy proxy = regElement.getProxy();
            BusinessInfos busInfos = null;
            busInfos = owned ? proxy.get_registeredInfo(regElement.getAuthInfoString()).getBusinessInfos() : proxy.find_business(nameVector, this.dupDiscoveryURLs(discoveryURLs, "", "businessEntity"), identifierBag, categoryBag, tModelBag, findQualifiers, maxSearchSet).getBusinessInfos();
            int finalNumberOfBusinessEntities = Math.min(maxResults, busInfos.size());
            Vector<String> businessKeys = new Vector<String>();
            int i = 0;
            while (i < finalNumberOfBusinessEntities) {
                BusinessInfo busInfo = busInfos.get(i);
                businessKeys.addElement(busInfo.getBusinessKey());
                ++i;
            }
            if (finalNumberOfBusinessEntities > 0) {
                if (shouldAddQueryNode) {
                    Vector beVector = proxy.get_businessDetail(businessKeys).getBusinessEntityVector();
                    BusinessEntity[] beList = new BusinessEntity[beVector.size()];
                    beVector.toArray(beList);
                    String queryName = (String)this.propertyTable_.get("queryName");
                    this.queryElement_ = new QueryElement(beList, queryName, regElement.getModel());
                    this.addQueryNode();
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_BUSINESSES_FOUND", String.valueOf(beList.length)));
                }
                return true;
            }
            throw new FormInputException(uddiPerspective.getMessage("MSG_ERROR_NO_BUSINESSES_FOUND"));
        }
        catch (TransportException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("TransportException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (UDDIException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (FormInputException e) {
            messageQueue.addMessage(e.getMessage());
        }
        catch (MalformedURLException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("MalformedURLException");
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

