/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.actions.FormInputException;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormToolPropertiesInterface;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.FindAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.QueryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.transport.TransportException;

public class RegFindBusinessesSimpleAction
extends FindAction {
    public RegFindBusinessesSimpleAction(Controller controller) {
        super(controller);
        this.propertyTable_.put("queryItem", String.valueOf(0));
        this.propertyTable_.put("queryStyleBusinesses", String.valueOf(0));
    }

    protected final boolean processOthers(MultipartFormDataParser parser, FormToolPropertiesInterface formToolPI) throws MultipartFormDataException {
        String name = parser.getParameter("simpleBusinessName");
        boolean inputsValid = true;
        if (name != null) {
            this.propertyTable_.put("simpleBusinessName", name);
        } else {
            inputsValid = false;
        }
        return inputsValid;
    }

    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        try {
            boolean shouldAddQueryNode = this.propertyTable_.get("overrideAddQueryNode") == null;
            String name = (String)this.propertyTable_.get("simpleBusinessName");
            Vector<Name> nameVector = new Vector<Name>();
            nameVector.addElement(new Name(name));
            this.getSelectedNavigatorNode();
            RegistryElement regElement = (RegistryElement)this.regNode_.getTreeElement();
            UDDIProxy proxy = regElement.getProxy();
            BusinessInfos busInfos = proxy.find_business(nameVector, null, null, null, null, null, 100).getBusinessInfos();
            int finalNumberOfBusinessEntities = Math.min(10, busInfos.size());
            Vector<String> businessKeys = new Vector<String>();
            int i = 0;
            while (i < finalNumberOfBusinessEntities) {
                BusinessInfo busInfo = busInfos.get(i);
                businessKeys.addElement(busInfo.getBusinessKey());
                ++i;
            }
            if (finalNumberOfBusinessEntities > 0) {
                if (shouldAddQueryNode) {
                    Vector beVector = proxy.get_businessDetail(businessKeys).getBusinessEntityVector();
                    BusinessEntity[] beList = new BusinessEntity[beVector.size()];
                    beVector.toArray(beList);
                    String queryName = (String)this.propertyTable_.get("queryName");
                    this.queryElement_ = new QueryElement(beList, queryName, regElement.getModel());
                    this.addQueryNode();
                    messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_BUSINESSES_FOUND", String.valueOf(beList.length)));
                }
                return true;
            }
            throw new FormInputException(uddiPerspective.getMessage("MSG_ERROR_NO_BUSINESSES_FOUND"));
        }
        catch (TransportException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("TransportException");
            messageQueue.addMessage(e.getMessage());
        }
        catch (UDDIException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("UDDIException");
            messageQueue.addMessage(e.toString());
        }
        catch (FormInputException e) {
            messageQueue.addMessage(e.getMessage());
        }
        return false;
    }
}

