/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.tests;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorWorkingCopy;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IRequestListener;
import org.eclipse.wst.internet.monitor.core.internal.provisional.MonitorCore;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;
import org.eclipse.wst.internet.monitor.core.tests.OrderedTestSuite;

public class RequestTestCase
extends TestCase {
    private static IMonitor monitor;
    protected static IMonitor monitorEvent;
    protected static Request requestEvent;
    protected static int addCount;
    protected static int changeCount;
    protected static IRequestListener listener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        listener = new IRequestListener(){

            public void requestAdded(IMonitor monitor2, Request request2) {
                monitorEvent = monitor2;
                requestEvent = request2;
                ++addCount;
            }

            public void requestChanged(IMonitor monitor2, Request request2) {
                monitorEvent = monitor2;
                requestEvent = request2;
                ++changeCount;
            }
        };
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.internet.monitor.core.tests.RequestTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new OrderedTestSuite(clazz, "RequestTestCase");
    }

    public void test00GetMonitors() throws Exception {
        RequestTestCase.assertNotNull((Object)MonitorCore.getMonitors());
    }

    public void test01CreateMonitor() throws Exception {
        IMonitorWorkingCopy wc = MonitorCore.createMonitor();
        wc.setLocalPort(22152);
        wc.setRemoteHost("www.eclipse.org");
        wc.setRemotePort(80);
        monitor = wc.save();
        RequestTestCase.assertTrue((monitor != null ? 1 : 0) != 0);
        RequestTestCase.assertTrue((MonitorCore.getMonitors().length == 1 ? 1 : 0) != 0);
        RequestTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
        RequestTestCase.assertTrue((!monitor.isWorkingCopy() ? 1 : 0) != 0);
    }

    public void test03AddListener() throws Exception {
        monitor.addRequestListener(listener);
    }

    public void test04AddListener() throws Exception {
        monitor.addRequestListener(listener);
    }

    public void test05StartMonitor() throws Exception {
        RequestTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
        monitor.start();
        RequestTestCase.assertTrue((boolean)monitor.isRunning());
    }

    public void test06Ping() throws Exception {
        URL url = new URL("http://localhost:22152/");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        System.out.println("Response from www.eclipse.org ----------------------------------");
        InputStream in = conn.getInputStream();
        byte[] b = new byte[256];
        int n = in.read(b);
        System.out.println(new String(b));
        while (n >= 0) {
            n = in.read(b);
            System.out.println(new String(b));
        }
        in.close();
        System.out.println("End of response from www.eclipse.org ---------------------------");
    }

    public void test07CheckListener() throws Exception {
        RequestTestCase.assertEquals((int)addCount, (int)1);
        RequestTestCase.assertEquals((Object)monitorEvent, (Object)monitor);
        RequestTestCase.assertNotNull((Object)requestEvent);
    }

    public void test08VerifyMonitor() throws Exception {
        RequestTestCase.assertEquals((Object)requestEvent.getMonitor(), (Object)monitor);
    }

    public void test09VerifyProtocol() throws Exception {
        RequestTestCase.assertEquals((String)requestEvent.getProtocol(), (String)"HTTP");
    }

    public void test10VerifyTime() throws Exception {
        RequestTestCase.assertTrue((Math.abs(requestEvent.getDate().getTime() - System.currentTimeMillis()) < 60000L ? 1 : 0) != 0);
    }

    public void test11VerifyLocalPort() throws Exception {
        RequestTestCase.assertEquals((int)requestEvent.getLocalPort(), (int)22152);
    }

    public void test12VerifyRemoteHost() throws Exception {
        RequestTestCase.assertEquals((String)requestEvent.getRemoteHost(), (String)"www.eclipse.org");
    }

    public void test13VerifyRemotePort() throws Exception {
        RequestTestCase.assertEquals((int)requestEvent.getRemotePort(), (int)80);
    }

    public void test14VerifyRequest() throws Exception {
        RequestTestCase.assertNotNull((Object)requestEvent.getRequest(3));
    }

    public void test15VerifyResponse() throws Exception {
        RequestTestCase.assertNotNull((Object)requestEvent.getResponse(3));
    }

    public void test16VerifyResponseTime() throws Exception {
        RequestTestCase.assertTrue((requestEvent.getResponseTime() > 0L ? 1 : 0) != 0);
    }

    public void test17CheckRequest() throws Exception {
        RequestTestCase.assertNotNull((Object)requestEvent.getName());
    }

    public void test18CheckRequest() throws Exception {
        RequestTestCase.assertNull((Object)requestEvent.getProperty("test"));
    }

    public void test19AddToRequest() throws Exception {
        requestEvent.addToRequest(new byte[0]);
    }

    public void test20AddToResponse() throws Exception {
        requestEvent.addToResponse(new byte[0]);
    }

    public void test21SetProperty() throws Exception {
        requestEvent.setProperty("test", null);
    }

    public void test22GetAdapter() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RequestTestCase.assertNull((Object)requestEvent.getAdapter((Class)clazz));
    }

    public void test23StopMonitor() throws Exception {
        RequestTestCase.assertTrue((boolean)monitor.isRunning());
        monitor.stop();
        RequestTestCase.assertTrue((!monitor.isRunning() ? 1 : 0) != 0);
    }

    public void test24RemoveListener() throws Exception {
        monitor.removeRequestListener(listener);
    }

    public void test25Create() {
        new Request(null, null, 0, null, 0);
    }

    public void test26TestProtectedMethods() {
        Request mr = new Request(null, null, 0, null, 0){

            public Object getAdapter(Class c) {
                this.setName("test");
                this.setRequest(null);
                this.setResponse(null);
                this.fireChangedEvent();
                return null;
            }
        };
        mr.getAdapter(null);
    }
}

