/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding.xml;

import java.io.IOException;
import java.io.Reader;
import junit.framework.TestCase;
import org.eclipse.wst.xml.core.internal.contenttype.HeadParserToken;
import org.eclipse.wst.xml.core.internal.contenttype.XMLHeadTokenizer;
import org.eclipse.wst.xml.tests.encoding.TestsPlugin;

public class XMLHeadTokenizerTester
extends TestCase {
    private boolean DEBUG = false;
    private final String fileDir = "xml/";
    private final String fileHome = "testfiles/";
    private final String fileLocation = "testfiles/xml/";
    private String fEncoding = null;
    private HeadParserToken fFinalToken;

    private void doTestFile(String filename, String expectedName) {
        this.doTestFile(filename, expectedName, null);
    }

    private void doTestFile(String filename, String expectedName, String expectedFinalTokenType) {
        XMLHeadTokenizer tokenizer = null;
        Reader fileReader = null;
        try {
            if (this.DEBUG) {
                System.out.println();
                System.out.println("       " + filename);
                System.out.println();
            }
            fileReader = TestsPlugin.getByteReader(filename);
            tokenizer = new XMLHeadTokenizer(fileReader);
        }
        catch (IOException iOException) {
            System.out.println("Error opening file \"" + filename + "\"");
        }
        String resultValue = null;
        try {
            this.parse(tokenizer);
            resultValue = this.fEncoding;
            if (this.DEBUG) {
                System.out.println("XML Head Tokenizer Found Encoding: " + resultValue);
            }
            fileReader.close();
        }
        catch (IOException e) {
            System.out.println("An I/O error occured while scanning :");
            System.out.println(e);
        }
        if (expectedFinalTokenType != null) {
            XMLHeadTokenizerTester.assertTrue((String)("did not end as expected. found:  " + this.fFinalToken.getType()), (boolean)expectedFinalTokenType.equals(this.fFinalToken.getType()));
        } else if (expectedName == null) {
            XMLHeadTokenizerTester.assertTrue((String)("expected no encoding, but found: " + resultValue), (resultValue == null ? 1 : 0) != 0);
        } else {
            XMLHeadTokenizerTester.assertTrue((String)("expected " + expectedName + " but found " + resultValue), (boolean)expectedName.equals(resultValue));
        }
    }

    private void parse(XMLHeadTokenizer tokenizer) throws IOException {
        HeadParserToken token = null;
        String tokenType = null;
        do {
            if ((tokenType = (token = tokenizer.getNextToken()).getType()) == "UTF16BE") {
                this.fEncoding = "UTF16BEInStream";
            }
            if (tokenType == "UTF16LE") {
                this.fEncoding = "UTF16LEInStream";
            }
            if (tokenType == "UTF83ByteBOM") {
                this.fEncoding = "UTF83ByteBOMInStream";
            }
            if (tokenType != "XMLDelEncoding" || !tokenizer.hasMoreTokens() || !this.isLegalString(tokenType = (token = tokenizer.getNextToken()).getType())) continue;
            this.fEncoding = token.getText();
        } while (tokenizer.hasMoreTokens());
        this.fFinalToken = token;
    }

    private boolean isLegalString(String tokenType) {
        boolean result = false;
        if (tokenType != null) {
            result = tokenType.equals("strval") || tokenType.equals("UnDelimitedStringValue") || tokenType.equals("InvalidTerminatedStringValue") || tokenType.equals("InvalidTermintatedUnDelimitedStringValue");
        }
        return result;
    }

    public void testBestCase() {
        String filename = "testfiles/xml/testNormalCase.xml";
        this.doTestFile(filename, "UTF-8");
    }

    public void testUTF16() {
        String filename = "testfiles/xml/testUTF16.xml";
        this.doTestFile(filename, "UTF16BEInStream");
    }

    public void testEmptyFile() {
        String filename = "testfiles/xml/EmptyFile.xml";
        this.doTestFile(filename, null);
    }

    public void testEUCJP() {
        String filename = "testfiles/xml/eucjp.xml";
        this.doTestFile(filename, "EUC-JP");
    }

    public void testExtraAttrCase() {
        String filename = "testfiles/xml/testExtraValidStuff.xml";
        this.doTestFile(filename, "UTF-8");
    }

    public void testExtraJunkCase() {
        String filename = "testfiles/xml/testExtraJunk.xml";
        this.doTestFile(filename, "ISO-8859-1");
    }

    public void testIllFormed() {
        String filename = "testfiles/xml/testIllFormed.xml";
        this.doTestFile(filename, null);
    }

    public void testIllFormed2() {
        String filename = "testfiles/xml/testIllFormed2.xml";
        this.doTestFile(filename, "UTF-8");
    }

    public void testIllFormed3() {
        String filename = "testfiles/xml/testIllFormed3.xml";
        this.doTestFile(filename, "UTF-8 standalone=");
    }

    public void testIllFormed4() {
        String filename = "testfiles/xml/testIllFormed4.xml";
        this.doTestFile(filename, "UTF-8");
    }

    public void testIllformedNormalNonDefault() {
        String filename = "testfiles/xml/IllformedNormalNonDefault.xml";
        this.doTestFile(filename, "ISO-8859-1");
    }

    public void testMalformedNoEncoding() {
        String filename = "testfiles/xml/MalformedNoEncoding.xml";
        this.doTestFile(filename, "");
    }

    public void testMalformedNoEncodingXSL() {
        String filename = "testfiles/xml/MalformedNoEncoding.xsl";
        this.doTestFile(filename, "");
    }

    public void testMultiLineCase() {
        String filename = "testfiles/xml/testMultiLine.xml";
        this.doTestFile(filename, "ISO-8859-1");
    }

    public void testNoEncoding() {
        String filename = "testfiles/xml/NoEncoding.xml";
        this.doTestFile(filename, null);
    }

    public void testNoEncodingCase() {
        String filename = "testfiles/xml/testNoEncodingValue.xml";
        this.doTestFile(filename, null);
    }

    public void testNormalNonDefault() {
        String filename = "testfiles/xml/NormalNonDefault.xml";
        this.doTestFile(filename, "ISO-8859-1");
    }

    public void testNoXMLDecl() {
        String filename = "testfiles/xml/testNoXMLDecl.xml";
        this.doTestFile(filename, null);
    }

    public void testNoXMLDeclAtFirst() {
        String filename = "testfiles/xml/testNoXMLDeclAtFirst.xml";
        this.doTestFile(filename, null);
    }

    public void testNoXMLDeclInLargeFile() {
        String filename = "testfiles/xml/testNoXMLDeclInLargeFile.xml";
        this.doTestFile(filename, null, "MAX_CHARS_REACHED");
    }

    public void testshiftjis() {
        String filename = "testfiles/xml/shiftjis.xml";
        this.doTestFile(filename, "Shift_JIS");
    }

    public void testUTF16LEWithJapaneseChars() {
        String filename = "testfiles/xml/utf16UnicodeStreamWithNoEncodingInHeader2.xml";
        this.doTestFile(filename, "UTF16LEInStream");
    }

    public void testUTF16BEWithJapaneseChars() {
        String filename = "testfiles/xml/utf16UnicodeStreamWithNoEncodingInHeaderBE.xml";
        this.doTestFile(filename, "UTF16BEInStream");
    }

    public void testUTF8With3ByteBOM() {
        String filename = "testfiles/xml/UTF8With3ByteBOM.xml";
        this.doTestFile(filename, "UTF83ByteBOMInStream");
    }

    public void UTF16LEAtStartOfLargeFile() {
        String filename = "testfiles/xml/UTF16LEAtStartOfLargeFile.xml";
        this.doTestFile(filename, "UTF16LEInStream");
    }
}

