/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests;

import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.binding.soap.SOAPAddress;
import org.eclipse.wst.wsdl.binding.soap.SOAPBinding;
import org.eclipse.wst.wsdl.binding.soap.SOAPBody;
import org.eclipse.wst.wsdl.binding.soap.SOAPFactory;
import org.eclipse.wst.wsdl.binding.soap.SOAPOperation;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;

public class WSDLGenerationTest
extends TestCase {
    public WSDLGenerationTest() {
        this.init();
    }

    public WSDLGenerationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new WSDLGenerationTest("SampleWSDLGeneration"){

            protected void runTest() {
                this.testSampleWSDLGeneration();
            }
        });
        return suite;
    }

    public void testSampleWSDLGeneration() {
        try {
            this.generateTemperatureService("./TemperatureService.wsdl");
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void generateTemperatureService(String outputFile) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)outputFile));
        resourceSet.getResources().add((Object)resource);
        Definition definition = WSDLFactory.eINSTANCE.createDefinition();
        definition.setQName(new QName("http://schemas.xmlsoap.org/wsdl/", "Temparature"));
        resource.getContents().add((Object)definition);
        definition.setTargetNamespace("http://www.temperature.com");
        definition.addNamespace("tns", "http://www.temperature.com");
        definition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        definition.getNamespaces().put("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        Part part = WSDLFactory.eINSTANCE.createPart();
        part.setName("ZipCode");
        part.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        Message inputMessage = WSDLFactory.eINSTANCE.createMessage();
        inputMessage.setQName(new QName(definition.getTargetNamespace(), "GetTemparatureInput"));
        inputMessage.addPart((javax.wsdl.Part)part);
        definition.addMessage((javax.wsdl.Message)inputMessage);
        part = WSDLFactory.eINSTANCE.createPart();
        part.setName("Temperature");
        part.setTypeName(new QName("http://www.w3.org/2001/XMLSchema", "float"));
        Message outputMessage = WSDLFactory.eINSTANCE.createMessage();
        outputMessage.setQName(new QName(definition.getTargetNamespace(), "GetTemparatureOutput"));
        outputMessage.addPart((javax.wsdl.Part)part);
        definition.addMessage((javax.wsdl.Message)outputMessage);
        Input input = WSDLFactory.eINSTANCE.createInput();
        input.setMessage((javax.wsdl.Message)inputMessage);
        Output output = WSDLFactory.eINSTANCE.createOutput();
        output.setMessage((javax.wsdl.Message)outputMessage);
        Operation operation = WSDLFactory.eINSTANCE.createOperation();
        operation.setName("GetTemperatureForZipCode");
        operation.setInput((javax.wsdl.Input)input);
        operation.setOutput((javax.wsdl.Output)output);
        PortType portType = WSDLFactory.eINSTANCE.createPortType();
        portType.setQName(new QName(definition.getTargetNamespace(), "GetTemparatureInfoSOAP"));
        portType.addOperation((javax.wsdl.Operation)operation);
        definition.addPortType((javax.wsdl.PortType)portType);
        Binding binding = WSDLFactory.eINSTANCE.createBinding();
        binding.setQName(new QName(definition.getTargetNamespace(), "GetTemparatureInfoSOAP"));
        binding.setPortType((javax.wsdl.PortType)portType);
        definition.addBinding((javax.wsdl.Binding)binding);
        SOAPBinding soapBinding = SOAPFactory.eINSTANCE.createSOAPBinding();
        soapBinding.setStyle("rpc");
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        BindingOperation bindingOperation = WSDLFactory.eINSTANCE.createBindingOperation();
        bindingOperation.setName("GetTemperatureForZipCode");
        binding.addBindingOperation((javax.wsdl.BindingOperation)bindingOperation);
        SOAPOperation soapOperation = SOAPFactory.eINSTANCE.createSOAPOperation();
        soapOperation.setSoapActionURI("http://www.temperature.com/GetTemperatureForZipCode");
        bindingOperation.addExtensibilityElement((ExtensibilityElement)soapOperation);
        SOAPBody soapBody = SOAPFactory.eINSTANCE.createSOAPBody();
        soapBody.setUse("encoded");
        soapBody.getEncodingStyles().add("http://schemas.xmlsoap.org/soap/encoding/");
        soapBody.setNamespaceURI("http://www.temperature.com/");
        BindingInput bindingInput = WSDLFactory.eINSTANCE.createBindingInput();
        bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
        bindingOperation.setBindingInput((javax.wsdl.BindingInput)bindingInput);
        soapBody = SOAPFactory.eINSTANCE.createSOAPBody();
        soapBody.setUse("encoded");
        soapBody.getEncodingStyles().add("http://schemas.xmlsoap.org/soap/encoding/");
        soapBody.setNamespaceURI("http://www.temperature.com/");
        BindingOutput bindingOuput = WSDLFactory.eINSTANCE.createBindingOutput();
        bindingOuput.addExtensibilityElement((ExtensibilityElement)soapBody);
        bindingOperation.setBindingOutput((javax.wsdl.BindingOutput)bindingOuput);
        SOAPAddress soapAddress = SOAPFactory.eINSTANCE.createSOAPAddress();
        soapAddress.setLocationURI("http://todo-some-address/");
        Port port = WSDLFactory.eINSTANCE.createPort();
        port.setName("GetTemperatureInfoSOAP");
        port.setBinding((javax.wsdl.Binding)binding);
        port.addExtensibilityElement((ExtensibilityElement)soapAddress);
        Service service = WSDLFactory.eINSTANCE.createService();
        service.setQName(new QName(definition.getTargetNamespace(), "TemperatureService"));
        service.addPort((javax.wsdl.Port)port);
        definition.addService((javax.wsdl.Service)service);
        resource.save(null);
    }

    private void init() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
    }
}

