/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.viewers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.viewers.NamedComponentViewer;
import org.eclipse.wst.wsdl.ui.internal.viewers.widgets.InvokeDialogButton;
import org.w3c.dom.Element;

public class PartViewer
extends NamedComponentViewer {
    protected CCombo componentNameCombo;
    protected CCombo referenceKindCombo;
    protected Label componentNameLabel;
    InvokeDialogButton button;

    public PartViewer(Composite parent, IEditorPart editorPart) {
        super(parent, editorPart);
    }

    protected String getHeadingText() {
        return WSDLEditorPlugin.getWSDLString("_UI_LABEL_PART");
    }

    public boolean isObjectExtensible() {
        return false;
    }

    protected Composite populatePrimaryDetailsSection(Composite parent) {
        Composite composite = super.populatePrimaryDetailsSection(parent);
        this.flatViewUtility.createLabel(composite, WSDLEditorPlugin.getWSDLString("_UI_LABEL_REFERENCE_KIND"));
        this.referenceKindCombo = this.flatViewUtility.createCComboBox(composite);
        this.referenceKindCombo.add("element");
        this.referenceKindCombo.add("type");
        this.referenceKindCombo.setText("type");
        this.referenceKindCombo.addListener(24, (Listener)this);
        this.flatViewUtility.createLabel(composite, "");
        this.componentNameLabel = this.flatViewUtility.createLabel(composite, WSDLEditorPlugin.getWSDLString("_UI_LABEL_ELEMENT"));
        this.componentNameCombo = this.flatViewUtility.createCComboBox(composite);
        this.componentNameCombo.addListener(24, (Listener)this);
        this.componentNameCombo.addSelectionListener((SelectionListener)this);
        this.button = new InvokeDialogButton(composite, this.getInput());
        return composite;
    }

    protected void update() {
        try {
            Part part = (Part)this.input;
            boolean isType = ComponentReferenceUtil.isType(part);
            String value = ComponentReferenceUtil.getPartComponentReference(part);
            this.componentNameCombo.removeAll();
            List compList = ComponentReferenceUtil.getComponentNameList(part, isType);
            if (compList != null) {
                Iterator iterator = compList.iterator();
                while (iterator.hasNext()) {
                    this.componentNameCombo.add((String)iterator.next());
                }
            }
            if (isType) {
                this.referenceKindCombo.setText("type");
                this.componentNameLabel.setText(WSDLEditorPlugin.getWSDLString("_UI_LABEL_TYPE"));
                this.componentNameCombo.setText(value != null ? value : "");
                this.button.setReferenceKind("type");
            } else {
                this.referenceKindCombo.setText("element");
                this.componentNameLabel.setText(WSDLEditorPlugin.getWSDLString("_UI_LABEL_ELEMENT"));
                this.componentNameCombo.setText(value != null ? value : "");
                this.button.setReferenceKind("element");
            }
            this.button.setInput(this.input);
            this.button.setEditor(this.editorPart);
            super.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleEventHelper(Element element, Event event) {
        super.handleEventHelper(element, event);
        if (event.type == 24 && event.widget == this.referenceKindCombo) {
            DelayedRenameRunnable runnable = new DelayedRenameRunnable((Part)this.input);
            Display.getCurrent().asyncExec((Runnable)runnable);
        }
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.componentNameCombo) {
            Part part = (Part)this.input;
            boolean isType = this.referenceKindCombo.getText().equals("type");
            ComponentReferenceUtil.setComponentReference(part, isType, this.componentNameCombo.getText());
        }
    }

    protected class DelayedRenameRunnable
    implements Runnable {
        Part part;

        DelayedRenameRunnable(Part part) {
            this.part = part;
        }

        public void run() {
            boolean isType = PartViewer.this.referenceKindCombo.getText().equals("type");
            ComponentReferenceUtil.setComponentReference(this.part, isType, null);
        }
    }
}

